/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.document.Field;
import gate.creole.annic.apache.lucene.index.FieldInfo;
import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.InputStream;
import java.io.IOException;

final class FieldsReader {
    private FieldInfos fieldInfos;
    private InputStream fieldsStream;
    private InputStream indexStream;
    private int size;

    FieldsReader(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        this.fieldInfos = fieldInfos;
        this.fieldsStream = directory.openFile(string + ".fdt");
        this.indexStream = directory.openFile(string + ".fdx");
        this.size = (int)(this.indexStream.length() / 8L);
    }

    final void close() throws IOException {
        this.fieldsStream.close();
        this.indexStream.close();
    }

    final int size() {
        return this.size;
    }

    final Document doc(int n) throws IOException {
        this.indexStream.seek((long)n * 8L);
        long l = this.indexStream.readLong();
        this.fieldsStream.seek(l);
        Document document = new Document();
        int n2 = this.fieldsStream.readVInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.fieldsStream.readVInt();
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(n3);
            byte by = this.fieldsStream.readByte();
            document.add(new Field(fieldInfo.name, this.fieldsStream.readString(), true, fieldInfo.isIndexed, (by & 1) != 0, fieldInfo.storeTermVector));
        }
        return document;
    }
}

