/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.analysis.Analyzer;
import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.analysis.TokenStream;
import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.document.Field;
import gate.creole.annic.apache.lucene.index.FieldInfo;
import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.index.FieldsWriter;
import gate.creole.annic.apache.lucene.index.Posting;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermInfo;
import gate.creole.annic.apache.lucene.index.TermInfosWriter;
import gate.creole.annic.apache.lucene.index.TermVectorsWriter;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.OutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

final class DocumentWriter {
    private Analyzer analyzer;
    private Directory directory;
    private Similarity similarity;
    private FieldInfos fieldInfos;
    private int maxFieldLength;
    private final Hashtable postingTable = new Hashtable();
    private int[] fieldLengths;
    private int[] fieldPositions;
    private float[] fieldBoosts;
    private final Term termBuffer = new Term("", "", "");

    DocumentWriter(Directory directory, Analyzer analyzer, Similarity similarity, int n) {
        this.directory = directory;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.maxFieldLength = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDocument(String string, Document document) throws IOException {
        this.fieldInfos = new FieldInfos();
        this.fieldInfos.add(document);
        this.fieldInfos.write(this.directory, string + ".fnm");
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, string, this.fieldInfos);
        try {
            fieldsWriter.addDocument(document);
        }
        finally {
            fieldsWriter.close();
        }
        this.postingTable.clear();
        this.fieldLengths = new int[this.fieldInfos.size()];
        this.fieldPositions = new int[this.fieldInfos.size()];
        this.fieldBoosts = new float[this.fieldInfos.size()];
        Arrays.fill(this.fieldBoosts, document.getBoost());
        this.invertDocument(document);
        Posting[] postingArray = this.sortPostingTable();
        this.writePostings(postingArray, string);
        this.writeNorms(document, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invertDocument(Document document) throws IOException {
        Enumeration enumeration = document.fields();
        while (enumeration.hasMoreElements()) {
            Field field = (Field)enumeration.nextElement();
            String string = field.name();
            int n = this.fieldInfos.fieldNumber(string);
            int n2 = this.fieldLengths[n];
            int n3 = this.fieldPositions[n];
            if (!field.isIndexed()) continue;
            if (!field.isTokenized()) {
                this.addPosition(string, field.stringValue(), "Field", n3++);
            } else {
                Reader reader;
                if (field.readerValue() != null) {
                    reader = field.readerValue();
                } else if (field.stringValue() != null) {
                    reader = new StringReader(field.stringValue());
                } else {
                    throw new IllegalArgumentException("field must have either String or Reader value");
                }
                TokenStream tokenStream = this.analyzer.tokenStream(string, reader);
                try {
                    Token token = tokenStream.next();
                    while (token != null) {
                        n3 += token.getPositionIncrement() - 1;
                        if (token.type() == null) {
                            this.addPosition(string, token.termText(), "*", n3++);
                        } else {
                            this.addPosition(string, token.termText(), token.type(), n3++);
                        }
                        if (++n2 > this.maxFieldLength) {
                            break;
                        }
                        token = tokenStream.next();
                    }
                }
                finally {
                    tokenStream.close();
                }
            }
            this.fieldLengths[n] = ++n2;
            this.fieldPositions[n] = n3;
            int n4 = n;
            this.fieldBoosts[n4] = this.fieldBoosts[n4] * field.getBoost();
        }
    }

    private final void addPosition(String string, String string2, String string3, int n) {
        this.termBuffer.set(string, string2, string3);
        Posting posting = (Posting)this.postingTable.get(this.termBuffer);
        if (posting != null) {
            int n2 = posting.freq;
            if (posting.positions.length == n2) {
                int[] nArray = new int[n2 * 2];
                int[] nArray2 = posting.positions;
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = nArray2[i];
                }
                posting.positions = nArray;
            }
            posting.positions[n2] = n;
            posting.freq = n2 + 1;
        } else {
            Term term = new Term(string, string2, string3, false);
            this.postingTable.put(term, new Posting(term, n));
        }
    }

    private final Posting[] sortPostingTable() {
        Posting[] postingArray = new Posting[this.postingTable.size()];
        Enumeration enumeration = this.postingTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            postingArray[n] = (Posting)enumeration.nextElement();
            ++n;
        }
        DocumentWriter.quickSort(postingArray, 0, postingArray.length - 1);
        return postingArray;
    }

    private static final void quickSort(Posting[] postingArray, int n, int n2) {
        int n3;
        int n4;
        Posting posting;
        if (n >= n2) {
            return;
        }
        int n5 = (n + n2) / 2;
        if (postingArray[n].term.compareTo(postingArray[n5].term) > 0) {
            posting = postingArray[n];
            postingArray[n] = postingArray[n5];
            postingArray[n5] = posting;
        }
        if (postingArray[n5].term.compareTo(postingArray[n2].term) > 0) {
            posting = postingArray[n5];
            postingArray[n5] = postingArray[n2];
            postingArray[n2] = posting;
            if (postingArray[n].term.compareTo(postingArray[n5].term) > 0) {
                Posting posting2 = postingArray[n];
                postingArray[n] = postingArray[n5];
                postingArray[n5] = posting2;
            }
        }
        if ((n4 = n + 1) >= (n3 = n2 - 1)) {
            return;
        }
        Term term = postingArray[n5].term;
        while (true) {
            if (postingArray[n3].term.compareTo(term) > 0) {
                --n3;
                continue;
            }
            while (n4 < n3 && postingArray[n4].term.compareTo(term) <= 0) {
                ++n4;
            }
            if (n4 >= n3) break;
            Posting posting3 = postingArray[n4];
            postingArray[n4] = postingArray[n3];
            postingArray[n3] = posting3;
            --n3;
        }
        DocumentWriter.quickSort(postingArray, n, n4);
        DocumentWriter.quickSort(postingArray, n4 + 1, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void writePostings(Posting[] postingArray, String string) throws IOException {
        block56: {
            IOException iOException;
            TermVectorsWriter termVectorsWriter;
            TermInfosWriter termInfosWriter;
            OutputStream outputStream;
            OutputStream outputStream2;
            block47: {
                IOException iOException22222;
                block46: {
                    block45: {
                        block44: {
                            block43: {
                                outputStream2 = null;
                                outputStream = null;
                                termInfosWriter = null;
                                termVectorsWriter = null;
                                outputStream2 = this.directory.createFile(string + ".frq");
                                outputStream = this.directory.createFile(string + ".prx");
                                termInfosWriter = new TermInfosWriter(this.directory, string, this.fieldInfos);
                                TermInfo termInfo = new TermInfo();
                                String string2 = null;
                                for (int i = 0; i < postingArray.length; ++i) {
                                    Posting posting = postingArray[i];
                                    termInfo.set(1, outputStream2.getFilePointer(), outputStream.getFilePointer(), -1);
                                    termInfosWriter.add(posting.term, termInfo);
                                    int n = posting.freq;
                                    if (n == 1) {
                                        outputStream2.writeVInt(1);
                                    } else {
                                        outputStream2.writeVInt(0);
                                        outputStream2.writeVInt(n);
                                    }
                                    int n2 = 0;
                                    int[] nArray = posting.positions;
                                    for (int j = 0; j < n; ++j) {
                                        int n3 = nArray[j];
                                        outputStream.writeVInt(n3 - n2);
                                        n2 = n3;
                                    }
                                    String string3 = posting.term.field();
                                    if (string2 != string3) {
                                        string2 = string3;
                                        FieldInfo fieldInfo = this.fieldInfos.fieldInfo(string2);
                                        if (fieldInfo.storeTermVector) {
                                            if (termVectorsWriter == null) {
                                                termVectorsWriter = new TermVectorsWriter(this.directory, string, this.fieldInfos);
                                                termVectorsWriter.openDocument();
                                            }
                                            termVectorsWriter.openField(string2);
                                        } else if (termVectorsWriter != null) {
                                            termVectorsWriter.closeField();
                                        }
                                    }
                                    if (termVectorsWriter == null || !termVectorsWriter.isFieldOpen()) continue;
                                    termVectorsWriter.addTerm(posting.term.text(), n);
                                }
                                if (termVectorsWriter == null) break block43;
                                termVectorsWriter.closeDocument();
                            }
                            Object var17_19 = null;
                            iOException = null;
                            if (outputStream2 == null) break block44;
                            try {
                                outputStream2.close();
                            }
                            catch (IOException iOException22222) {
                                if (iOException != null) break block44;
                                iOException = iOException22222;
                            }
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException22222) {
                                if (iOException != null) break block45;
                                iOException = iOException22222;
                            }
                        }
                    }
                    if (termInfosWriter != null) {
                        try {
                            termInfosWriter.close();
                        }
                        catch (IOException iOException22222) {
                            if (iOException != null) break block46;
                            iOException = iOException22222;
                        }
                    }
                }
                if (termVectorsWriter != null) {
                    try {
                        termVectorsWriter.close();
                    }
                    catch (IOException iOException22222) {
                        if (iOException != null) break block47;
                        iOException = iOException22222;
                    }
                }
            }
            if (iOException != null) {
                throw (IOException)iOException.fillInStackTrace();
            }
            break block56;
            {
                catch (Exception exception) {
                    IOException iOException3;
                    block51: {
                        IOException iOException42222;
                        block50: {
                            block49: {
                                block48: {
                                    exception.printStackTrace();
                                    Object var17_20 = null;
                                    iOException3 = null;
                                    if (outputStream2 != null) {
                                        try {
                                            outputStream2.close();
                                        }
                                        catch (IOException iOException42222) {
                                            if (iOException3 != null) break block48;
                                            iOException3 = iOException42222;
                                        }
                                    }
                                }
                                if (outputStream != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (IOException iOException42222) {
                                        if (iOException3 != null) break block49;
                                        iOException3 = iOException42222;
                                    }
                                }
                            }
                            if (termInfosWriter != null) {
                                try {
                                    termInfosWriter.close();
                                }
                                catch (IOException iOException42222) {
                                    if (iOException3 != null) break block50;
                                    iOException3 = iOException42222;
                                }
                            }
                        }
                        if (termVectorsWriter != null) {
                            try {
                                termVectorsWriter.close();
                            }
                            catch (IOException iOException42222) {
                                if (iOException3 != null) break block51;
                                iOException3 = iOException42222;
                            }
                        }
                    }
                    if (iOException3 != null) {
                        throw (IOException)iOException3.fillInStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                IOException iOException5;
                block55: {
                    IOException iOException62222;
                    block54: {
                        block53: {
                            block52: {
                                Object var17_21 = null;
                                iOException5 = null;
                                if (outputStream2 != null) {
                                    try {
                                        outputStream2.close();
                                    }
                                    catch (IOException iOException62222) {
                                        if (iOException5 != null) break block52;
                                        iOException5 = iOException62222;
                                    }
                                }
                            }
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (IOException iOException62222) {
                                    if (iOException5 != null) break block53;
                                    iOException5 = iOException62222;
                                }
                            }
                        }
                        if (termInfosWriter != null) {
                            try {
                                termInfosWriter.close();
                            }
                            catch (IOException iOException62222) {
                                if (iOException5 != null) break block54;
                                iOException5 = iOException62222;
                            }
                        }
                    }
                    if (termVectorsWriter != null) {
                        try {
                            termVectorsWriter.close();
                        }
                        catch (IOException iOException62222) {
                            if (iOException5 != null) break block55;
                            iOException5 = iOException62222;
                        }
                    }
                }
                if (iOException5 != null) {
                    throw (IOException)iOException5.fillInStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeNorms(Document document, String string) throws IOException {
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(i);
            if (!fieldInfo.isIndexed) continue;
            float f = this.fieldBoosts[i] * this.similarity.lengthNorm(fieldInfo.name, this.fieldLengths[i]);
            OutputStream outputStream = this.directory.createFile(string + ".f" + i);
            try {
                outputStream.writeByte(Similarity.encodeNorm(f));
                continue;
            }
            finally {
                outputStream.close();
            }
        }
    }
}

