/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.analysis.standard;

import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.analysis.TokenFilter;
import gate.creole.annic.apache.lucene.analysis.TokenStream;
import gate.creole.annic.apache.lucene.analysis.standard.StandardTokenizerConstants;
import java.io.IOException;

public final class StandardFilter
extends TokenFilter
implements StandardTokenizerConstants {
    private static final String APOSTROPHE_TYPE = tokenImage[2];
    private static final String ACRONYM_TYPE = tokenImage[3];

    public StandardFilter(TokenStream tokenStream) {
        super(tokenStream);
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        String string = token.termText();
        String string2 = token.type();
        if (string2 == APOSTROPHE_TYPE && (string.endsWith("'s") || string.endsWith("'S"))) {
            return new Token(string.substring(0, string.length() - 2), token.startOffset(), token.endOffset(), string2);
        }
        if (string2 == ACRONYM_TYPE) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '.') continue;
                stringBuffer.append(c);
            }
            return new Token(stringBuffer.toString(), token.startOffset(), token.endOffset(), string2);
        }
        return token;
    }
}

