/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.analysis.standard;

import gate.creole.annic.apache.lucene.analysis.standard.CharStream;
import java.io.IOException;
import java.io.Reader;

public final class FastCharStream
implements CharStream {
    char[] buffer = null;
    int bufferLength = 0;
    int bufferPosition = 0;
    int tokenStart = 0;
    int bufferStart = 0;
    Reader input;

    public FastCharStream(Reader reader) {
        this.input = reader;
    }

    public final char readChar() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    private final void refill() throws IOException {
        int n = this.bufferLength - this.tokenStart;
        if (this.tokenStart == 0) {
            if (this.buffer == null) {
                this.buffer = new char[2048];
            } else if (this.bufferLength == this.buffer.length) {
                char[] cArray = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, cArray, 0, this.bufferLength);
                this.buffer = cArray;
            }
        } else {
            System.arraycopy(this.buffer, this.tokenStart, this.buffer, 0, n);
        }
        this.bufferLength = n;
        this.bufferPosition = n;
        this.bufferStart += this.tokenStart;
        this.tokenStart = 0;
        int n2 = this.input.read(this.buffer, n, this.buffer.length - n);
        if (n2 == -1) {
            throw new IOException("read past eof");
        }
        this.bufferLength += n2;
    }

    public final char BeginToken() throws IOException {
        this.tokenStart = this.bufferPosition;
        return this.readChar();
    }

    public final void backup(int n) {
        this.bufferPosition -= n;
    }

    public final String GetImage() {
        return new String(this.buffer, this.tokenStart, this.bufferPosition - this.tokenStart);
    }

    public final char[] GetSuffix(int n) {
        char[] cArray = new char[n];
        System.arraycopy(this.buffer, this.bufferPosition - n, cArray, 0, n);
        return cArray;
    }

    public final void Done() {
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            System.err.println("Caught: " + iOException + "; ignoring.");
        }
    }

    public final int getColumn() {
        return this.bufferStart + this.bufferPosition;
    }

    public final int getLine() {
        return 1;
    }

    public final int getEndColumn() {
        return this.bufferStart + this.bufferPosition;
    }

    public final int getEndLine() {
        return 1;
    }

    public final int getBeginColumn() {
        return this.bufferStart + this.tokenStart;
    }

    public final int getBeginLine() {
        return 1;
    }
}

