/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.analysis;

import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.analysis.TokenFilter;
import gate.creole.annic.apache.lucene.analysis.TokenStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public final class StopFilter
extends TokenFilter {
    private Set stopWords;

    public StopFilter(TokenStream tokenStream, String[] stringArray) {
        super(tokenStream);
        this.stopWords = StopFilter.makeStopSet(stringArray);
    }

    public StopFilter(TokenStream tokenStream, Hashtable hashtable) {
        super(tokenStream);
        this.stopWords = new HashSet(hashtable.keySet());
    }

    public StopFilter(TokenStream tokenStream, Set set) {
        super(tokenStream);
        this.stopWords = set;
    }

    public static final Hashtable makeStopTable(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], stringArray[i]);
        }
        return hashtable;
    }

    public static final Set makeStopSet(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            if (!this.stopWords.contains(token.termText)) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }
}

