/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic;

import gate.creole.annic.Hit;
import gate.creole.annic.Pattern;
import gate.creole.annic.PatternAnnotation;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Parser {
    public static final String HITS = "HITS";
    public static final String HIT = "HIT";
    public static final String DOC_ID = "DOC_ID";
    public static final String START_OFFSET = "START_OFFSET";
    public static final String END_OFFSET = "END_OFFSET";
    public static final String QUERY = "QUERY";
    public static final String LEFT_CONTEXT_START_OFFSET = "LEFT_CONTEXT_START_OFFSET";
    public static final String RIGHT_CONTEXT_END_OFFSET = "RIGHT_CONTEXT_END_OFFSET";
    public static final String PATTERN_TEXT = "PATTERN_TEXT";
    public static final String PATTERN_ANNOTATIONS = "PATTERN_ANNOTATIONS";
    public static final String PATTERN_ANNOTATION = "PATTERN_ANNOTATION";
    public static final String START = "START";
    public static final String END = "END";
    public static final String TEXT = "TEXT";
    public static final String TYPE = "TYPE";
    public static final String POSITION = "POSITION";
    public static final String FEATURES = "FEATURES";
    public static final String FEATURE = "FEATURE";
    public static final String KEY = "KEY";
    public static final String VALUE = "VALUE";

    public static String toXML(Hit[] hitArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>\n");
        stringBuffer.append(Parser.wrap(HITS, true));
        for (int i = 0; i < hitArray.length; ++i) {
            stringBuffer.append(Parser.wrap(HIT, true));
            stringBuffer.append(Parser.wrap(DOC_ID, hitArray[i].documentID));
            stringBuffer.append(Parser.wrap(START_OFFSET, hitArray[i].startOffset));
            stringBuffer.append(Parser.wrap(END_OFFSET, hitArray[i].endOffset));
            stringBuffer.append(Parser.wrap(QUERY, hitArray[i].queryString));
            if (hitArray[i] instanceof Pattern) {
                Pattern pattern = (Pattern)hitArray[i];
                stringBuffer.append(Parser.wrap(LEFT_CONTEXT_START_OFFSET, pattern.getLeftContextStartOffset()));
                stringBuffer.append(Parser.wrap(RIGHT_CONTEXT_END_OFFSET, pattern.getRightContextEndOffset()));
                stringBuffer.append(Parser.wrap(PATTERN_TEXT, pattern.getPatternText()));
                PatternAnnotation[] patternAnnotationArray = pattern.getPatternAnnotations();
                stringBuffer.append(Parser.wrap(PATTERN_ANNOTATIONS, true));
                for (int j = 0; j < patternAnnotationArray.length; ++j) {
                    Set<String> set;
                    stringBuffer.append(Parser.wrap(PATTERN_ANNOTATION, true));
                    stringBuffer.append(Parser.wrap(START, patternAnnotationArray[j].getStartOffset()));
                    stringBuffer.append(Parser.wrap(END, patternAnnotationArray[j].getEndOffset()));
                    stringBuffer.append(Parser.wrap(TEXT, patternAnnotationArray[j].getText()));
                    stringBuffer.append(Parser.wrap(TYPE, patternAnnotationArray[j].getType()));
                    stringBuffer.append(Parser.wrap(POSITION, patternAnnotationArray[j].getPosition()));
                    HashMap<String, String> hashMap = patternAnnotationArray[j].getFeatures();
                    stringBuffer.append(Parser.wrap(FEATURES, true));
                    if (hashMap != null && (set = hashMap.keySet()) != null) {
                        Iterator<String> iterator = set.iterator();
                        while (iterator.hasNext()) {
                            stringBuffer.append(Parser.wrap(FEATURE, true));
                            String string = iterator.next();
                            stringBuffer.append(Parser.wrap(KEY, string));
                            String string2 = hashMap.get(string);
                            stringBuffer.append(Parser.wrap(VALUE, string2));
                            stringBuffer.append(Parser.wrap(FEATURE, false));
                        }
                    }
                    stringBuffer.append(Parser.wrap(FEATURES, false));
                    stringBuffer.append(Parser.wrap(PATTERN_ANNOTATION, false));
                }
                stringBuffer.append(Parser.wrap(PATTERN_ANNOTATIONS, false));
            }
            stringBuffer.append(Parser.wrap(HIT, false));
        }
        stringBuffer.append(Parser.wrap(HITS, false));
        return stringBuffer.toString();
    }

    public static String replaceAmpChars(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&apos;");
        return string;
    }

    public static Hit[] fromXML(String string) throws IOException, JDOMException {
        SAXBuilder sAXBuilder = new SAXBuilder(false);
        Document document = sAXBuilder.build((Reader)new StringReader(string));
        Element element = document.getRootElement();
        if (!element.getName().equalsIgnoreCase(HITS)) {
            throw new IOException("Root element must be HITS");
        }
        List list = element.getChildren(HIT);
        Hit[] hitArray = new Hit[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            int n = Integer.parseInt(element2.getChildText(START_OFFSET));
            int n2 = Integer.parseInt(element2.getChildText(END_OFFSET));
            String string2 = element2.getChildText(DOC_ID);
            String string3 = element2.getChildText(QUERY);
            Element element3 = element2.getChild(PATTERN_ANNOTATIONS);
            if (element3 == null) {
                hitArray[i] = new Hit(string2, n, n2, string3);
                continue;
            }
            List list2 = element3.getChildren(PATTERN_ANNOTATION);
            ArrayList<PatternAnnotation> arrayList = new ArrayList<PatternAnnotation>();
            for (int j = 0; j < list2.size(); ++j) {
                Element element4 = (Element)list2.get(j);
                PatternAnnotation patternAnnotation = new PatternAnnotation();
                patternAnnotation.setStOffset(Integer.parseInt(element4.getChildText(START)));
                patternAnnotation.setEnOffset(Integer.parseInt(element4.getChildText(END)));
                patternAnnotation.setPosition(Integer.parseInt(element4.getChildText(POSITION)));
                patternAnnotation.setText(element4.getChildText(TEXT));
                patternAnnotation.setType(element4.getChildText(TYPE));
                Element element5 = element4.getChild(FEATURES);
                List list3 = element5.getChildren(FEATURE);
                for (int k = 0; k < list3.size(); ++k) {
                    Element element6 = (Element)list3.get(k);
                    String string4 = element6.getChildText(KEY);
                    String string5 = element6.getChildText(VALUE);
                    patternAnnotation.addFeature(string4, string5);
                }
                arrayList.add(patternAnnotation);
            }
            String string6 = element2.getChildText(PATTERN_TEXT);
            int n3 = Integer.parseInt(element2.getChildText(LEFT_CONTEXT_START_OFFSET));
            int n4 = Integer.parseInt(element2.getChildText(RIGHT_CONTEXT_END_OFFSET));
            hitArray[i] = new Pattern(string2, string6, n, n2, n3, n4, arrayList, string3);
        }
        return hitArray;
    }

    public static String wrap(String string, String string2) {
        if (string2 == null) {
            return "<" + string + "> </" + string + ">\n";
        }
        return "<" + string + ">" + Parser.replaceAmpChars(string2) + "</" + string + ">\n";
    }

    public static String wrap(String string, int n) {
        return Parser.wrap(string, "" + n);
    }

    public static String wrap(String string, boolean bl) {
        return "<" + (bl ? "" : "/") + string + ">\n";
    }
}

