/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.AnnotationSet;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.TestDocument;
import gate.creole.ANNIETransducer;
import gate.creole.POSTagger;
import gate.creole.gazetteer.DefaultGazetteer;
import gate.creole.orthomatcher.OrthoMatcher;
import gate.creole.splitter.SentenceSplitter;
import gate.creole.tokeniser.DefaultTokeniser;
import gate.util.AnnotationDiffer;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPR
extends TestCase {
    private static final boolean DEBUG = false;
    protected static Document doc1;
    protected static Document doc2;
    protected static Document doc3;
    protected static List annotationTypes;

    public TestPR(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testTokenizer() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        DefaultTokeniser defaultTokeniser = (DefaultTokeniser)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser", featureMap);
        defaultTokeniser.setDocument(doc1);
        defaultTokeniser.execute();
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().size() + " Token annotations, instead of the expected 1281."), (doc1.getAnnotations().size() == 1281 ? 1 : 0) != 0);
        defaultTokeniser.setDocument(doc2);
        defaultTokeniser.execute();
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().size() + " Token annotations, instead of the expected 2135."), (doc2.getAnnotations().size() == 2135 ? 1 : 0) != 0);
        defaultTokeniser.setDocument(doc3);
        defaultTokeniser.execute();
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().size() + " Token annotations, instead of the expected 2806."), (doc3.getAnnotations().size() == 2806 ? 1 : 0) != 0);
        Factory.deleteResource(defaultTokeniser);
    }

    public void testGazetteer() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        DefaultGazetteer defaultGazetteer = (DefaultGazetteer)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer", featureMap);
        defaultGazetteer.setDocument(doc1);
        defaultGazetteer.execute();
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Lookup").size() + " Lookup annotations, instead of the expected 65."), (doc1.getAnnotations().get("Lookup").size() == 65 ? 1 : 0) != 0);
        defaultGazetteer.setDocument(doc2);
        defaultGazetteer.execute();
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Lookup").size() + " Lookup annotations, instead of the expected 139."), (doc2.getAnnotations().get("Lookup").size() == 139 ? 1 : 0) != 0);
        defaultGazetteer.setDocument(doc3);
        defaultGazetteer.execute();
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Lookup").size() + " Lookup annotations, instead of the expected 145."), (doc3.getAnnotations().get("Lookup").size() == 145 ? 1 : 0) != 0);
        Factory.deleteResource(defaultGazetteer);
    }

    public void testSplitter() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        SentenceSplitter sentenceSplitter = (SentenceSplitter)Factory.createResource("gate.creole.splitter.SentenceSplitter", featureMap);
        sentenceSplitter.setDocument(doc1);
        sentenceSplitter.execute();
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Sentence").size() + " Sentence annotations, instead of the expected 21."), (doc1.getAnnotations().get("Sentence").size() == 21 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Split").size() + " Split annotations, instead of the expected 38."), (doc1.getAnnotations().get("Split").size() == 38 ? 1 : 0) != 0);
        sentenceSplitter.setDocument(doc2);
        sentenceSplitter.execute();
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Sentence").size() + " Sentence annotations, instead of the expected 51."), (doc2.getAnnotations().get("Sentence").size() == 51 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Split").size() + " Split annotations, instead of the expected 74."), (doc2.getAnnotations().get("Split").size() == 74 ? 1 : 0) != 0);
        sentenceSplitter.setDocument(doc3);
        sentenceSplitter.execute();
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Sentence").size() + " Sentence annotations, instead of the expected 66."), (doc3.getAnnotations().get("Sentence").size() == 66 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Split").size() + " Split annotations, instead of the expected 84."), (doc3.getAnnotations().get("Split").size() == 84 ? 1 : 0) != 0);
        Factory.deleteResource(sentenceSplitter);
    }

    public void testTagger() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        POSTagger pOSTagger = (POSTagger)Factory.createResource("gate.creole.POSTagger", featureMap);
        pOSTagger.setDocument(doc1);
        pOSTagger.execute();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("category");
        AnnotationSet annotationSet = doc1.getAnnotations().get("Token", hashSet);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + annotationSet.size() + " Token annotations with category feature, instead of the expected 677."), (annotationSet.size() == 677 ? 1 : 0) != 0);
        pOSTagger.setDocument(doc2);
        pOSTagger.execute();
        annotationSet = doc2.getAnnotations().get("Token", hashSet);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + annotationSet.size() + " Token annotations with category feature, instead of the expected 1133."), (annotationSet.size() == 1133 ? 1 : 0) != 0);
        pOSTagger.setDocument(doc3);
        pOSTagger.execute();
        annotationSet = doc3.getAnnotations().get("Token", hashSet);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + annotationSet.size() + " Token annotations with category feature, instead of the expected 1446."), (annotationSet.size() == 1446 ? 1 : 0) != 0);
        Factory.deleteResource(pOSTagger);
    }

    public void testTransducer() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        ANNIETransducer aNNIETransducer = (ANNIETransducer)Factory.createResource("gate.creole.ANNIETransducer", featureMap);
        aNNIETransducer.setDocument(doc1);
        aNNIETransducer.execute();
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Organization").size() + " Organization annotations, instead of the expected 26"), (doc1.getAnnotations().get("Organization").size() == 26 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Location").size() + " Location annotations, instead of the expected 3"), (doc1.getAnnotations().get("Location").size() == 3 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Person").size() + " Person annotations, instead of the expected 1"), (doc1.getAnnotations().get("Person").size() == 1 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Date").size() + " Date annotations, instead of the expected 7"), (doc1.getAnnotations().get("Date").size() == 7 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + doc1.getAnnotations().get("Money").size() + " Money annotations, instead of the expected 1"), (doc1.getAnnotations().get("Money").size() == 1 ? 1 : 0) != 0);
        aNNIETransducer.setDocument(doc2);
        aNNIETransducer.execute();
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Organization").size() + " Organization annotations, instead of the expected 23"), (doc2.getAnnotations().get("Organization").size() == 24 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Location").size() + " Location annotations, instead of the expected 11"), (doc2.getAnnotations().get("Location").size() == 11 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Person").size() + " Person annotations, instead of the expected 1"), (doc2.getAnnotations().get("Person").size() == 1 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Date").size() + " Date annotations, instead of the expected 8"), (doc2.getAnnotations().get("Date").size() == 8 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + doc2.getAnnotations().get("Money").size() + " Money annotations, instead of the expected 3"), (doc2.getAnnotations().get("Money").size() == 3 ? 1 : 0) != 0);
        aNNIETransducer.setDocument(doc3);
        aNNIETransducer.execute();
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Organization").size() + " Organization annotations, instead of the expected 29"), (doc3.getAnnotations().get("Organization").size() == 32 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Location").size() + " Location annotations, instead of the expected 11"), (doc3.getAnnotations().get("Location").size() == 11 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Person").size() + " Person annotations, instead of the expected 8"), (doc3.getAnnotations().get("Person").size() == 8 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Date").size() + " Date annotations, instead of the expected 7"), (doc3.getAnnotations().get("Date").size() == 7 ? 1 : 0) != 0);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + doc3.getAnnotations().get("Money").size() + " Money annotations, instead of the expected 4"), (doc3.getAnnotations().get("Money").size() == 4 ? 1 : 0) != 0);
        Factory.deleteResource(aNNIETransducer);
    }

    public void testOrthomatcher() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        OrthoMatcher orthoMatcher = (OrthoMatcher)Factory.createResource("gate.creole.orthomatcher.OrthoMatcher", featureMap);
        orthoMatcher.setDocument(doc1);
        orthoMatcher.execute();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("matches");
        AnnotationSet annotationSet = doc1.getAnnotations().get(null, hashSet);
        TestPR.assertTrue((String)("Found in " + doc1.getSourceUrl().getFile() + " " + annotationSet.size() + " annotations with matches feature, instead of the expected 36."), (annotationSet.size() == 36 ? 1 : 0) != 0);
        orthoMatcher.setDocument(doc2);
        orthoMatcher.execute();
        annotationSet = doc2.getAnnotations().get(null, hashSet);
        TestPR.assertTrue((String)("Found in " + doc2.getSourceUrl().getFile() + " " + annotationSet.size() + " annotations with matches feature, instead of the expected 38."), (annotationSet.size() == 38 ? 1 : 0) != 0);
        orthoMatcher.setDocument(doc3);
        orthoMatcher.execute();
        annotationSet = doc3.getAnnotations().get(null, hashSet);
        TestPR.assertTrue((String)("Found in " + doc3.getSourceUrl().getFile() + " " + annotationSet.size() + " annotations with matches feature, instead of the expected 39."), (annotationSet.size() == 39 ? 1 : 0) != 0);
        Factory.deleteResource(orthoMatcher);
    }

    public void testAllPR() throws Exception {
        Serializable serializable;
        String string = Gate.locateGateFiles();
        if (string.endsWith("/bin/gate.jar!/")) {
            serializable = new StringBuffer(string.substring(0, string.lastIndexOf("bin/gate.jar!/")));
            ((StringBuffer)serializable).append("classes/");
            ((StringBuffer)serializable).delete(0, "jar:file:".length());
            ((StringBuffer)serializable).insert(0, "file://");
            string = ((StringBuffer)serializable).toString();
        }
        serializable = new URL(string + "gate/resources/gate.ac.uk/");
        URL uRL = null;
        uRL = new URL((URL)serializable, "tests/ft");
        DataStore dataStore = Factory.openDataStore("gate.persist.SerialDataStore", uRL.toExternalForm());
        String string2 = (String)dataStore.getLrIds("gate.corpora.DocumentImpl").get(0);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", dataStore);
        featureMap.put("LRPersistenceId", string2);
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        this.compareAnnots(document, doc1);
        uRL = null;
        uRL = new URL((URL)serializable, "tests/gu");
        dataStore = Factory.openDataStore("gate.persist.SerialDataStore", uRL.toExternalForm());
        string2 = (String)dataStore.getLrIds("gate.corpora.DocumentImpl").get(0);
        featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", dataStore);
        featureMap.put("LRPersistenceId", string2);
        document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        this.compareAnnots(document, doc2);
        uRL = null;
        uRL = new URL((URL)serializable, "tests/in");
        dataStore = Factory.openDataStore("gate.persist.SerialDataStore", uRL.toExternalForm());
        string2 = (String)dataStore.getLrIds("gate.corpora.DocumentImpl").get(0);
        featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", dataStore);
        featureMap.put("LRPersistenceId", string2);
        document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        this.compareAnnots(document, doc3);
    }

    public void compareAnnots(Document document, Document document2) throws Exception {
        for (String string : annotationTypes) {
            AnnotationDiffer annotationDiffer = new AnnotationDiffer();
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList("NMRule", "kind", "orgType", "rule", "rule1", "rule2", "locType", "gender", "majorType", "minorType", "category", "length", "orth", "string", "subkind", "symbolkind"));
            annotationDiffer.setSignificantFeaturesSet(hashSet);
            annotationDiffer.calculateDiff(document.getAnnotations().get(string), document2.getAnnotations().get(string));
            TestPR.assertTrue((String)(string + " precision strict in " + document2.getSourceUrl().getFile() + " is " + annotationDiffer.getPrecisionStrict() + " instead of 1.0 "), (annotationDiffer.getPrecisionStrict() == 1.0 ? 1 : 0) != 0);
            TestPR.assertTrue((String)(string + " recall strict in " + document2.getSourceUrl().getFile() + " is " + annotationDiffer.getRecallStrict() + " instead of 1.0 "), (annotationDiffer.getRecallStrict() == 1.0 ? 1 : 0) != 0);
            TestPR.assertTrue((String)(string + " f-measure strict in " + document2.getSourceUrl().getFile() + " is " + annotationDiffer.getFMeasureStrict(0.5) + " instead of 1.0 "), (annotationDiffer.getFMeasureStrict(0.5) == 1.0 ? 1 : 0) != 0);
        }
    }

    public static Test suite() {
        return new TestSuite(TestPR.class);
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
            TestPR testPR = new TestPR("");
            testPR.setUp();
            testPR.testTokenizer();
            testPR.testGazetteer();
            testPR.testSplitter();
            testPR.testTagger();
            testPR.testTransducer();
            testPR.testOrthomatcher();
            testPR.testAllPR();
            testPR.tearDown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        annotationTypes = new ArrayList(10);
        annotationTypes.add("Sentence");
        annotationTypes.add("Organization");
        annotationTypes.add("Location");
        annotationTypes.add("Person");
        annotationTypes.add("Date");
        annotationTypes.add("Money");
        annotationTypes.add("Lookup");
        annotationTypes.add("Token");
        try {
            if (doc1 == null) {
                doc1 = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/ft-bt-03-aug-2001.html"), "ISO-8859-1");
            }
            if (doc2 == null) {
                doc2 = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/gu-Am-Brit-4-aug-2001.html"), "ISO-8859-1");
            }
            if (doc3 == null) {
                doc3 = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/in-outlook-09-aug-2001.html"), "ISO-8859-1");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

