/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractController;
import gate.creole.AbstractResource;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.ControllerEvent;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.StatusListener;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.profile.Profiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SerialController
extends AbstractController
implements CreoleListener {
    private static final boolean DEBUG = false;
    protected Profiler prof;
    protected List prList = Collections.synchronizedList(new ArrayList());
    protected StatusListener sListener = new AbstractController.InternalStatusListener();

    public SerialController() {
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    public Collection getPRs() {
        return Collections.unmodifiableList(this.prList);
    }

    public void setPRs(Collection collection) {
        this.prList.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add((ProcessingResource)iterator.next());
        }
    }

    public void add(int n, ProcessingResource processingResource) {
        this.prList.add(n, processingResource);
        this.fireResourceAdded(new ControllerEvent(this, 0, processingResource));
    }

    public void add(ProcessingResource processingResource) {
        this.prList.add(processingResource);
        this.fireResourceAdded(new ControllerEvent(this, 0, processingResource));
    }

    public ProcessingResource remove(int n) {
        ProcessingResource processingResource = (ProcessingResource)this.prList.remove(n);
        this.fireResourceRemoved(new ControllerEvent(this, 1, processingResource));
        return processingResource;
    }

    public boolean remove(ProcessingResource processingResource) {
        boolean bl = this.prList.remove(processingResource);
        if (bl) {
            this.fireResourceRemoved(new ControllerEvent(this, 1, processingResource));
        }
        return bl;
    }

    public ProcessingResource set(int n, ProcessingResource processingResource) {
        return this.prList.set(n, processingResource);
    }

    protected void checkParameters() throws ExecutionException {
        List list;
        try {
            list = this.getOffendingPocessingResources();
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new ExecutionException("Could not check runtime parameters for the processing resources:\n" + resourceInstantiationException.toString());
        }
        if (list != null && !list.isEmpty()) {
            throw new ExecutionException("Some of the processing resources in this controller have unset runtime parameters:\n" + list.toString());
        }
    }

    protected void executeImpl() throws ExecutionException {
        this.checkParameters();
        this.interrupted = false;
        for (int i = 0; i < this.prList.size(); ++i) {
            if (this.isInterrupted()) {
                throw new ExecutionInterruptedException("The execution of the " + this.getName() + " application has been abruptly interrupted!");
            }
            this.runComponent(i);
        }
    }

    protected void runComponent(int n) throws ExecutionException {
        ProcessingResource processingResource = (ProcessingResource)this.prList.get(n);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("gate.event.StatusListener", this.sListener);
        int n2 = 100 / this.prList.size();
        featureMap.put("gate.event.ProgressListener", new AbstractController.IntervalProgressListener(n * n2, (n + 1) * n2));
        try {
            AbstractResource.setResourceListeners(processingResource, featureMap);
        }
        catch (Exception exception) {
            Err.prln("Could not set listeners for " + processingResource.getClass().getName() + "\n" + exception.toString() + "\n...nothing to lose any sleep over.");
        }
        processingResource.execute();
        try {
            AbstractResource.removeResourceListeners(processingResource, featureMap);
        }
        catch (Exception exception) {
            Err.prln("Could not clear listeners for " + processingResource.getClass().getName() + "\n" + exception.toString() + "\n...nothing to lose any sleep over.");
        }
    }

    public void cleanup() {
        if (this.prList != null && !this.prList.isEmpty()) {
            Iterator iterator = new ArrayList(this.prList).iterator();
            while (iterator.hasNext()) {
                Factory.deleteResource((Resource)iterator.next());
            }
        }
        Gate.getCreoleRegister().removeCreoleListener(this);
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        if (creoleEvent.getResource() instanceof ProcessingResource) {
            while (this.remove((ProcessingResource)creoleEvent.getResource())) {
            }
        }
        for (int i = 0; i < this.prList.size(); ++i) {
            ProcessingResource processingResource = (ProcessingResource)this.prList.get(i);
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
            if (resourceData == null) continue;
            for (List<Parameter> list : resourceData.getParameterList().getRuntimeParameters()) {
                for (Parameter parameter : list) {
                    String string = parameter.getName();
                    try {
                        if (processingResource.getParameterValue(string) != creoleEvent.getResource()) continue;
                        processingResource.setParameterValue(string, null);
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        throw new GateRuntimeException(resourceInstantiationException);
                    }
                }
            }
        }
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
    }
}

