/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.LanguageAnalyser;
import gate.ProcessingResource;
import gate.creole.AbstractResource;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.SerialController;
import gate.event.CreoleEvent;
import gate.util.GateRuntimeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SerialAnalyserController
extends SerialController
implements CorpusController {
    private static final boolean DEBUG = false;
    protected Corpus corpus;

    public Corpus getCorpus() {
        return this.corpus;
    }

    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    protected void executeImpl() throws ExecutionException {
        this.interrupted = false;
        if (this.corpus == null) {
            throw new ExecutionException("(SerialAnalyserController) \"" + this.getName() + "\":\n" + "The corpus supplied for execution was null!");
        }
        for (int i = 0; i < this.corpus.size(); ++i) {
            int n;
            if (this.isInterrupted()) {
                throw new ExecutionInterruptedException("The execution of the " + this.getName() + " application has been abruptly interrupted!");
            }
            boolean bl = this.corpus.isDocumentLoaded(i);
            Document document = (Document)this.corpus.get(i);
            for (n = 0; n < this.prList.size(); ++n) {
                ((LanguageAnalyser)this.prList.get(n)).setDocument(document);
                ((LanguageAnalyser)this.prList.get(n)).setCorpus(this.corpus);
            }
            super.executeImpl();
            for (n = 0; n < this.prList.size(); ++n) {
                ((LanguageAnalyser)this.prList.get(n)).setDocument(null);
                ((LanguageAnalyser)this.prList.get(n)).setCorpus(null);
            }
            if (bl) continue;
            this.corpus.unloadDocument(document);
            Factory.deleteResource(document);
        }
    }

    public void add(ProcessingResource processingResource) {
        if (!(processingResource instanceof LanguageAnalyser)) {
            throw new GateRuntimeException(this.getClass().getName() + "only accepts " + LanguageAnalyser.class.getName() + "s as components\n" + processingResource.getClass().getName() + " is not!");
        }
        super.add(processingResource);
    }

    protected void setDocToPrs(Document document) {
        Iterator iterator = this.getPRs().iterator();
        while (iterator.hasNext()) {
            ((LanguageAnalyser)iterator.next()).setDocument(document);
        }
    }

    public List getOffendingPocessingResources() throws ResourceInstantiationException {
        ArrayList arrayList = new ArrayList(this.getPRs());
        for (ProcessingResource processingResource : this.getPRs()) {
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
            List<List<Parameter>> list = resourceData.getParameterList().getRuntimeParameters();
            ArrayList<ArrayList<Parameter>> arrayList2 = new ArrayList<ArrayList<Parameter>>();
            for (List<Parameter> list2 : list) {
                ArrayList<Parameter> arrayList3 = new ArrayList<Parameter>(list2);
                Iterator iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    Parameter parameter = (Parameter)iterator.next();
                    if (!parameter.getName().equals("corpus") && !parameter.getName().equals("document")) continue;
                    iterator.remove();
                }
                if (arrayList3.isEmpty()) continue;
                arrayList2.add(arrayList3);
            }
            if (!AbstractResource.checkParameterValues(processingResource, arrayList2)) continue;
            arrayList.remove(processingResource);
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        super.resourceUnloaded(creoleEvent);
        if (creoleEvent.getResource() == this.corpus) {
            this.setCorpus(null);
        }
    }
}

