/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.ParameterException;
import gate.creole.ResourceData;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Parameter
implements Serializable {
    String typeName;
    boolean optional = false;
    String itemClassName = null;
    Set suffixes = null;
    static Map<Class, Class> substituteClasses = new HashMap<Class, Class>();
    protected ResourceData resData;
    String defaultValueString;
    String comment;
    String name;
    boolean runtime = false;
    protected URL baseURL;
    protected Class paramClass;

    public Parameter(URL uRL) {
        this.baseURL = uRL;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Object calculateDefaultValue() throws ParameterException {
        if (this.defaultValueString == null && this.typeName != null && this.typeName.startsWith("java.")) {
            return null;
        }
        return this.calculateValueFromString(this.defaultValueString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object calculateValueFromString(String string) throws ParameterException {
        Boolean bl = null;
        Class clazz = this.getParameterClass();
        if (substituteClasses.containsKey(clazz)) {
            clazz = substituteClasses.get(clazz);
        }
        if (Collection.class.isAssignableFrom(clazz) && !clazz.isInterface()) {
            Collection collection = null;
            try {
                collection = (Collection)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new ParameterException("Could not construct an object of type " + this.typeName + " for param " + this.name + "\nProblem was: " + exception.toString());
            }
            if (this.itemClassName == null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    collection.add(string2);
                }
                return collection;
            }
            Class<?> clazz2 = null;
            try {
                clazz2 = Gate.getClassLoader().loadClass(this.itemClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ParameterException("Could not construct a class object for " + this.itemClassName + " for param " + this.name + ", with type name=" + this.typeName);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                Object e = null;
                try {
                    e = clazz2.getConstructor(String.class).newInstance(string3);
                }
                catch (Exception exception) {
                    throw new ParameterException("Could not create an object of " + this.itemClassName + " for param name " + this.name + ", with type name =" + this.typeName);
                }
                collection.add(e);
            }
            return collection;
        }
        if (FeatureMap.class.isAssignableFrom(clazz)) {
            if (string == null) {
                return null;
            }
            FeatureMap featureMap = null;
            if (clazz.isInterface()) {
                featureMap = Factory.newFeatureMap();
            } else {
                try {
                    featureMap = (FeatureMap)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    throw new ParameterException("Could not construct an object of type " + this.typeName + " for param " + this.name + "\nProblem was: " + exception.toString());
                }
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                int n = string4.indexOf(61);
                if (n == -1) {
                    throw new ParameterException("Error parsing string \"" + string + "\" for parameter " + this.name + " of type " + this.typeName + ". Value string must be of the form " + "name1=value1;name2=value2;...");
                }
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                featureMap.put(string5, string6);
            }
            return featureMap;
        }
        if (clazz.isEnum()) {
            if (string == null) {
                return null;
            }
            try {
                return (Boolean)Enum.valueOf(clazz, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParameterException("Invalid enum constant name " + string + " for type " + this.typeName);
            }
        }
        if (this.typeName.startsWith("java.")) {
            if (this.typeName.equals("java.lang.Boolean")) {
                return Boolean.valueOf(string);
            }
            if (this.typeName.equals("java.lang.Long")) {
                if (string == null) return bl;
                if (string.equals("")) return bl;
                return Long.valueOf(string);
            }
            if (this.typeName.equals("java.lang.Integer")) {
                if (string == null) return bl;
                if (string.equals("")) return bl;
                return Integer.valueOf(string);
            }
            if (this.typeName.equals("java.lang.String")) {
                return string;
            }
            if (this.typeName.equals("java.lang.Double")) {
                if (string == null) return bl;
                if (string.equals("")) return bl;
                return Double.valueOf(string);
            }
            if (this.typeName.equals("java.lang.Float")) {
                if (string == null) return bl;
                if (string.equals("")) return bl;
                return Float.valueOf(string);
            }
            if (this.typeName.equals("java.net.URL")) {
                try {
                    return new URL(this.baseURL, string);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            try {
                if (clazz.isAssignableFrom(String.class)) return bl;
                return clazz.getConstructor(String.class).newInstance(string);
            }
            catch (Exception exception) {
                throw new ParameterException("Unsupported parameter type " + this.typeName);
            }
        }
        if (this.resData == null) {
            this.resData = (ResourceData)Gate.getCreoleRegister().get(this.typeName);
        }
        if (this.resData == null) {
            return null;
        }
        List<Resource> list = this.resData.getInstantiations();
        if (list.isEmpty()) return bl;
        return list.get(0);
    }

    public Object getDefaultValue() throws ParameterException {
        return this.calculateDefaultValue();
    }

    public void setDefaultValueString(String string) {
        this.defaultValueString = string;
    }

    public String getDefaultValueString() {
        return this.defaultValueString;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Set getSuffixes() {
        return this.suffixes;
    }

    public void setRuntime(boolean bl) {
        this.runtime = bl;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    protected Class getParameterClass() throws ParameterException {
        try {
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(this.typeName);
            this.paramClass = resourceData == null ? Gate.getClassLoader().loadClass(this.typeName) : resourceData.getResourceClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParameterException("Couldn't find class " + this.typeName + ": " + Strings.getNl() + classNotFoundException);
        }
        if (this.paramClass == null) {
            throw new ParameterException("Couldn't find class " + this.typeName);
        }
        return this.paramClass;
    }

    public String toString() {
        try {
            return "Parameter: name=" + this.name + "; valueString=" + this.typeName + "; optional=" + this.optional + "; defaultValueString=" + this.defaultValueString + "; defaultValue=" + this.getDefaultValue() + "; comment=" + this.comment + "; runtime=" + this.runtime + "; itemClassName=" + this.itemClassName + "; suffixes=" + this.suffixes;
        }
        catch (ParameterException parameterException) {
            throw new GateRuntimeException(parameterException.toString());
        }
    }

    public String getItemClassName() {
        return this.itemClassName;
    }

    static {
        substituteClasses.put(Collection.class, ArrayList.class);
        substituteClasses.put(List.class, ArrayList.class);
        substituteClasses.put(Set.class, HashSet.class);
        substituteClasses.put(SortedSet.class, TreeSet.class);
        substituteClasses.put(Queue.class, LinkedList.class);
    }
}

