/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.util.GateRuntimeException;
import gate.util.OffsetComparator;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class POSTagger
extends AbstractLanguageAnalyser {
    public static final String TAG_DOCUMENT_PARAMETER_NAME = "document";
    public static final String TAG_INPUT_AS_PARAMETER_NAME = "inputASName";
    public static final String TAG_LEXICON_URL_PARAMETER_NAME = "lexiconURL";
    public static final String TAG_RULES_URL_PARAMETER_NAME = "rulesURL";
    public static final String TAG_ENCODING_PARAMETER_NAME = "encoding";
    public static final String BASE_TOKEN_ANNOTATION_TYPE_PARAMETER_NAME = "baseTokenAnnotationType";
    public static final String OUTPUT_ANNOTATION_TYPE_PARAMETER_NAME = "outputAnnotationType";
    public static final String BASE_SENTENCE_ANNOTATION_TYPE_PARAMETER_NAME = "baseSentenceAnnotationType";
    public static final String TAG_OUTPUT_AS_PARAMETER_NAME = "outputASName";
    protected hepple.postag.POSTagger tagger;
    private URL lexiconURL;
    private URL rulesURL;
    private String inputASName;
    private String encoding;
    private String baseTokenAnnotationType;
    private String baseSentenceAnnotationType;
    private String outputAnnotationType;
    private String outputASName;

    public Resource init() throws ResourceInstantiationException {
        if (this.lexiconURL == null) {
            throw new ResourceInstantiationException("NoURL provided for the lexicon!");
        }
        if (this.rulesURL == null) {
            throw new ResourceInstantiationException("No URL provided for the rules!");
        }
        try {
            this.tagger = new hepple.postag.POSTagger(this.lexiconURL, this.rulesURL, this.encoding);
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException(exception);
        }
        return this;
    }

    public void execute() throws ExecutionException {
        long l;
        AnnotationSet annotationSet;
        AnnotationSet annotationSet2;
        if (this.document == null) {
            throw new ExecutionException("No document to process!");
        }
        if (this.inputASName != null && this.inputASName.equals("")) {
            this.inputASName = null;
        }
        AnnotationSet annotationSet3 = annotationSet2 = this.inputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.inputASName);
        if (this.baseTokenAnnotationType == null || this.baseTokenAnnotationType.trim().length() == 0) {
            throw new ExecutionException("No base Token Annotation Type provided!");
        }
        if (this.outputASName != null && this.outputASName.equals("")) {
            this.outputASName = null;
        }
        AnnotationSet annotationSet4 = annotationSet = this.outputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputASName);
        if (this.baseSentenceAnnotationType == null || this.baseSentenceAnnotationType.trim().length() == 0) {
            throw new ExecutionException("No base Sentence Annotation Type provided!");
        }
        if (this.outputAnnotationType == null || this.outputAnnotationType.trim().length() == 0) {
            throw new ExecutionException("No AnnotationType provided to store the new feature!");
        }
        AnnotationSet annotationSet5 = annotationSet2.get(this.baseSentenceAnnotationType);
        AnnotationSet annotationSet6 = annotationSet2.get(this.baseTokenAnnotationType);
        if (annotationSet5 != null && annotationSet5.size() > 0 && annotationSet6 != null && annotationSet6.size() > 0) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            l = System.currentTimeMillis();
            this.fireStatusChanged("POS tagging " + this.document.getName());
            this.fireProgressChanged(0);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList(1);
            arrayList2.add(arrayList);
            OffsetComparator offsetComparator = new OffsetComparator();
            ArrayList<Annotation> arrayList3 = new ArrayList<Annotation>(annotationSet5);
            Collections.sort(arrayList3, offsetComparator);
            ArrayList<Annotation> arrayList4 = new ArrayList<Annotation>(annotationSet6);
            Collections.sort(arrayList4, offsetComparator);
            Iterator iterator = arrayList3.iterator();
            ListIterator listIterator = arrayList4.listIterator();
            ArrayList<Annotation> arrayList5 = new ArrayList<Annotation>();
            Annotation annotation = (Annotation)listIterator.next();
            int n = 0;
            int n2 = annotationSet5.size();
            while (iterator.hasNext()) {
                object4 = (Annotation)iterator.next();
                arrayList5.clear();
                arrayList.clear();
                while (annotation != null && annotation.getEndNode().getOffset().compareTo(object4.getEndNode().getOffset()) <= 0) {
                    arrayList5.add(annotation);
                    arrayList.add(annotation.getFeatures().get("string"));
                    annotation = listIterator.hasNext() ? listIterator.next() : null;
                }
                object3 = this.tagger.runTagger(arrayList2);
                if (object3 != null && object3.size() > 0) {
                    object2 = (List)object3.get(0);
                    if (object2.size() != arrayList5.size()) {
                        throw new ExecutionException("POS Tagger malfunction: the output size (" + object2.size() + ") is different from the input size (" + arrayList5.size() + ")!");
                    }
                    object = object2.iterator();
                    Iterator iterator2 = arrayList5.iterator();
                    while (object.hasNext()) {
                        Annotation annotation2 = (Annotation)iterator2.next();
                        this.addFeatures(annotation2, "category", ((String[])object.next())[1]);
                    }
                }
                this.fireProgressChanged(n++ * 100 / n2);
            }
            if (annotation != null) {
                arrayList5.clear();
                arrayList.clear();
                while (annotation != null) {
                    arrayList5.add(annotation);
                    arrayList.add(annotation.getFeatures().get("string"));
                    annotation = listIterator.hasNext() ? listIterator.next() : null;
                }
                object4 = (List)this.tagger.runTagger(arrayList2).get(0);
                if (object4.size() != arrayList5.size()) {
                    throw new ExecutionException("POS Tagger malfunction: the output size (" + object4.size() + ") is different from the input size (" + arrayList5.size() + ")!");
                }
                object3 = object4.iterator();
                object2 = arrayList5.iterator();
                while (object3.hasNext()) {
                    object = (Annotation)object2.next();
                    this.addFeatures((Annotation)object, "category", ((String[])object3.next())[1]);
                }
            }
        } else {
            throw new ExecutionException("No sentences or tokens to process!\nPlease run a sentence splitter and tokeniser first!");
        }
        this.fireProcessFinished();
        this.fireStatusChanged(this.document.getName() + " tagged in " + NumberFormat.getInstance().format((double)(System.currentTimeMillis() - l) / 1000.0) + " seconds!");
    }

    protected void addFeatures(Annotation annotation, String string, String string2) throws GateRuntimeException {
        String string3;
        String string4 = this.inputASName == null ? "" : this.inputASName;
        String string5 = string3 = this.outputASName == null ? "" : this.outputASName;
        if (this.outputAnnotationType.equals(this.baseTokenAnnotationType) && string4.equals(string3)) {
            annotation.getFeatures().put(string, string2);
            return;
        }
        int n = annotation.getStartNode().getOffset().intValue();
        int n2 = annotation.getEndNode().getOffset().intValue();
        AnnotationSet annotationSet = this.outputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputASName);
        AnnotationSet annotationSet2 = annotationSet.get(this.outputAnnotationType);
        if (annotationSet2 == null || annotationSet2.size() == 0) {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put(string, string2);
            try {
                annotationSet.add(new Long(n), new Long(n2), this.outputAnnotationType, featureMap);
            }
            catch (Exception exception) {
                throw new GateRuntimeException("Invalid Offsets");
            }
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet2.get());
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            Annotation annotation2 = arrayList.get(i);
            if (annotation2.getStartNode().getOffset().intValue() != n || annotation2.getEndNode().getOffset().intValue() != n2) continue;
            annotation2.getFeatures().put(string, string2);
            bl = true;
            break;
        }
        if (!bl) {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put(string, string2);
            try {
                annotationSet.add(new Long(n), new Long(n2), this.outputAnnotationType, featureMap);
            }
            catch (Exception exception) {
                throw new GateRuntimeException("Invalid Offsets");
            }
        }
    }

    public void setLexiconURL(URL uRL) {
        this.lexiconURL = uRL;
    }

    public URL getLexiconURL() {
        return this.lexiconURL;
    }

    public void setRulesURL(URL uRL) {
        this.rulesURL = uRL;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public URL getRulesURL() {
        return this.rulesURL;
    }

    public void setInputASName(String string) {
        this.inputASName = string;
    }

    public String getInputASName() {
        return this.inputASName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getBaseTokenAnnotationType() {
        return this.baseTokenAnnotationType;
    }

    public String getBaseSentenceAnnotationType() {
        return this.baseSentenceAnnotationType;
    }

    public String getOutputAnnotationType() {
        return this.outputAnnotationType;
    }

    public void setBaseTokenAnnotationType(String string) {
        this.baseTokenAnnotationType = string;
    }

    public void setBaseSentenceAnnotationType(String string) {
        this.baseSentenceAnnotationType = string;
    }

    public void setOutputAnnotationType(String string) {
        this.outputAnnotationType = string;
    }

    public String getOutputASName() {
        return this.outputASName;
    }

    public void setOutputASName(String string) {
        this.outputASName = string;
    }
}

