/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Annotation;
import gate.AnnotationSet;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.GazetteerList;
import gate.creole.gazetteer.Lookup;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class GazetteerListsCollector
extends AbstractLanguageAnalyser {
    private static String PERSON_ANNOT_NAME = "PER";
    private String markupSetName = "";
    private AnnotationSet allAnnots;
    private List annotationTypes;
    private Gazetteer gazetteer;
    private String theLanguage = "";
    private HashMap statsPerType = new HashMap();

    public void execute() throws ExecutionException {
        Object object;
        this.statsPerType = new HashMap();
        if (this.document == null) {
            throw new ExecutionException("No document to process!");
        }
        if (this.gazetteer == null) {
            throw new ExecutionException("No gazetteer set!");
        }
        if (this.annotationTypes == null || this.annotationTypes.isEmpty()) {
            Out.prln("Gazetteer Lists Collector Warning: No annotation types given for processing");
            return;
        }
        this.allAnnots = this.markupSetName == null || this.markupSetName.equals("") ? this.document.getAnnotations() : this.document.getAnnotations(this.markupSetName);
        if (this.allAnnots == null || this.allAnnots.isEmpty()) {
            Out.prln("Gazetteer Lists Collector Warning: No annotations found for processing");
            return;
        }
        for (int i = 0; i < this.annotationTypes.size(); ++i) {
            object = this.allAnnots.get((String)this.annotationTypes.get(i));
            if (object == null || object.isEmpty()) continue;
            this.statsPerType.put(this.annotationTypes.get(i), new HashMap());
            this.collectLists((AnnotationSet)object, (String)this.annotationTypes.get(i));
        }
        this.printStats();
        Map map = this.gazetteer.getLinearDefinition().getListsByNode();
        object = map.keySet().iterator();
        while (object.hasNext()) {
            GazetteerList gazetteerList = (GazetteerList)map.get(object.next());
            try {
                if (!gazetteerList.isModified()) continue;
                gazetteerList.store();
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                throw new GateRuntimeException(resourceInstantiationException.getMessage());
            }
        }
    }

    public void setMarkupASName(String string) {
        this.markupSetName = string;
    }

    public String getMarkupASName() {
        return this.markupSetName;
    }

    public List getAnnotationTypes() {
        return this.annotationTypes;
    }

    public void setAnnotationTypes(List list) {
        this.annotationTypes = list;
    }

    public Gazetteer getGazetteer() {
        return this.gazetteer;
    }

    public void setGazetteer(Gazetteer gazetteer) {
        this.gazetteer = gazetteer;
    }

    public void setTheLanguage(String string) {
        this.theLanguage = string;
    }

    public String getTheLanguage() {
        return this.theLanguage;
    }

    protected void collectLists(AnnotationSet annotationSet, String string) {
        Iterator<Annotation> iterator = annotationSet.iterator();
        String string2 = "";
        GazetteerList gazetteerList = null;
        Iterator iterator2 = this.gazetteer.getLinearDefinition().getListsByNode().values().iterator();
        while (iterator2.hasNext() && string2.equals("")) {
            gazetteerList = (GazetteerList)iterator2.next();
            if (!gazetteerList.getURL().toExternalForm().endsWith(string + ".lst")) continue;
            string2 = gazetteerList.getURL().toExternalForm();
        }
        while (iterator.hasNext()) {
            Object object;
            Annotation annotation = iterator.next();
            String string3 = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                string3 = this.document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                object = new StringTokenizer(string3, "\n\r.|();-?!\t", false);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    arrayList.add(((StringTokenizer)object).nextToken());
                }
                string3 = string3.replace('\r', ' ');
                string3 = string3.replace('\n', ' ');
                string3 = string3.replace('\t', ' ');
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException.getMessage());
            }
            if (((HashMap)this.statsPerType.get(string)).containsKey(string3)) {
                ((HashMap)this.statsPerType.get(string)).put(string3, new Integer((Integer)((HashMap)this.statsPerType.get(string)).get(string3) + 1));
            } else {
                ((HashMap)this.statsPerType.get(string)).put(string3, new Integer(1));
            }
            if (arrayList.size() > 1) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string4 = (String)arrayList.get(i);
                    if (((HashMap)this.statsPerType.get(string)).containsKey(string4)) {
                        ((HashMap)this.statsPerType.get(string)).put(string4, new Integer((Integer)((HashMap)this.statsPerType.get(string)).get(string4) + 1));
                        continue;
                    }
                    ((HashMap)this.statsPerType.get(string)).put(string4, new Integer(1));
                }
            }
            if ((object = this.gazetteer.lookup(string3)) != null && object.size() > 0) continue;
            this.gazetteer.add(string3, new Lookup(string2, string, "inferred", this.theLanguage));
            gazetteerList.add(string3);
            if (!string.equals(PERSON_ANNOT_NAME) || arrayList.size() <= 1) continue;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string5 = (String)arrayList.get(i);
                Set set = this.gazetteer.lookup(string5);
                if (set != null && set.size() > 0 || string5.length() < 3) continue;
                this.gazetteer.add(string5, new Lookup(string2, string, "inferred", this.theLanguage));
                gazetteerList.add(string5);
            }
        }
    }

    protected void printStats() {
        try {
            for (int i = 0; i < this.annotationTypes.size(); ++i) {
                if (!this.statsPerType.containsKey(this.annotationTypes.get(i))) continue;
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.annotationTypes.get(i) + ".stats.lst"), "UTF-8"));
                HashMap hashMap = (HashMap)this.statsPerType.get(this.annotationTypes.get(i));
                for (String string : hashMap.keySet()) {
                    bufferedWriter.write(string);
                    bufferedWriter.write("$");
                    bufferedWriter.write(((Integer)hashMap.get(string)).toString());
                    bufferedWriter.newLine();
                }
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    protected boolean alreadyPresentInGazetteer(String string) {
        return false;
    }
}

