/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Controller;
import gate.CreoleRegister;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.VisualResource;
import gate.creole.AnnotationVisualResource;
import gate.creole.CreoleXmlHandler;
import gate.creole.ResourceData;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.util.GateClassLoader;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.LazyProgrammerException;
import gate.util.LuckyException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreoleRegisterImpl
extends HashMap<String, ResourceData>
implements CreoleRegister,
CreoleListener {
    protected static final boolean DEBUG = false;
    protected Set<URL> directories = new HashSet<URL>();
    protected transient SAXParser parser = null;
    protected Set<String> lrTypes = new HashSet<String>();
    protected Set<String> prTypes = new HashSet<String>();
    protected List<String> vrTypes = new LinkedList<String>();
    protected Set<String> controllerTypes;
    protected Set<String> toolTypes = new HashSet<String>();
    private transient Vector creoleListeners;

    public CreoleRegisterImpl() throws GateException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(true);
            this.parser = sAXParserFactory.newSAXParser();
        }
        catch (SAXException sAXException) {
            throw new GateException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new GateException(parserConfigurationException);
        }
    }

    @Override
    public void addDirectory(URL uRL) {
        try {
            this.registerDirectories(uRL);
        }
        catch (GateException gateException) {
            throw new GateRuntimeException(gateException);
        }
    }

    @Override
    public Set getDirectories() {
        return Collections.unmodifiableSet(this.directories);
    }

    @Override
    public void registerDirectories() throws GateException {
    }

    @Override
    public void registerDirectories(URL uRL) throws GateException {
        String string = uRL.toExternalForm();
        if (string.toLowerCase().endsWith("creole.xml")) {
            throw new GateException("CREOLE directory URLs should point to the parent location of the creole.xml file, not the file itself; bad URL was: " + string);
        }
        String string2 = "/";
        if (!string.endsWith(string2)) {
            string = string + string2;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new GateRuntimeException(malformedURLException);
            }
        }
        URL uRL2 = uRL;
        try {
            uRL2 = new URL(string + "creole.xml");
        }
        catch (MalformedURLException malformedURLException) {
            throw new GateException("bad creole.xml URL, based on " + string);
        }
        if (this.directories.add(uRL)) {
            try {
                this.parseDirectory(uRL2.openStream(), uRL, uRL2);
                System.out.println("CREOLE plugin loaded: " + uRL);
            }
            catch (IOException iOException) {
                this.directories.remove(uRL);
                throw new GateException("couldn't open creole.xml: " + iOException.toString());
            }
            Gate.addKnownPlugin(uRL);
        }
    }

    protected void parseDirectory(InputStream inputStream, URL uRL, URL uRL2) throws GateException {
        try {
            CreoleXmlHandler creoleXmlHandler = new CreoleXmlHandler(this, uRL, uRL2);
            this.parser.parse(inputStream, (DefaultHandler)creoleXmlHandler);
        }
        catch (IOException iOException) {
            throw new GateException(iOException);
        }
        catch (SAXException sAXException) {
            throw new GateException(sAXException);
        }
    }

    @Override
    public void registerBuiltins() throws GateException {
        try {
            URL uRL = Gate.getBuiltinCreoleDir();
            URL uRL2 = new URL(uRL, "creole.xml");
            this.parseDirectory(uRL2.openStream(), uRL, uRL2);
        }
        catch (IOException iOException) {
            throw new GateException(iOException);
        }
    }

    @Override
    public File createCreoleDirectoryFile(File file, Set set) {
        throw new LazyProgrammerException();
    }

    @Override
    public ResourceData put(String string, ResourceData resourceData) {
        Class<? extends Resource> clazz = null;
        try {
            clazz = resourceData.getResourceClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GateRuntimeException("Couldn't get resource class from the resource data:" + classNotFoundException);
        }
        if (LanguageResource.class.isAssignableFrom(clazz)) {
            if (this.lrTypes == null) {
                this.lrTypes = new HashSet<String>();
            }
            this.lrTypes.add(resourceData.getClassName());
        } else if (ProcessingResource.class.isAssignableFrom(clazz)) {
            if (this.prTypes == null) {
                this.prTypes = new HashSet<String>();
            }
            this.prTypes.add(resourceData.getClassName());
        } else if (VisualResource.class.isAssignableFrom(clazz)) {
            if (this.vrTypes == null) {
                this.vrTypes = new LinkedList<String>();
            }
            if (!this.vrTypes.contains(resourceData.getClassName())) {
                this.vrTypes.add(resourceData.getClassName());
            }
        } else if (Controller.class.isAssignableFrom(clazz)) {
            if (this.controllerTypes == null) {
                this.controllerTypes = new HashSet<String>();
            }
            this.controllerTypes.add(resourceData.getClassName());
        }
        if (resourceData.isTool()) {
            if (this.toolTypes == null) {
                this.toolTypes = new HashSet<String>();
            }
            this.toolTypes.add(resourceData.getClassName());
        }
        return super.put(string, resourceData);
    }

    @Override
    public void removeDirectory(URL uRL) {
        if (this.directories.remove(uRL)) {
            Gate.DirectoryInfo directoryInfo = Gate.getDirectoryInfo(uRL);
            if (directoryInfo != null) {
                for (Gate.ResourceInfo resourceInfo : directoryInfo.getResourceInfoList()) {
                    this.remove(resourceInfo.getResourceClassName());
                }
            }
            System.out.println("CREOLE plugin unloaded: " + uRL);
        }
    }

    @Override
    public ResourceData remove(Object object) {
        ResourceData resourceData = (ResourceData)this.get(object);
        if (resourceData == null) {
            return null;
        }
        try {
            if (LanguageResource.class.isAssignableFrom(resourceData.getResourceClass())) {
                this.lrTypes.remove(resourceData.getClassName());
            } else if (ProcessingResource.class.isAssignableFrom(resourceData.getResourceClass())) {
                this.prTypes.remove(resourceData.getClassName());
            } else if (VisualResource.class.isAssignableFrom(resourceData.getResourceClass())) {
                this.vrTypes.remove(resourceData.getClassName());
            } else if (Controller.class.isAssignableFrom(resourceData.getResourceClass())) {
                this.controllerTypes.remove(resourceData.getClassName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GateRuntimeException("Could not load class specified in CREOLE data.", classNotFoundException);
        }
        if (resourceData.isTool()) {
            this.toolTypes.remove(resourceData.getClassName());
        }
        return (ResourceData)super.remove(object);
    }

    @Override
    public void clear() {
        this.lrTypes.clear();
        this.prTypes.clear();
        this.vrTypes.clear();
        this.toolTypes.clear();
        this.directories.clear();
        super.clear();
    }

    @Override
    public Set<String> getLrTypes() {
        return Collections.unmodifiableSet(this.lrTypes);
    }

    @Override
    public Set<String> getPrTypes() {
        return Collections.unmodifiableSet(this.prTypes);
    }

    @Override
    public Set<String> getVrTypes() {
        return Collections.unmodifiableSet(new HashSet<String>(this.vrTypes));
    }

    @Override
    public Set<String> getControllerTypes() {
        return Collections.unmodifiableSet(this.controllerTypes);
    }

    public Set<String> getToolTypes() {
        return Collections.unmodifiableSet(this.toolTypes);
    }

    @Override
    public List<LanguageResource> getLrInstances() {
        Set<String> set = this.getLrTypes();
        ArrayList<LanguageResource> arrayList = new ArrayList<LanguageResource>();
        for (String string : set) {
            arrayList.addAll(this.getLrInstances(string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<ProcessingResource> getPrInstances() {
        Set<String> set = this.getPrTypes();
        ArrayList<ProcessingResource> arrayList = new ArrayList<ProcessingResource>();
        for (String string : set) {
            arrayList.addAll(this.getPrInstances(string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<VisualResource> getVrInstances() {
        Set<String> set = this.getVrTypes();
        ArrayList<VisualResource> arrayList = new ArrayList<VisualResource>();
        for (String string : set) {
            arrayList.addAll(this.getVrInstances(string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<LanguageResource> getLrInstances(String string) {
        ResourceData resourceData = (ResourceData)this.get(string);
        if (resourceData == null) {
            return Collections.emptyList();
        }
        return new TypedResourceList<LanguageResource>(resourceData.getInstantiations(), LanguageResource.class);
    }

    @Override
    public List<ProcessingResource> getPrInstances(String string) {
        ResourceData resourceData = (ResourceData)this.get(string);
        if (resourceData == null) {
            return Collections.emptyList();
        }
        return new TypedResourceList<ProcessingResource>(resourceData.getInstantiations(), ProcessingResource.class);
    }

    @Override
    public List<VisualResource> getVrInstances(String string) {
        ResourceData resourceData = (ResourceData)this.get(string);
        if (resourceData == null) {
            return Collections.emptyList();
        }
        return new TypedResourceList<VisualResource>(resourceData.getInstantiations(), VisualResource.class);
    }

    @Override
    public List<LanguageResource> getPublicLrInstances() {
        return Collections.unmodifiableList(this.getPublics(this.getLrInstances()));
    }

    @Override
    public List<ProcessingResource> getPublicPrInstances() {
        return Collections.unmodifiableList(this.getPublics(this.getPrInstances()));
    }

    @Override
    public List<VisualResource> getPublicVrInstances() {
        return Collections.unmodifiableList(this.getPublics(this.getVrInstances()));
    }

    @Override
    public List<String> getPublicLrTypes() {
        return Collections.unmodifiableList(this.getPublicTypes(this.getLrTypes()));
    }

    @Override
    public List<String> getPublicPrTypes() {
        return Collections.unmodifiableList(this.getPublicTypes(this.getPrTypes()));
    }

    @Override
    public List<String> getPublicVrTypes() {
        return Collections.unmodifiableList(this.getPublicTypes(this.getVrTypes()));
    }

    @Override
    public List<String> getPublicControllerTypes() {
        return Collections.unmodifiableList(this.getPublicTypes(this.getControllerTypes()));
    }

    @Override
    public List<Resource> getAllInstances(String string) throws GateException {
        Class<Resource> clazz;
        Iterator iterator = this.keySet().iterator();
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        try {
            clazz = Gate.getClassLoader().loadClass(string).asSubclass(Resource.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GateException("Invalid type " + string);
        }
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            try {
                Class<?> clazz2 = Gate.getClassLoader().loadClass(string2);
                if (!clazz.isAssignableFrom(clazz2)) continue;
                for (Resource resource : ((ResourceData)this.get(string2)).getInstantiations()) {
                    if (Gate.getHiddenAttribute(resource.getFeatures())) continue;
                    arrayList.add(resource);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new LuckyException("A type registered in the creole register does not exist in the VM!");
            }
        }
        return arrayList;
    }

    @Override
    public List<String> getLargeVRsForResource(String string) {
        return this.getVRsForResource(string, 1);
    }

    @Override
    public List<String> getSmallVRsForResource(String string) {
        return this.getVRsForResource(string, 2);
    }

    private List<String> getVRsForResource(String string, int n) {
        if (string == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        Class<?> clazz = null;
        GateClassLoader gateClassLoader = Gate.getClassLoader();
        try {
            clazz = gateClassLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GateRuntimeException("Couldn't get resource class from the resource name:" + classNotFoundException);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = null;
        for (String string3 : this.vrTypes) {
            String string4;
            ResourceData resourceData = (ResourceData)this.get(string3);
            if (resourceData == null) {
                throw new GateRuntimeException("Couldn't get resource data for VR called " + string3);
            }
            if (resourceData.getGuiType() != n || (string4 = resourceData.getResourceDisplayed()) == null) continue;
            Class<?> clazz2 = null;
            try {
                clazz2 = gateClassLoader.loadClass(string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new GateRuntimeException("Couldn't get resource class from the resource name :" + string4 + " " + classNotFoundException);
            }
            if (!clazz2.isAssignableFrom(clazz)) continue;
            linkedList.add(string3);
            if (!resourceData.isMainView()) continue;
            string2 = string3;
        }
        if (string2 != null) {
            linkedList.remove(string2);
            linkedList.addFirst(string2);
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public List<String> getAnnotationVRs() {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = null;
        for (String string2 : this.vrTypes) {
            ResourceData resourceData = (ResourceData)this.get(string2);
            if (resourceData == null) {
                throw new GateRuntimeException("Couldn't get resource data for VR called " + string2);
            }
            Class<? extends Resource> clazz = null;
            try {
                clazz = resourceData.getResourceClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new GateRuntimeException("Couldn't create a class object for VR called " + string2);
            }
            if (resourceData.getGuiType() != 0 || resourceData.getAnnotationTypeDisplayed() != null || resourceData.getResourceDisplayed() != null || !AnnotationVisualResource.class.isAssignableFrom(clazz)) continue;
            linkedList.add(string2);
            if (!resourceData.isMainView()) continue;
            string = string2;
        }
        if (string != null) {
            linkedList.remove(string);
            linkedList.addFirst(string);
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public List<String> getAnnotationVRs(String string) {
        if (string == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = null;
        for (String string3 : this.vrTypes) {
            String string4;
            ResourceData resourceData = (ResourceData)this.get(string3);
            if (resourceData == null) {
                throw new GateRuntimeException("Couldn't get resource data for VR called " + string3);
            }
            Class<? extends Resource> clazz = null;
            try {
                clazz = resourceData.getResourceClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new GateRuntimeException("Couldn't create a class object for VR called " + string3);
            }
            if (resourceData.getGuiType() != 0 || resourceData.getAnnotationTypeDisplayed() == null || !AnnotationVisualResource.class.isAssignableFrom(clazz) || !(string4 = resourceData.getAnnotationTypeDisplayed()).equals(string)) continue;
            linkedList.add(string3);
            if (!resourceData.isMainView()) continue;
            string2 = string3;
        }
        if (string2 != null) {
            linkedList.remove(string2);
            linkedList.addFirst(string2);
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public void setResourceName(Resource resource, String string) {
        String string2 = resource.getName();
        resource.setName(string);
        this.fireResourceRenamed(resource, string2, string);
    }

    @Override
    public List<String> getVREnabledAnnotationTypes() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this.vrTypes) {
            ResourceData resourceData = (ResourceData)this.get(string);
            if (resourceData == null) {
                throw new GateRuntimeException("Couldn't get resource data for VR called " + string);
            }
            if (resourceData.getGuiType() != 0 || resourceData.getAnnotationTypeDisplayed() == null) continue;
            String string2 = resourceData.getAnnotationTypeDisplayed();
            linkedList.add(string2);
        }
        return Collections.unmodifiableList(linkedList);
    }

    protected <T> List<T> getPublics(List<T> list) {
        Iterator<T> iterator = list.iterator();
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            T t = iterator.next();
            ResourceData resourceData = (ResourceData)this.get(t.getClass().getName());
            if (resourceData.isPrivate()) continue;
            arrayList.add(t);
        }
        return Collections.unmodifiableList(arrayList);
    }

    protected List<String> getPublicTypes(Collection<String> collection) {
        Iterator<String> iterator = collection.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            ResourceData resourceData = (ResourceData)this.get(string);
            if (resourceData == null || resourceData.isPrivate()) continue;
            arrayList.add(string);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public synchronized void removeCreoleListener(CreoleListener creoleListener) {
        if (this.creoleListeners != null && this.creoleListeners.contains(creoleListener)) {
            Vector vector = (Vector)this.creoleListeners.clone();
            vector.removeElement(creoleListener);
            this.creoleListeners = vector;
        }
    }

    @Override
    public synchronized void addCreoleListener(CreoleListener creoleListener) {
        Vector vector;
        Vector vector2 = vector = this.creoleListeners == null ? new Vector(2) : (Vector)this.creoleListeners.clone();
        if (!vector.contains(creoleListener)) {
            vector.addElement(creoleListener);
            this.creoleListeners = vector;
        }
    }

    protected void fireResourceLoaded(CreoleEvent creoleEvent) {
        if (this.creoleListeners != null) {
            Vector vector = this.creoleListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CreoleListener)vector.elementAt(i)).resourceLoaded(creoleEvent);
            }
        }
    }

    protected void fireResourceUnloaded(CreoleEvent creoleEvent) {
        if (this.creoleListeners != null) {
            Vector vector = this.creoleListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CreoleListener)vector.elementAt(i)).resourceUnloaded(creoleEvent);
            }
        }
    }

    protected void fireResourceRenamed(Resource resource, String string, String string2) {
        if (this.creoleListeners != null) {
            Vector vector = this.creoleListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CreoleListener)vector.elementAt(i)).resourceRenamed(resource, string, string2);
            }
        }
    }

    protected void fireDatastoreOpened(CreoleEvent creoleEvent) {
        if (this.creoleListeners != null) {
            Vector vector = this.creoleListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CreoleListener)vector.elementAt(i)).datastoreOpened(creoleEvent);
            }
        }
    }

    protected void fireDatastoreCreated(CreoleEvent creoleEvent) {
        if (this.creoleListeners != null) {
            Vector vector = this.creoleListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CreoleListener)vector.elementAt(i)).datastoreCreated(creoleEvent);
            }
        }
    }

    protected void fireDatastoreClosed(CreoleEvent creoleEvent) {
        if (this.creoleListeners != null) {
            Vector vector = this.creoleListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CreoleListener)vector.elementAt(i)).datastoreClosed(creoleEvent);
            }
        }
    }

    @Override
    public void resourceLoaded(CreoleEvent creoleEvent) {
        this.fireResourceLoaded(creoleEvent);
    }

    @Override
    public void resourceUnloaded(CreoleEvent creoleEvent) {
        this.fireResourceUnloaded(creoleEvent);
    }

    @Override
    public void resourceRenamed(Resource resource, String string, String string2) {
        this.fireResourceRenamed(resource, string, string2);
    }

    @Override
    public void datastoreOpened(CreoleEvent creoleEvent) {
        this.fireDatastoreOpened(creoleEvent);
    }

    @Override
    public void datastoreCreated(CreoleEvent creoleEvent) {
        this.fireDatastoreCreated(creoleEvent);
    }

    @Override
    public void datastoreClosed(CreoleEvent creoleEvent) {
        this.fireDatastoreClosed(creoleEvent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypedResourceList<T extends Resource>
    extends AbstractList<T> {
        private List<Resource> backingList;
        private Class<T> realType;

        TypedResourceList(List<Resource> list, Class<T> clazz) {
            this.backingList = list;
            this.realType = clazz;
        }

        @Override
        public T get(int n) {
            return (T)((Resource)this.realType.cast(this.backingList.get(n)));
        }

        @Override
        public int size() {
            return this.backingList.size();
        }
    }
}

