/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.FeatureMap;
import gate.LanguageAnalyser;
import gate.ProcessingResource;
import gate.creole.AbstractController;
import gate.creole.AbstractResource;
import gate.creole.AnalyserRunningStrategy;
import gate.creole.ConditionalController;
import gate.creole.ExecutionException;
import gate.creole.RunningStrategy;
import gate.creole.SerialController;
import gate.event.ControllerEvent;
import gate.util.Err;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ConditionalSerialController
extends SerialController
implements ConditionalController {
    protected List strategiesList = new ArrayList();

    public Collection getRunningStrategies() {
        return Collections.unmodifiableList(this.strategiesList);
    }

    public void add(int n, ProcessingResource processingResource) {
        if (processingResource instanceof LanguageAnalyser) {
            this.strategiesList.add(n, new AnalyserRunningStrategy((LanguageAnalyser)processingResource, 1, null, null));
        } else {
            this.strategiesList.add(n, new RunningStrategy.RunAlwaysStrategy(processingResource));
        }
        super.add(n, processingResource);
    }

    public void add(ProcessingResource processingResource) {
        if (processingResource instanceof LanguageAnalyser) {
            this.strategiesList.add(new AnalyserRunningStrategy((LanguageAnalyser)processingResource, 1, null, null));
        } else {
            this.strategiesList.add(new RunningStrategy.RunAlwaysStrategy(processingResource));
        }
        super.add(processingResource);
    }

    public ProcessingResource remove(int n) {
        ProcessingResource processingResource = super.remove(n);
        this.strategiesList.remove(n);
        this.fireResourceRemoved(new ControllerEvent(this, 1, processingResource));
        return processingResource;
    }

    public boolean remove(ProcessingResource processingResource) {
        int n = this.prList.indexOf(processingResource);
        if (n != -1) {
            this.prList.remove(n);
            this.strategiesList.remove(n);
            this.fireResourceRemoved(new ControllerEvent(this, 1, processingResource));
            return true;
        }
        return false;
    }

    public void setRunningStrategy(int n, AnalyserRunningStrategy analyserRunningStrategy) {
        this.strategiesList.set(n, analyserRunningStrategy);
    }

    public void setRunningStrategies(Collection collection) {
        this.strategiesList.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.strategiesList.add(iterator.next());
        }
    }

    protected void runComponent(int n) throws ExecutionException {
        ProcessingResource processingResource = (ProcessingResource)this.prList.get(n);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("gate.event.StatusListener", this.sListener);
        int n2 = 100 / this.prList.size();
        featureMap.put("gate.event.ProgressListener", new AbstractController.IntervalProgressListener(n * n2, (n + 1) * n2));
        try {
            AbstractResource.setResourceListeners(processingResource, featureMap);
        }
        catch (Exception exception) {
            Err.prln("Could not set listeners for " + processingResource.getClass().getName() + "\n" + exception.toString() + "\n...nothing to lose any sleep over.");
        }
        if (((RunningStrategy)this.strategiesList.get(n)).shouldRun()) {
            processingResource.execute();
        }
        try {
            AbstractResource.removeResourceListeners(processingResource, featureMap);
        }
        catch (Exception exception) {
            Err.prln("Could not clear listeners for " + processingResource.getClass().getName() + "\n" + exception.toString() + "\n...nothing to lose any sleep over.");
        }
    }

    public void cleanup() {
        super.cleanup();
        this.strategiesList.clear();
    }
}

