/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Resource;
import gate.creole.AbstractLanguageResource;
import gate.creole.FeatureSchema;
import gate.creole.ResourceInstantiationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class AnnotationSchema
extends AbstractLanguageResource {
    public static final String FILE_URL_PARAM_NAME = "xmlFileUrl";
    private static final boolean DEBUG = false;
    private static Map xSchema2JavaMap;
    private static Map java2xSchemaMap;
    protected String annotationName = null;
    protected Set featureSchemaSet = null;
    protected URL xmlFileUrl;
    protected Namespace namespace;

    private static void setUpStaticData() throws ResourceInstantiationException {
        xSchema2JavaMap = new HashMap();
        java2xSchemaMap = new HashMap();
        xSchema2JavaMap.put("string", String.class.getName());
        xSchema2JavaMap.put("integer", Integer.class.getName());
        xSchema2JavaMap.put("int", Integer.class.getName());
        xSchema2JavaMap.put("boolean", Boolean.class.getName());
        xSchema2JavaMap.put("float", Float.class.getName());
        xSchema2JavaMap.put("double", Double.class.getName());
        xSchema2JavaMap.put("short", Short.class.getName());
        xSchema2JavaMap.put("byte", Byte.class.getName());
        java2xSchemaMap.put(String.class.getName(), "string");
        java2xSchemaMap.put(Integer.class.getName(), "integer");
        java2xSchemaMap.put(Boolean.class.getName(), "boolean");
        java2xSchemaMap.put(Float.class.getName(), "float");
        java2xSchemaMap.put(Double.class.getName(), "double");
        java2xSchemaMap.put(Short.class.getName(), "short");
        java2xSchemaMap.put(Byte.class.getName(), "byte");
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public void setAnnotationName(String string) {
        this.annotationName = string;
    }

    public Set getFeatureSchemaSet() {
        return this.featureSchemaSet;
    }

    public void setFeatureSchemaSet(Set set) {
        this.featureSchemaSet = set;
    }

    public FeatureSchema getFeatureSchema(String string) {
        if (this.featureSchemaSet == null) {
            return null;
        }
        for (FeatureSchema featureSchema : this.featureSchemaSet) {
            if (!featureSchema.getFeatureName().equals(string)) continue;
            return featureSchema;
        }
        return null;
    }

    public Resource init() throws ResourceInstantiationException {
        if (xSchema2JavaMap == null || java2xSchemaMap == null) {
            AnnotationSchema.setUpStaticData();
        }
        if (this.xmlFileUrl != null) {
            this.fromXSchema(this.xmlFileUrl);
        }
        return this;
    }

    public void setXmlFileUrl(URL uRL) {
        this.xmlFileUrl = uRL;
    }

    public URL getXmlFileUrl() {
        return this.xmlFileUrl;
    }

    public void fromXSchema(URL uRL) throws ResourceInstantiationException {
        Document document = null;
        SAXBuilder sAXBuilder = new SAXBuilder(false);
        try {
            try {
                document = sAXBuilder.build(uRL);
            }
            catch (JDOMException jDOMException) {
                throw new ResourceInstantiationException((Exception)((Object)jDOMException));
            }
        }
        catch (IOException iOException) {
            throw new ResourceInstantiationException(iOException);
        }
        this.workWithJDom(document);
    }

    public void fromXSchema(InputStream inputStream) throws ResourceInstantiationException {
        Document document = null;
        SAXBuilder sAXBuilder = new SAXBuilder(false);
        try {
            try {
                document = sAXBuilder.build(inputStream);
            }
            catch (JDOMException jDOMException) {
                throw new ResourceInstantiationException((Exception)((Object)jDOMException));
            }
        }
        catch (IOException iOException) {
            throw new ResourceInstantiationException(iOException);
        }
        this.workWithJDom(document);
    }

    private void workWithJDom(Document document) {
        Element element = document.getRootElement();
        this.namespace = element.getNamespace();
        List list = element.getChildren("element", this.namespace);
        for (Element element2 : list) {
            this.createAnnotationSchemaObject(element2);
        }
    }

    private void createAnnotationSchemaObject(Element element) {
        Element element2;
        this.annotationName = element.getAttributeValue("name");
        if (this.annotationName == null) {
            this.annotationName = "UnknownElement";
        }
        if ((element2 = element.getChild("complexType", this.namespace)) != null) {
            List list = element2.getChildren("attribute", this.namespace);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                this.featureSchemaSet = new HashSet();
            }
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                this.createAndAddFeatureSchemaObject(element3);
            }
        }
    }

    public void createAndAddFeatureSchemaObject(Element element) {
        Object object;
        Element element2;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        HashSet<String> hashSet = null;
        string = element.getAttributeValue("name");
        if (string == null) {
            string = "UnknownFeature";
        }
        if ((string2 = element.getAttributeValue("type")) != null) {
            string2 = (String)xSchema2JavaMap.get(string2);
        }
        if ((string3 = element.getAttributeValue("use")) == null) {
            string3 = "optional";
        }
        if ((string4 = element.getAttributeValue("value")) == null) {
            string4 = "";
        }
        if ((element2 = element.getChild("simpleType", this.namespace)) != null && (object = element2.getChild("restriction", this.namespace)) != null) {
            string2 = object.getAttributeValue("base");
            string2 = string2 == null ? (String)xSchema2JavaMap.get("string") : (String)xSchema2JavaMap.get(string2);
            List list = object.getChildren("enumeration", this.namespace);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                hashSet = new HashSet<String>();
            }
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                String string5 = element3.getAttributeValue("value");
                hashSet.add(string5);
            }
        }
        if (element2 == null && string2 == null) {
            string2 = (String)xSchema2JavaMap.get("string");
        }
        object = new FeatureSchema(string, string2, string4, string3, hashSet);
        this.featureSchemaSet.add(object);
    }

    public String toXSchema() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>\n<schema xmlns=\"http://www.w3.org/2000/10/XMLSchema\">\n <element name=\"" + this.annotationName + "\"");
        if (this.featureSchemaSet == null) {
            stringBuffer.append("/>\n");
        } else {
            stringBuffer.append(">\n  <complexType>\n");
            for (FeatureSchema featureSchema : this.featureSchemaSet) {
                stringBuffer.append("   " + featureSchema.toXSchema(java2xSchemaMap));
            }
            stringBuffer.append("  </complexType>\n");
            stringBuffer.append(" </element>\n");
        }
        stringBuffer.append("</schema>\n");
        return stringBuffer.toString();
    }
}

