/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ANNIEConstants;
import gate.creole.AbstractResource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import java.util.Vector;

public abstract class AbstractProcessingResource
extends AbstractResource
implements ProcessingResource,
ANNIEConstants {
    private transient Vector statusListeners;
    private transient Vector progressListeners;
    protected boolean interrupted = false;

    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    public void execute() throws ExecutionException {
        throw new ExecutionException("Resource " + this.getClass() + " hasn't overriden the execute() method");
    }

    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    public void cleanup() {
    }

    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    public synchronized void interrupt() {
        this.interrupted = true;
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(statusListener)) {
            Vector vector = (Vector)this.statusListeners.clone();
            vector.removeElement(statusListener);
            this.statusListeners = vector;
        }
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector;
        Vector vector2 = vector = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!vector.contains(statusListener)) {
            vector.addElement(statusListener);
            this.statusListeners = vector;
        }
    }

    protected void fireStatusChanged(String string) {
        if (this.statusListeners != null) {
            Vector vector = this.statusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((StatusListener)vector.elementAt(i)).statusChanged(string);
            }
        }
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        Vector vector;
        Vector vector2 = vector = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!vector.contains(progressListener)) {
            vector.addElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners != null && this.progressListeners.contains(progressListener)) {
            Vector vector = (Vector)this.progressListeners.clone();
            vector.removeElement(progressListener);
            this.progressListeners = vector;
        }
    }

    protected void fireProgressChanged(int n) {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((ProgressListener)vector.elementAt(i)).progressChanged(n);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ProgressListener)vector.elementAt(i)).processFinished();
            }
        }
    }

    protected class InternalStatusListener
    implements StatusListener {
        protected InternalStatusListener() {
        }

        public void statusChanged(String string) {
            AbstractProcessingResource.this.fireStatusChanged(string);
        }
    }

    protected class IntervalProgressListener
    implements ProgressListener {
        int start;
        int end;

        public IntervalProgressListener(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public void progressChanged(int n) {
            AbstractProcessingResource.this.fireProgressChanged(this.start + (this.end - this.start) * n / 100);
        }

        public void processFinished() {
            AbstractProcessingResource.this.fireProgressChanged(this.end);
        }
    }
}

