/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Annotation;
import gate.AnnotationSet;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.ANNIEConstants;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.util.Err;
import gate.util.Files;
import gate.util.InvalidOffsetException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class APFormatExporter
extends AbstractLanguageAnalyser
implements ANNIEConstants {
    public static final String APF_EXP_DOCUMENT_PARAMETER_NAME = "document";
    public static final String APF_EXP_SOURCE_PARAMETER_NAME = "source";
    public static final String APF_EXP_DTD_PARAMETER_NAME = "dtdFileName";
    public static final String APF_EXP_PATH_PARAMETER_NAME = "exportFilePath";
    public static final String APF_EXP_TYPES_PARAMETER_NAME = "exportedTypes";
    public static final String APF_EXP_WRITE_SOURCE_PARAMETER_NAME = "isSourceWritten";
    private static final boolean DEBUG = false;
    private List exportedTypes = null;
    private String dtdFileName = null;
    private String docId = null;
    private int entityId = 1;
    private int mentionId = 1;
    private StringBuffer xmlDoc = null;
    private URL exportFilePath = null;
    private String source = null;
    private boolean isSourceWritten = true;

    public void execute() throws ExecutionException {
        if (this.document == null) {
            throw new ExecutionException("No document found to export in APF format!");
        }
        if (this.exportedTypes == null) {
            throw new ExecutionException("No export types found.");
        }
        this.xmlDoc = new StringBuffer(10 * this.document.getContent().size().intValue());
        this.initDocId();
        if (this.docId == null) {
            throw new ExecutionException("Couldn't detect the document's ID");
        }
        String string = null;
        string = this.exportFilePath == null ? new String(this.document.getSourceUrl().getFile() + ".apf.xml") : this.exportFilePath.getPath() + "/" + Files.getLastPathComponent(this.document.getSourceUrl().getFile()) + ".apf.xml";
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(new FileOutputStream(new File(string)));
            this.serializeDocumentToAPF();
            outputStreamWriter.write(this.xmlDoc.toString());
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            throw new ExecutionException(exception);
        }
    }

    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    public void setExportedTypes(List list) {
        this.exportedTypes = list;
    }

    public List getExportedTypes() {
        return this.exportedTypes;
    }

    public void setDtdFileName(String string) {
        this.dtdFileName = string;
    }

    public String getDtdFileName() {
        return this.dtdFileName;
    }

    public void setExportFilePath(URL uRL) {
        this.exportFilePath = uRL;
    }

    public URL getExportFilePath() {
        return this.exportFilePath;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getSource() {
        return this.source;
    }

    public Boolean getIsSourceWritten() {
        return new Boolean(this.isSourceWritten);
    }

    public void setIsSourceWritten(Boolean bl) {
        this.isSourceWritten = bl;
    }

    private void initDocId() {
        String string = "";
        string = Files.getLastPathComponent(this.document.getSourceUrl().getFile());
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringBuffer stringBuffer = new StringBuffer("");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(string2 + ".");
        }
        if (!"".equals(stringBuffer)) {
            stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "");
            this.docId = stringBuffer.toString();
        }
    }

    protected void serializeDocumentToAPF() {
        this.xmlDoc.append("<?xml version=\"1.0\" ?>\n");
        this.xmlDoc.append("<!DOCTYPE source_file SYSTEM ");
        if (this.dtdFileName == null) {
            this.xmlDoc.append("\"ace-rdc.v2.0.1.dtd\"");
        } else {
            this.xmlDoc.append("\"" + this.dtdFileName + "\"");
        }
        this.xmlDoc.append(">\n");
        this.xmlDoc.append("<source_file TYPE=\"text\"");
        if (this.isSourceWritten) {
            AnnotationSet annotationSet = this.document.getAnnotations("Original markups").get("DOCTYPE");
            if (annotationSet == null || annotationSet.isEmpty()) {
                this.xmlDoc.append(" SOURCE=\"" + this.source + "\" ");
            } else {
                Annotation annotation = annotationSet.iterator().next();
                if (annotation.getFeatures().get("SOURCE") == null) {
                    this.xmlDoc.append(" SOURCE=\"" + this.source + "\" ");
                } else {
                    this.xmlDoc.append(" SOURCE=\"" + annotation.getFeatures().get("SOURCE") + "\" ");
                }
            }
        }
        this.xmlDoc.append("VERSION=\"2.0\" URI=\"");
        this.xmlDoc.append(this.docId);
        this.xmlDoc.append("-lf\">\n");
        this.xmlDoc.append("  <document DOCID=\"");
        this.xmlDoc.append(this.docId + "\">\n");
        this.serializeEntities();
        this.xmlDoc.append("  </document>\n");
        this.xmlDoc.append("</source_file>");
    }

    protected void serializeEntities() {
        if (this.exportedTypes == null || this.exportedTypes.isEmpty()) {
            return;
        }
        Map map = null;
        map = this.document.getFeatures() == null || this.document.getFeatures().get("MatchesAnnots") == null ? new HashMap() : (Map)this.document.getFeatures().get("MatchesAnnots");
        HashMap hashMap = null;
        hashMap = this.document.getNamedAnnotationSets() == null ? new HashMap() : new HashMap(this.document.getNamedAnnotationSets());
        hashMap.put(null, this.document.getAnnotations());
        for (String string : this.exportedTypes) {
            Set set = hashMap.keySet();
            for (Object k : set) {
                Serializable serializable;
                Object object;
                Object object22;
                ArrayList arrayList = (ArrayList)map.get(k);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                AnnotationSet annotationSet = null;
                HashSet<Annotation> hashSet = null;
                annotationSet = (AnnotationSet)hashMap.get(k);
                if (annotationSet == null || annotationSet.get(string) == null) continue;
                hashSet = new HashSet<Annotation>(annotationSet.get(string));
                for (Object object22 : arrayList) {
                    Object object3;
                    object = new String("");
                    if (object22 != null && !object22.isEmpty() && (object3 = annotationSet.get((Integer)(serializable = (Integer)object22.get(0)))) != null) {
                        object = object3.getType();
                    }
                    if (!((String)object).equals(string)) continue;
                    serializable = new ArrayList();
                    object3 = object22.iterator();
                    while (object3.hasNext()) {
                        Integer n = (Integer)object3.next();
                        serializable.add(annotationSet.get(n));
                    }
                    this.serializeAnEntity((List)((Object)serializable));
                    hashSet.removeAll((Collection<?>)((Object)serializable));
                }
                object22 = hashSet.iterator();
                while (object22.hasNext()) {
                    object = (Annotation)object22.next();
                    serializable = new ArrayList<Object>();
                    serializable.add(object);
                    this.serializeAnEntity((List)((Object)serializable));
                }
            }
        }
    }

    private void serializeAnEntity(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.xmlDoc.append("  <entity ID=\"" + this.docId + "-" + this.getNextEntityId() + "\">\n");
        Annotation annotation = (Annotation)list.get(0);
        this.xmlDoc.append("    <entity_type GENERIC=\"FALSE\">" + annotation.getType().toUpperCase() + "</entity_type>\n");
        for (Annotation annotation2 : list) {
            this.serializeAnEntityMention(annotation2);
        }
        this.xmlDoc.append("      <entity_attributes>\n");
        for (Annotation annotation2 : list) {
            this.serializeAnEntityAttributes(annotation2);
        }
        this.xmlDoc.append("      </entity_attributes>\n");
        this.xmlDoc.append("  </entity>\n");
    }

    private void serializeAnEntityMention(Annotation annotation) {
        if (annotation == null) {
            return;
        }
        String string = "NAME";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        FeatureMap featureMap = annotation.getFeatures();
        if (featureMap != null) {
            if (null != featureMap.get("ENTITY_MENTION_TYPE")) {
                string = (String)featureMap.get("ENTITY_MENTION_TYPE");
            }
            string2 = (String)featureMap.get("ROLE");
            string3 = (String)featureMap.get("REFERENCE");
            string4 = (String)featureMap.get("GENERIC");
        }
        String string5 = string2 == null ? "" : "ROLE=\"" + string2 + "\"";
        String string6 = string3 == null ? "" : "REFERENCE=\"" + string3 + "\"";
        String string7 = string4 == null ? "" : "GENERIC=\"" + string4 + "\"";
        this.xmlDoc.append("      <entity_mention TYPE=\"" + string + "\"" + string5 + " " + string6 + " " + string7 + "ID=\"" + "M" + this.getNextMentionId() + "\">\n");
        this.xmlDoc.append("        <extent>\n");
        this.xmlDoc.append("          <charseq>\n");
        try {
            this.xmlDoc.append("          <!-- string = \"" + this.document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()) + "\" -->\n");
        }
        catch (InvalidOffsetException invalidOffsetException) {
            Err.prln("APFormatExporter:Warning: Couldn't access text between offsets:" + annotation.getStartNode().getOffset() + " and " + annotation.getEndNode().getOffset());
        }
        this.xmlDoc.append("          <start>" + annotation.getStartNode().getOffset() + "</start><end>" + (annotation.getEndNode().getOffset() - 1L) + "</end>\n");
        this.xmlDoc.append("          </charseq>\n");
        this.xmlDoc.append("        </extent>\n");
        this.xmlDoc.append("        <head>\n");
        this.xmlDoc.append("          <charseq>\n");
        try {
            this.xmlDoc.append("          <!-- string = \"" + this.document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()) + "\" -->\n");
        }
        catch (InvalidOffsetException invalidOffsetException) {
            Err.prln("APFormatExporter:Warning: Couldn't access text between offsets:" + annotation.getStartNode().getOffset() + " and " + annotation.getEndNode().getOffset());
        }
        this.xmlDoc.append("          <start>" + annotation.getStartNode().getOffset() + "</start><end>" + (annotation.getEndNode().getOffset() - 1L) + "</end>\n");
        this.xmlDoc.append("          </charseq>\n");
        this.xmlDoc.append("        </head>\n");
        this.xmlDoc.append("      </entity_mention>\n");
    }

    private void serializeAnEntityAttributes(Annotation annotation) {
        if (annotation == null) {
            return;
        }
        boolean bl = false;
        if ("NAME".equals(annotation.getFeatures().get("ENTITY_MENTION_TYPE")) || null == annotation.getFeatures().get("ENTITY_MENTION_TYPE")) {
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.xmlDoc.append("        <name>\n");
        this.xmlDoc.append("          <charseq>\n");
        try {
            this.xmlDoc.append("          <!-- string = \"" + this.document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()) + "\" -->\n");
        }
        catch (InvalidOffsetException invalidOffsetException) {
            Err.prln("APFormatExporter:Warning: Couldn't access text between offsets:" + annotation.getStartNode().getOffset() + " and " + annotation.getEndNode().getOffset());
        }
        this.xmlDoc.append("          <start>" + annotation.getStartNode().getOffset() + "</start><end>" + (annotation.getEndNode().getOffset() - 1L) + "</end>\n");
        this.xmlDoc.append("          </charseq>\n");
        this.xmlDoc.append("        </name>\n");
    }

    private int getNextEntityId() {
        return this.entityId++;
    }

    private int getNextMentionId() {
        return this.mentionId++;
    }
}

