/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.AnnotationSet;
import gate.DataStore;
import gate.Document;
import gate.DocumentFormat;
import gate.Factory;
import gate.Resource;
import gate.corpora.DocumentContentImpl;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.creole.ResourceInstantiationException;
import gate.util.DocumentFormatException;
import gate.util.InvalidOffsetException;
import java.io.IOException;

public class TextualDocumentFormat
extends DocumentFormat {
    private static final boolean DEBUG = false;

    public Resource init() throws ResourceInstantiationException {
        MimeType mimeType = new MimeType("text", "plain");
        mimeString2ClassHandlerMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), this);
        mimeString2mimeTypeMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), mimeType);
        suffixes2mimeTypeMap.put("txt", mimeType);
        suffixes2mimeTypeMap.put("text", mimeType);
        this.setMimeType(mimeType);
        return this;
    }

    public void unpackMarkup(Document document) throws DocumentFormatException {
        if (document == null || document.getContent() == null) {
            return;
        }
        this.setNewLineProperty(document);
        int n = document.getContent().toString().length();
        int n2 = 0;
        this.annotateParagraphs(document, n2, n, "Original markups");
    }

    public void unpackMarkup(Document document, RepositioningInfo repositioningInfo, RepositioningInfo repositioningInfo2) throws DocumentFormatException {
        this.unpackMarkup(document);
    }

    protected static boolean hasContentButNoValidUrl(Document document) throws DocumentFormatException {
        try {
            if (document.getSourceUrl() == null && document.getContent() != null) {
                return true;
            }
            document.getSourceUrl().openConnection();
        }
        catch (IOException iOException) {
            if (document.getContent() == null) {
                throw new DocumentFormatException("The document doesn't have a valid URL and also no content");
            }
            return true;
        }
        return false;
    }

    protected void setNewLineProperty(Document document) {
        String string = document.getContent().toString();
        String string2 = "";
        int n = 32;
        int n2 = 32;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n2 == 13) {
                if (n == 10) {
                    string2 = "CRLF";
                    break;
                }
                string2 = "CR";
                break;
            }
            if (n2 == 10) {
                if (n == 13) {
                    string2 = "LFCR";
                    break;
                }
                string2 = "LF";
                break;
            }
            n2 = n;
        }
        document.getFeatures().put("docNewLineType", string2);
    }

    private void removeExtraNewLine(Document document) {
        String string = document.getContent().toString();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 32;
        int n2 = 32;
        for (int i = string.length() - 1; i > -1; --i) {
            n = string.charAt(i);
            if (n == 10 && n2 == 13) {
                stringBuffer.deleteCharAt(i + 1);
            }
            if (n == 13 && n2 == 10) {
                stringBuffer.deleteCharAt(i);
                n = n2;
            }
            n2 = n;
        }
        document.setContent(new DocumentContentImpl(stringBuffer.toString()));
    }

    public void annotateParagraphs(Document document, int n, int n2, String string) throws DocumentFormatException {
        int n3;
        if (document == null || document.getContent() == null) {
            return;
        }
        if (n > n2) {
            return;
        }
        AnnotationSet annotationSet = null;
        annotationSet = string == null ? document.getAnnotations() : document.getAnnotations(string);
        String string2 = document.getContent().toString();
        int n4 = n;
        int n5 = n2;
        int n6 = 1;
        boolean bl = false;
        block9: for (n3 = n; n3 < n2; ++n3) {
            char c = string2.charAt(n3);
            if (c == '\n') {
                bl = true;
                while (n3 + 1 < n2 && string2.charAt(n3 + 1) == '\r') {
                    ++n3;
                }
            }
            switch (n6) {
                case 1: {
                    if (Character.isWhitespace(c)) continue block9;
                    n6 = 2;
                    n4 = n3;
                    continue block9;
                }
                case 2: {
                    if (!bl) continue block9;
                    bl = false;
                    n5 = n3;
                    n6 = 3;
                    continue block9;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        n6 = 1;
                        try {
                            annotationSet.add(new Long(n4), new Long(n5), "paragraph", Factory.newFeatureMap());
                            continue block9;
                        }
                        catch (InvalidOffsetException invalidOffsetException) {
                            throw new DocumentFormatException("Coudn't create a paragraph annotation", invalidOffsetException);
                        }
                    }
                    n6 = 2;
                }
            }
        }
        n5 = n3;
        if (n6 == 2 || n6 == 3) {
            try {
                annotationSet.add(new Long(n4), new Long(n5), "paragraph", Factory.newFeatureMap());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new DocumentFormatException("Coudn't create a paragraph annotation", invalidOffsetException);
            }
        }
    }

    public DataStore getDataStore() {
        return null;
    }
}

