/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Document;
import gate.Resource;
import gate.corpora.DocumentImpl;
import gate.corpora.MimeType;
import gate.corpora.TextualDocumentFormat;
import gate.creole.ResourceInstantiationException;
import gate.event.StatusListener;
import gate.sgml.Sgml2Xml;
import gate.util.DocumentFormatException;
import gate.xml.XmlDocumentHandler;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SgmlDocumentFormat
extends TextualDocumentFormat {
    private static final boolean DEBUG = false;

    public void unpackMarkup(Document document) throws DocumentFormatException {
        if (document == null || document.getSourceUrl() == null && document.getContent() == null) {
            throw new DocumentFormatException("GATE document is null or no content found. Nothing to parse!");
        }
        StatusListener statusListener = new StatusListener(){

            public void statusChanged(String string) {
                SgmlDocumentFormat.this.fireStatusChanged(string);
            }
        };
        XmlDocumentHandler xmlDocumentHandler = null;
        try {
            Sgml2Xml sgml2Xml = new Sgml2Xml(document);
            this.fireStatusChanged("Performing SGML to XML...");
            String string = sgml2Xml.convert();
            this.fireStatusChanged("DONE !");
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (null != document) {
                xmlDocumentHandler = new XmlDocumentHandler(document, this.markupElementsMap, this.element2StringMap);
                xmlDocumentHandler.addStatusListener(statusListener);
                sAXParser.parse(string, (DefaultHandler)xmlDocumentHandler);
                ((DocumentImpl)document).setNextAnnotationId(xmlDocumentHandler.getCustomObjectsId());
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DocumentFormatException("XML parser configuration exception ", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new DocumentFormatException(sAXException);
        }
        catch (IOException iOException) {
            throw new DocumentFormatException("I/O exception for " + document.getSourceUrl().toString());
        }
        finally {
            if (xmlDocumentHandler != null) {
                xmlDocumentHandler.removeStatusListener(statusListener);
            }
        }
    }

    private String sgml2Xml(Document document) {
        String string = document.getSourceUrl().toString();
        return string;
    }

    public Resource init() throws ResourceInstantiationException {
        MimeType mimeType = new MimeType("text", "sgml");
        mimeString2ClassHandlerMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), this);
        mimeString2mimeTypeMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), mimeType);
        suffixes2mimeTypeMap.put("sgm", mimeType);
        suffixes2mimeTypeMap.put("sgml", mimeType);
        this.setMimeType(mimeType);
        return this;
    }
}

