/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Document;
import gate.Resource;
import gate.corpora.DocumentContentImpl;
import gate.corpora.MimeType;
import gate.corpora.TextualDocumentFormat;
import gate.creole.ResourceInstantiationException;
import gate.util.DocumentFormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.rtf.RTFEditorKit;

public class RtfDocumentFormat
extends TextualDocumentFormat {
    private static final boolean DEBUG = false;

    public void unpackMarkup(Document document) throws DocumentFormatException {
        if (document == null || document.getSourceUrl() == null && document.getContent() == null) {
            throw new DocumentFormatException("GATE document is null or no content found. Nothing to parse!");
        }
        RTFEditorKit rTFEditorKit = new RTFEditorKit();
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        try {
            InputStream inputStream = document.getSourceUrl() == null ? new ByteArrayInputStream(document.getContent().toString().getBytes()) : document.getSourceUrl().openStream();
            rTFEditorKit.read(inputStream, (javax.swing.text.Document)defaultStyledDocument, 0);
            document.setContent(new DocumentContentImpl(defaultStyledDocument.getText(0, defaultStyledDocument.getLength())));
        }
        catch (BadLocationException badLocationException) {
            throw new DocumentFormatException(badLocationException);
        }
        catch (IOException iOException) {
            throw new DocumentFormatException("I/O exception for " + document.getSourceUrl().toExternalForm(), iOException);
        }
    }

    public Resource init() throws ResourceInstantiationException {
        MimeType mimeType = new MimeType("text", "rtf");
        mimeString2ClassHandlerMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), this);
        mimeString2mimeTypeMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), mimeType);
        suffixes2mimeTypeMap.put("rtf", mimeType);
        magic2mimeTypeMap.put("{\\rtf1", mimeType);
        this.setMimeType(mimeType);
        return this;
    }
}

