/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.DocumentContent;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.TextualDocument;
import gate.corpora.DocumentContentImpl;
import gate.corpora.DocumentImpl;
import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DocumentStaxUtils {
    private static XMLOutputFactory outputFactory = null;

    public static void readGateXmlDocument(XMLStreamReader xMLStreamReader, Document document) throws XMLStreamException {
        DocumentStaxUtils.readGateXmlDocument(xMLStreamReader, document, null);
    }

    public static void readGateXmlDocument(XMLStreamReader xMLStreamReader, Document document, StatusListener statusListener) throws XMLStreamException {
        DocumentContent documentContent = null;
        xMLStreamReader.require(1, null, "GateDocument");
        xMLStreamReader.nextTag();
        xMLStreamReader.require(1, null, "GateDocumentFeatures");
        if (statusListener != null) {
            statusListener.statusChanged("Reading document features");
        }
        FeatureMap featureMap = DocumentStaxUtils.readFeatureMap(xMLStreamReader);
        xMLStreamReader.nextTag();
        xMLStreamReader.require(1, null, "TextWithNodes");
        HashMap hashMap = new HashMap();
        if (statusListener != null) {
            statusListener.statusChanged("Reading document content");
        }
        String string = DocumentStaxUtils.readTextWithNodes(xMLStreamReader, hashMap);
        documentContent = document.getContent();
        document.setContent(new DocumentContentImpl(string));
        try {
            TreeSet treeSet = new TreeSet();
            Boolean bl = null;
            int n = xMLStreamReader.nextTag();
            while (n == 1) {
                xMLStreamReader.require(1, null, "AnnotationSet");
                String string2 = xMLStreamReader.getAttributeValue(null, "Name");
                AnnotationSet annotationSet = null;
                if (string2 == null) {
                    if (statusListener != null) {
                        statusListener.statusChanged("Reading default annotation set");
                    }
                    annotationSet = document.getAnnotations();
                } else {
                    if (statusListener != null) {
                        statusListener.statusChanged("Reading \"" + string2 + "\" annotation set");
                    }
                    annotationSet = document.getAnnotations(string2);
                }
                annotationSet.clear();
                bl = DocumentStaxUtils.readAnnotationSet(xMLStreamReader, annotationSet, hashMap, treeSet, bl);
                n = xMLStreamReader.nextTag();
            }
            xMLStreamReader.require(2, null, "GateDocument");
            document.setFeatures(featureMap);
            if (document instanceof DocumentImpl && treeSet.size() > 0) {
                ((DocumentImpl)document).setNextAnnotationId((Integer)treeSet.last() + 1);
            }
            if (statusListener != null) {
                statusListener.statusChanged("Finished.  " + treeSet.size() + " annotation(s) processed");
            }
        }
        catch (XMLStreamException xMLStreamException) {
            document.setContent(documentContent);
            throw xMLStreamException;
        }
        catch (RuntimeException runtimeException) {
            document.setContent(documentContent);
            throw runtimeException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Boolean readAnnotationSet(XMLStreamReader xMLStreamReader, AnnotationSet annotationSet, Map map, Set set, Boolean bl) throws XMLStreamException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (xMLStreamReader.nextTag() == 1) {
            int n;
            xMLStreamReader.require(1, null, "Annotation");
            AnnotationObject annotationObject = new AnnotationObject();
            annotationObject.setElemName(xMLStreamReader.getAttributeValue(null, "Type"));
            try {
                n = Integer.parseInt(xMLStreamReader.getAttributeValue(null, "StartNode"));
                if (map != null) {
                    Long l = (Long)map.get(new Integer(n));
                    if (l == null) throw new XMLStreamException("Invalid start node ID", xMLStreamReader.getLocation());
                    annotationObject.setStart(l);
                } else {
                    annotationObject.setStart(new Long(n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLStreamException("Non-integer value found for StartNode", xMLStreamReader.getLocation());
            }
            try {
                n = Integer.parseInt(xMLStreamReader.getAttributeValue(null, "EndNode"));
                if (map != null) {
                    Long l = (Long)map.get(new Integer(n));
                    if (l == null) throw new XMLStreamException("Invalid end node ID", xMLStreamReader.getLocation());
                    annotationObject.setEnd(l);
                } else {
                    annotationObject.setEnd(new Long(n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLStreamException("Non-integer value found for EndNode", xMLStreamReader.getLocation());
            }
            Object object = xMLStreamReader.getAttributeValue(null, "Id");
            if (object == null) {
                if (bl == null) {
                    bl = Boolean.FALSE;
                } else if (bl.booleanValue()) {
                    throw new XMLStreamException("New style GATE XML format requires that every annotation specify its Id, but an annotation with no Id was found", xMLStreamReader.getLocation());
                }
            } else {
                if (bl == null) {
                    bl = Boolean.TRUE;
                } else if (!bl.booleanValue()) {
                    throw new XMLStreamException("Old style GATE XML format requires that no annotation specifies its Id, but an annotation with an Id was found", xMLStreamReader.getLocation());
                }
                try {
                    Integer n2 = Integer.valueOf((String)object);
                    if (set.contains(n2)) {
                        throw new XMLStreamException("Annotation IDs must be unique. Found duplicate ID", xMLStreamReader.getLocation());
                    }
                    set.add(n2);
                    annotationObject.setId(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XMLStreamException("Non-integer annotation ID found", xMLStreamReader.getLocation());
                }
            }
            annotationObject.setFM(DocumentStaxUtils.readFeatureMap(xMLStreamReader));
            arrayList.add(annotationObject);
        }
        for (Object object : arrayList) {
            try {
                if (((AnnotationObject)object).getId() != null) {
                    annotationSet.add(((AnnotationObject)object).getId(), ((AnnotationObject)object).getStart(), ((AnnotationObject)object).getEnd(), ((AnnotationObject)object).getElemName(), ((AnnotationObject)object).getFM());
                    continue;
                }
                annotationSet.add(((AnnotationObject)object).getStart(), ((AnnotationObject)object).getEnd(), ((AnnotationObject)object).getElemName(), ((AnnotationObject)object).getFM());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new XMLStreamException("Invalid offset when creating annotation " + object, invalidOffsetException);
            }
        }
        return bl;
    }

    public static String readTextWithNodes(XMLStreamReader xMLStreamReader, Map map) throws XMLStreamException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(20480);
        while ((n = xMLStreamReader.next()) != 2) {
            switch (n) {
                case 4: {
                    stringBuffer.append(xMLStreamReader.getTextCharacters(), xMLStreamReader.getTextStart(), xMLStreamReader.getTextLength());
                    break;
                }
                case 1: {
                    xMLStreamReader.require(1, null, "Node");
                    String string = xMLStreamReader.getAttributeValue(null, "id");
                    if (string == null) {
                        throw new XMLStreamException("Node element has no id", xMLStreamReader.getLocation());
                    }
                    try {
                        Integer n2 = Integer.valueOf(string);
                        Long l = new Long(stringBuffer.length());
                        map.put(n2, l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new XMLStreamException("Node element must have integer id", xMLStreamReader.getLocation());
                    }
                    if (xMLStreamReader.next() == 2) break;
                    throw new XMLStreamException("Node element within TextWithNodes must be empty.", xMLStreamReader.getLocation());
                }
            }
        }
        return stringBuffer.toString();
    }

    public static FeatureMap readFeatureMap(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        FeatureMap featureMap = Factory.newFeatureMap();
        while (xMLStreamReader.nextTag() == 1) {
            xMLStreamReader.require(1, null, "Feature");
            Object object = null;
            Object object2 = null;
            while (xMLStreamReader.nextTag() == 1) {
                if ("Name".equals(xMLStreamReader.getLocalName())) {
                    object = DocumentStaxUtils.readFeatureNameOrValue(xMLStreamReader);
                    continue;
                }
                if ("Value".equals(xMLStreamReader.getLocalName())) {
                    object2 = DocumentStaxUtils.readFeatureNameOrValue(xMLStreamReader);
                    continue;
                }
                throw new XMLStreamException("Feature element should contain only Name and Value children", xMLStreamReader.getLocation());
            }
            featureMap.put(object, object2);
        }
        return featureMap;
    }

    private static Object readFeatureNameOrValue(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n;
        String string;
        String string2 = xMLStreamReader.getAttributeValue(null, "className");
        if (string2 == null) {
            string2 = "java.lang.String";
        }
        if ((string = xMLStreamReader.getAttributeValue(null, "itemClassName")) == null) {
            string = "java.lang.String";
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        block17: while ((n = xMLStreamReader.next()) != 2) {
            switch (n) {
                case 4: {
                    stringBuffer.append(xMLStreamReader.getTextCharacters(), xMLStreamReader.getTextStart(), xMLStreamReader.getTextLength());
                    continue block17;
                }
                case 1: {
                    throw new XMLStreamException("Elements not allowed within feature name or value element.", xMLStreamReader.getLocation());
                }
            }
        }
        if ("java.lang.String".equals(string2)) {
            return stringBuffer.toString();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2, true, Gate.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return stringBuffer.toString();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Object object;
            Class<?> clazz2 = null;
            Constructor<?> constructor = null;
            Collection collection = null;
            boolean bl = false;
            try {
                collection = (Collection)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                return stringBuffer.toString();
            }
            catch (InstantiationException instantiationException) {
                return stringBuffer.toString();
            }
            if ("java.lang.String".equals(string)) {
                bl = true;
            } else {
                try {
                    clazz2 = Class.forName(string, true, Gate.getClassLoader());
                    object = new Class[]{String.class};
                    constructor = clazz2.getConstructor((Class<?>)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Out.prln("Warning: Item class " + string + " not found." + "Adding items as Strings");
                    bl = true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    bl = true;
                }
                catch (SecurityException securityException) {
                    bl = true;
                }
            }
            object = new StringTokenizer(stringBuffer.toString(), ";");
            Object[] objectArray = new Object[1];
            Object e = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if (bl) {
                    collection.add(string3);
                    continue;
                }
                objectArray[0] = string3;
                try {
                    e = constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    throw new XMLStreamException("An item(" + string3 + ")  does not comply with its class" + " definition(" + string + ")", xMLStreamReader.getLocation());
                }
                collection.add(e);
            }
            return collection;
        }
        Class[] classArray = new Class[]{String.class};
        try {
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{stringBuffer.toString()};
            Object obj = constructor.newInstance(objectArray);
            return obj;
        }
        catch (Exception exception) {
            return stringBuffer.toString();
        }
    }

    public static String toXml(Document document) {
        try {
            if (outputFactory == null) {
                outputFactory = XMLOutputFactory.newInstance();
            }
            StringWriter stringWriter = new StringWriter(document.getContent().size().intValue() * 40);
            XMLStreamWriter xMLStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            if (document instanceof TextualDocument) {
                xMLStreamWriter.writeStartDocument(((TextualDocument)document).getEncoding(), "1.0");
            } else {
                xMLStreamWriter.writeStartDocument("1.0");
            }
            DocumentStaxUtils.newLine(xMLStreamWriter);
            DocumentStaxUtils.writeDocument(document, xMLStreamWriter, "");
            xMLStreamWriter.close();
            return stringWriter.toString();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new GateRuntimeException("Error converting document to XML", xMLStreamException);
        }
    }

    public static void writeDocument(Document document, File file) throws XMLStreamException, IOException {
        DocumentStaxUtils.writeDocument(document, file, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, File file, String string) throws XMLStreamException, IOException {
        if (outputFactory == null) {
            outputFactory = XMLOutputFactory.newInstance();
        }
        XMLStreamWriter xMLStreamWriter = null;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            if (document instanceof TextualDocument) {
                xMLStreamWriter = outputFactory.createXMLStreamWriter(fileOutputStream, ((TextualDocument)document).getEncoding());
                xMLStreamWriter.writeStartDocument(((TextualDocument)document).getEncoding(), "1.0");
            } else {
                xMLStreamWriter = outputFactory.createXMLStreamWriter(fileOutputStream);
                xMLStreamWriter.writeStartDocument("1.0");
            }
            DocumentStaxUtils.newLine(xMLStreamWriter);
            DocumentStaxUtils.writeDocument(document, xMLStreamWriter, string);
        }
        finally {
            if (xMLStreamWriter != null) {
                xMLStreamWriter.close();
            }
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static void writeDocument(Document document, XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(string, "GateDocument");
        xMLStreamWriter.setDefaultNamespace(string);
        if (string.length() > 0) {
            xMLStreamWriter.writeDefaultNamespace(string);
        }
        DocumentStaxUtils.newLine(xMLStreamWriter);
        xMLStreamWriter.writeComment(" The document's features");
        DocumentStaxUtils.newLine(xMLStreamWriter);
        DocumentStaxUtils.newLine(xMLStreamWriter);
        xMLStreamWriter.writeStartElement(string, "GateDocumentFeatures");
        DocumentStaxUtils.newLine(xMLStreamWriter);
        DocumentStaxUtils.writeFeatures(document.getFeatures(), xMLStreamWriter, string);
        xMLStreamWriter.writeEndElement();
        DocumentStaxUtils.newLine(xMLStreamWriter);
        xMLStreamWriter.writeComment(" The document content area with serialized nodes ");
        DocumentStaxUtils.newLine(xMLStreamWriter);
        DocumentStaxUtils.newLine(xMLStreamWriter);
        DocumentStaxUtils.writeTextWithNodes(document, xMLStreamWriter, string);
        DocumentStaxUtils.newLine(xMLStreamWriter);
        StatusListener statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
        if (statusListener != null) {
            statusListener.statusChanged("Saving the default annotation set ");
        }
        xMLStreamWriter.writeComment(" The default annotation set ");
        DocumentStaxUtils.newLine(xMLStreamWriter);
        DocumentStaxUtils.newLine(xMLStreamWriter);
        DocumentStaxUtils.writeAnnotationSet(document.getAnnotations(), xMLStreamWriter, string);
        DocumentStaxUtils.newLine(xMLStreamWriter);
        Map map = document.getNamedAnnotationSets();
        if (map != null) {
            for (AnnotationSet annotationSet : map.values()) {
                xMLStreamWriter.writeComment(" Named annotation set ");
                DocumentStaxUtils.newLine(xMLStreamWriter);
                DocumentStaxUtils.newLine(xMLStreamWriter);
                if (statusListener != null) {
                    statusListener.statusChanged("Saving " + annotationSet.getName() + " annotation set ");
                }
                DocumentStaxUtils.writeAnnotationSet(annotationSet, xMLStreamWriter, string);
                DocumentStaxUtils.newLine(xMLStreamWriter);
            }
        }
        xMLStreamWriter.writeEndElement();
        DocumentStaxUtils.newLine(xMLStreamWriter);
    }

    public static void writeAnnotationSet(AnnotationSet annotationSet, XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        DocumentStaxUtils.writeAnnotationSet(annotationSet, annotationSet.getName(), xMLStreamWriter, string);
    }

    public static void writeAnnotationSet(AnnotationSet annotationSet, String string, XMLStreamWriter xMLStreamWriter, String string2) throws XMLStreamException {
        if (annotationSet == null) {
            xMLStreamWriter.writeStartElement(string2, "AnnotationSet");
            DocumentStaxUtils.newLine(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
            DocumentStaxUtils.newLine(xMLStreamWriter);
        }
        xMLStreamWriter.writeStartElement(string2, "AnnotationSet");
        if (string != null) {
            xMLStreamWriter.writeAttribute("Name", string);
        }
        DocumentStaxUtils.newLine(xMLStreamWriter);
        for (Annotation annotation : annotationSet) {
            xMLStreamWriter.writeStartElement(string2, "Annotation");
            xMLStreamWriter.writeAttribute("Id", String.valueOf(annotation.getId()));
            xMLStreamWriter.writeAttribute("Type", annotation.getType());
            xMLStreamWriter.writeAttribute("StartNode", String.valueOf(annotation.getStartNode().getOffset()));
            xMLStreamWriter.writeAttribute("EndNode", String.valueOf(annotation.getEndNode().getOffset()));
            DocumentStaxUtils.newLine(xMLStreamWriter);
            DocumentStaxUtils.writeFeatures(annotation.getFeatures(), xMLStreamWriter, string2);
            xMLStreamWriter.writeEndElement();
            DocumentStaxUtils.newLine(xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
    }

    public static void writeTextWithNodes(Document document, XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        Object object;
        Object object22;
        String string2 = document.getContent().toString();
        if (string2 == null) {
            xMLStreamWriter.writeEmptyElement(string, "TextWithNodes");
            return;
        }
        TreeSet<Long> treeSet = new TreeSet<Long>();
        for (Object object22 : document.getAnnotations()) {
            treeSet.add(object22.getStartNode().getOffset());
            treeSet.add(object22.getEndNode().getOffset());
        }
        object22 = document.getNamedAnnotationSets();
        if (object22 != null) {
            object = object22.values().iterator();
            while (object.hasNext()) {
                AnnotationSet annotationSet = (AnnotationSet)object.next();
                for (Annotation annotation : annotationSet) {
                    treeSet.add(annotation.getStartNode().getOffset());
                    treeSet.add(annotation.getEndNode().getOffset());
                }
            }
        }
        object = string2.toCharArray();
        xMLStreamWriter.writeStartElement(string, "TextWithNodes");
        int n = 0;
        Iterator<Object> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n2 = ((Long)iterator.next()).intValue();
            xMLStreamWriter.writeCharacters((char[])object, n, n2 - n);
            xMLStreamWriter.writeEmptyElement(string, "Node");
            xMLStreamWriter.writeAttribute("id", String.valueOf(n2));
            n = n2;
        }
        xMLStreamWriter.writeCharacters((char[])object, n, ((Object)object).length - n);
        xMLStreamWriter.writeEndElement();
    }

    public static void writeFeatures(FeatureMap featureMap, XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        if (featureMap == null) {
            return;
        }
        Set set = featureMap.keySet();
        for (Object k : set) {
            Iterator iterator;
            StringBuffer stringBuffer;
            Object v = featureMap.get(k);
            if (k == null || v == null) continue;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = k.toString();
            String string7 = v.toString();
            Object object = null;
            if (k instanceof String || k instanceof Number || k instanceof Collection) {
                string2 = k.getClass().getName();
            }
            if (v instanceof String || v instanceof Number || v instanceof Collection) {
                string4 = v.getClass().getName();
            }
            if (string2 == null || string4 == null) continue;
            if (k instanceof Collection) {
                stringBuffer = new StringBuffer();
                iterator = ((Collection)k).iterator();
                if (iterator.hasNext()) {
                    object = iterator.next();
                    string3 = object instanceof Number ? object.getClass().getName() : String.class.getName();
                    stringBuffer.append(object.toString());
                }
                while (iterator.hasNext()) {
                    object = iterator.next();
                    stringBuffer.append(";").append(object.toString());
                }
                string6 = stringBuffer.toString();
            }
            if (v instanceof Collection) {
                stringBuffer = new StringBuffer();
                iterator = ((Collection)v).iterator();
                if (iterator.hasNext()) {
                    object = iterator.next();
                    string5 = object instanceof Number ? object.getClass().getName() : String.class.getName();
                    stringBuffer.append(object.toString());
                }
                while (iterator.hasNext()) {
                    object = iterator.next();
                    stringBuffer.append(";").append(object.toString());
                }
                string7 = stringBuffer.toString();
            }
            xMLStreamWriter.writeStartElement(string, "Feature");
            xMLStreamWriter.writeCharacters("\n  ");
            xMLStreamWriter.writeStartElement(string, "Name");
            if (string2 != null) {
                xMLStreamWriter.writeAttribute("className", string2);
            }
            if (string3 != null) {
                xMLStreamWriter.writeAttribute("itemClassName", string3);
            }
            xMLStreamWriter.writeCharacters(string6);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n  ");
            xMLStreamWriter.writeStartElement(string, "Value");
            if (string4 != null) {
                xMLStreamWriter.writeAttribute("className", string4);
            }
            if (string5 != null) {
                xMLStreamWriter.writeAttribute("itemClassName", string5);
            }
            xMLStreamWriter.writeCharacters(string7);
            xMLStreamWriter.writeEndElement();
            DocumentStaxUtils.newLine(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
            DocumentStaxUtils.newLine(xMLStreamWriter);
        }
    }

    private static void newLine(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeCharacters("\n");
    }

    static class AnnotationObject {
        private String elemName = null;
        private FeatureMap fm = null;
        private Long start = null;
        private Long end = null;
        private Integer id = null;

        public String getElemName() {
            return this.elemName;
        }

        public FeatureMap getFM() {
            return this.fm;
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.end;
        }

        public void setElemName(String string) {
            this.elemName = string;
        }

        public void setFM(FeatureMap featureMap) {
            this.fm = featureMap;
        }

        public void setStart(Long l) {
            this.start = l;
        }

        public void setEnd(Long l) {
            this.end = l;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer n) {
            this.id = n;
        }

        public String toString() {
            return " [id =" + this.id + " type=" + this.elemName + " startNode=" + this.start + " endNode=" + this.end + " features=" + this.fm + "] ";
        }
    }
}

