/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.DataStore;
import gate.Document;
import gate.DocumentContent;
import gate.DocumentFormat;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Node;
import gate.Resource;
import gate.TextualDocument;
import gate.annotation.AnnotationSetImpl;
import gate.corpora.DocumentContentImpl;
import gate.corpora.DocumentStaxUtils;
import gate.corpora.DocumentXmlUtils;
import gate.corpora.HtmlDocumentFormat;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.corpora.XmlDocumentFormat;
import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.event.DocumentEvent;
import gate.event.DocumentListener;
import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.persist.PersistenceException;
import gate.util.DocumentFormatException;
import gate.util.Err;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import gate.util.Out;
import gate.util.SimpleFeatureMapImpl;
import gate.util.Strings;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class DocumentImpl
extends AbstractLanguageResource
implements TextualDocument,
CreoleListener,
DatastoreListener {
    private static final boolean DEBUG = false;
    private Boolean preserveOriginalContent = new Boolean(false);
    private Boolean collectRepositioningInfo = new Boolean(false);
    private Annotation crossedOverAnnotation = null;
    protected int nextAnnotationId = 0;
    protected int nextNodeId = 0;
    protected URL sourceUrl;
    protected String mimeType;
    protected DocumentContent content;
    protected String encoding = null;
    private Annotation theRootAnnotation = null;
    private static final int DOC_SIZE_MULTIPLICATION_FACTOR_AS = 3;
    private final int ORDER_ON_START_OFFSET = 0;
    private final int ORDER_ON_END_OFFSET = 1;
    private final int ORDER_ON_ANNOT_ID = 2;
    private final int ASC = 3;
    private final int DESC = -3;
    protected Long sourceUrlStartOffset;
    protected Long sourceUrlEndOffset;
    protected AnnotationSet defaultAnnots;
    protected Map namedAnnotSets;
    private String stringContent = "";
    protected Boolean markupAware = new Boolean(false);
    static final long serialVersionUID = -8456893608311510260L;
    private transient Vector documentListeners;
    private transient Vector gateListeners;

    public DocumentImpl() {
        this.content = new DocumentContentImpl();
    }

    public FeatureMap getFeatures() {
        if (this.features == null) {
            this.features = new SimpleFeatureMapImpl();
        }
        return this.features;
    }

    public Resource init() throws ResourceInstantiationException {
        Object object;
        if (this.sourceUrl == null) {
            if (this.stringContent == null) {
                throw new ResourceInstantiationException("The sourceURL and document's content were null.");
            }
            this.content = new DocumentContentImpl(this.stringContent);
            this.getFeatures().put("gate.SourceURL", "created from String");
        } else {
            try {
                this.content = new DocumentContentImpl(this.sourceUrl, this.getEncoding(), this.sourceUrlStartOffset, this.sourceUrlEndOffset);
                this.getFeatures().put("gate.SourceURL", this.sourceUrl.toExternalForm());
            }
            catch (IOException iOException) {
                throw new ResourceInstantiationException("DocumentImpl.init: " + iOException);
            }
        }
        if (this.preserveOriginalContent.booleanValue() && this.content != null) {
            object = new String(((DocumentContentImpl)this.content).getOriginalContent());
            this.getFeatures().put("Original_document_content_on_load", object);
        }
        if (this.getMarkupAware().booleanValue()) {
            Object object2;
            object = null;
            if (this.mimeType != null && this.mimeType.length() > 0) {
                object2 = DocumentFormat.getMimeTypeForString(this.mimeType);
                if (object2 == null) {
                    throw new ResourceInstantiationException("MIME type \"" + this.mimeType + " has no registered DocumentFormat");
                }
                object = DocumentFormat.getDocumentFormat((Document)this, (MimeType)object2);
            } else {
                object = DocumentFormat.getDocumentFormat((Document)this, this.sourceUrl);
            }
            try {
                if (object != null) {
                    object2 = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
                    if (object2 != null) {
                        ((DocumentFormat)object).addStatusListener((StatusListener)object2);
                    }
                    ((DocumentFormat)object).setShouldCollectRepositioning(this.collectRepositioningInfo);
                    if (((DocumentFormat)object).getShouldCollectRepositioning().booleanValue()) {
                        RepositioningInfo repositioningInfo = new RepositioningInfo();
                        String string = (String)this.getFeatures().get("Original_document_content_on_load");
                        RepositioningInfo repositioningInfo2 = new RepositioningInfo();
                        if (string != null) {
                            boolean bl = object instanceof XmlDocumentFormat;
                            this.collectInformationForAmpCodding(string, repositioningInfo2, bl);
                            if (object instanceof HtmlDocumentFormat) {
                                this.collectInformationForWS(string, repositioningInfo2);
                            }
                        }
                        ((DocumentFormat)object).unpackMarkup(this, repositioningInfo, repositioningInfo2);
                        if (string != null && object instanceof XmlDocumentFormat) {
                            this.correctRepositioningForCRLFInXML(string, repositioningInfo);
                        }
                        this.getFeatures().put("Document_repositioning_info", repositioningInfo);
                    } else {
                        ((DocumentFormat)object).unpackMarkup(this);
                    }
                    ((DocumentFormat)object).removeStatusListener((StatusListener)object2);
                }
            }
            catch (DocumentFormatException documentFormatException) {
                throw new ResourceInstantiationException("Couldn't unpack markup in document " + (this.sourceUrl != null ? this.sourceUrl.toExternalForm() : "") + "!", documentFormatException);
            }
        }
        return this;
    }

    private void correctRepositioningForCRLFInXML(String string, RepositioningInfo repositioningInfo) {
        int n = -1;
        do {
            if ((n = string.indexOf("\r\n", n + 1)) == -1) continue;
            repositioningInfo.correctInformationOriginalMove(n, 1L);
        } while (n != -1);
    }

    private void collectInformationForAmpCodding(String string, RepositioningInfo repositioningInfo, boolean bl) {
        int n;
        if (string == null || repositioningInfo == null) {
            return;
        }
        int n2 = -1;
        do {
            if ((n2 = string.indexOf(38, n2 + 1)) == -1) continue;
            int n3 = string.indexOf(59, n2 + 1);
            if (n3 != -1 && n3 - n2 < 8) {
                repositioningInfo.addPositionInfo(n2, n3 - n2 + 1, 0L, 1L);
                continue;
            }
            n = Math.min(n2 + 8, string.length());
            String string2 = string.substring(n2, n);
            int n4 = this.analyseAmpCodding(string2);
            if (n4 == -1) continue;
            repositioningInfo.addPositionInfo(n2, n4, 0L, 1L);
        } while (n2 != -1);
        n = -1;
        if (bl) {
            do {
                if ((n = string.indexOf("\r\n", n + 1)) == -1) continue;
                repositioningInfo.correctInformationOriginalMove(n, -1L);
            } while (n != -1);
        }
    }

    private int analyseAmpCodding(String string) {
        int n = -1;
        try {
            char c = string.charAt(1);
            switch (c) {
                case 'L': 
                case 'l': {
                    if (string.charAt(2) != 't' && string.charAt(2) != 'T') break;
                    n = 3;
                    break;
                }
                case 'G': 
                case 'g': {
                    if (string.charAt(2) != 't' && string.charAt(2) != 'T') break;
                    n = 3;
                    break;
                }
                case 'A': 
                case 'a': {
                    if (!string.substring(2, 4).equalsIgnoreCase("mp")) break;
                    n = 4;
                    break;
                }
                case 'Q': 
                case 'q': {
                    if (!string.substring(2, 5).equalsIgnoreCase("uot")) break;
                    n = 5;
                    break;
                }
                case '#': {
                    int n2 = 2;
                    boolean bl = false;
                    if (string.charAt(2) == 'x' || string.charAt(2) == 'X') {
                        ++n2;
                        bl = true;
                    }
                    while (n2 < 8 && this.isNumber(string.charAt(n2), bl)) {
                        ++n2;
                    }
                    n = n2;
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return n;
    }

    private boolean isNumber(char c, boolean bl) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (bl) {
            if (c >= 'A' && c <= 'F') {
                return true;
            }
            if (c >= 'a' && c <= 'f') {
                return true;
            }
        }
        return false;
    }

    private void collectInformationForWS(String string, RepositioningInfo repositioningInfo) {
        if (string == null || repositioningInfo == null) {
            return;
        }
        int n = -1;
        int n2 = -1;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c <= ' ') {
                if (n2 == -1) {
                    n2 = i;
                }
                n = i;
                continue;
            }
            if (n - n2 > 0) {
                repositioningInfo.addPositionInfo(n2, n - n2 + 1, 0L, 1L);
            }
            n = -1;
            n2 = -1;
        }
    }

    public void cleanup() {
        this.defaultAnnots = null;
        if (this.namedAnnotSets != null && !this.namedAnnotSets.isEmpty()) {
            this.namedAnnotSets.clear();
        }
        if (this.lrPersistentId != null) {
            Gate.getCreoleRegister().removeCreoleListener(this);
        }
        if (this.getDataStore() != null) {
            this.getDataStore().removeDatastoreListener(this);
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public URL getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(URL uRL) {
        this.sourceUrl = uRL;
    }

    public Long[] getSourceUrlOffsets() {
        Long[] longArray = new Long[]{this.sourceUrlStartOffset, this.sourceUrlEndOffset};
        return longArray;
    }

    public void setPreserveOriginalContent(Boolean bl) {
        this.preserveOriginalContent = bl;
    }

    public Boolean getPreserveOriginalContent() {
        return this.preserveOriginalContent;
    }

    public void setCollectRepositioningInfo(Boolean bl) {
        this.collectRepositioningInfo = bl;
    }

    public Boolean getCollectRepositioningInfo() {
        return this.collectRepositioningInfo;
    }

    public Long getSourceUrlStartOffset() {
        return this.sourceUrlStartOffset;
    }

    public void setSourceUrlStartOffset(Long l) {
        this.sourceUrlStartOffset = l;
    }

    public Long getSourceUrlEndOffset() {
        return this.sourceUrlEndOffset;
    }

    public void setSourceUrlEndOffset(Long l) {
        this.sourceUrlEndOffset = l;
    }

    public DocumentContent getContent() {
        return this.content;
    }

    public void setContent(DocumentContent documentContent) {
        this.content = documentContent;
        this.stringContent = documentContent.toString();
    }

    public String getEncoding() {
        if (this.encoding == null || this.encoding.trim().length() == 0) {
            this.encoding = Charset.forName(System.getProperty("file.encoding")).name();
        }
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public AnnotationSet getAnnotations() {
        if (this.defaultAnnots == null) {
            this.defaultAnnots = new AnnotationSetImpl(this);
            this.fireAnnotationSetAdded(new DocumentEvent(this, 101, null));
        }
        return this.defaultAnnots;
    }

    public AnnotationSet getAnnotations(String string) {
        AnnotationSet annotationSet;
        if (string == null) {
            return this.getAnnotations();
        }
        if (this.namedAnnotSets == null) {
            this.namedAnnotSets = new HashMap();
        }
        if ((annotationSet = (AnnotationSet)this.namedAnnotSets.get(string)) == null) {
            annotationSet = new AnnotationSetImpl(this, string);
            this.namedAnnotSets.put(string, annotationSet);
            DocumentEvent documentEvent = new DocumentEvent(this, 101, string);
            this.fireAnnotationSetAdded(documentEvent);
        }
        return annotationSet;
    }

    public void setMarkupAware(Boolean bl) {
        this.markupAware = bl;
    }

    public Boolean getMarkupAware() {
        return this.markupAware;
    }

    public String toXml(Set set) {
        return this.toXml(set, true);
    }

    public String toXml(Set set, boolean bl) {
        boolean bl2;
        Annotation annotation2;
        if (this.hasOriginalContentFeatures()) {
            return this.saveAnnotationSetAsXmlInOrig(set, bl);
        }
        AnnotationSet annotationSet = this.getAnnotations("Original markups");
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet.size());
        StatusListener statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
        if (statusListener != null) {
            statusListener.statusChanged("Constructing the dumping annotation set.");
        }
        arrayList.addAll(annotationSet);
        if (set != null) {
            for (Annotation annotation2 : set) {
                if (this.insertsSafety(arrayList, annotation2)) {
                    arrayList.add(annotation2);
                    continue;
                }
                if (this.crossedOverAnnotation == null) continue;
            }
        }
        Collections.sort(arrayList, new OffsetComparator());
        if (statusListener != null) {
            statusListener.statusChanged("Dumping annotations as XML");
        }
        StringBuffer stringBuffer = new StringBuffer(40 * this.getContent().size().intValue());
        annotation2 = this.getFeatures() == null ? null : (String)this.getFeatures().get("MimeType");
        boolean bl3 = bl2 = annotation2 != null && ((String)((Object)annotation2)).equalsIgnoreCase("text/xml");
        if (bl2) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
            stringBuffer.append(this.getEncoding());
            stringBuffer.append("\" ?>");
            stringBuffer.append(Strings.getNl());
        }
        this.theRootAnnotation = this.identifyTheRootAnnotation(arrayList);
        if (this.theRootAnnotation != null) {
            arrayList.remove(this.theRootAnnotation);
            stringBuffer.append(this.writeStartTag(this.theRootAnnotation, bl));
        }
        stringBuffer.append(this.saveAnnotationSetAsXml(arrayList, bl));
        if (this.theRootAnnotation != null) {
            stringBuffer.append(this.writeEndTag(this.theRootAnnotation));
        }
        if (statusListener != null) {
            statusListener.statusChanged("Done.");
        }
        return stringBuffer.toString();
    }

    private boolean insertsSafety(AnnotationSet annotationSet, Annotation annotation) {
        if (annotationSet == null || annotation == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        if (annotation.getStartNode() == null || annotation.getStartNode().getOffset() == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        if (annotation.getEndNode() == null || annotation.getEndNode().getOffset() == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        Long l = annotation.getStartNode().getOffset();
        Long l2 = annotation.getEndNode().getOffset();
        long l3 = l;
        long l4 = l2;
        AnnotationSet annotationSet2 = annotationSet.get(l, l2);
        for (Annotation annotation2 : annotationSet2) {
            long l5 = annotation2.getStartNode().getOffset();
            long l6 = annotation2.getEndNode().getOffset();
            if (l5 < l3 && l3 < l6 && l6 < l4) {
                this.crossedOverAnnotation = annotation2;
                return false;
            }
            if (l3 >= l5 || l5 >= l4 || l4 >= l6) continue;
            this.crossedOverAnnotation = annotation2;
            return false;
        }
        return true;
    }

    private boolean insertsSafety(List list, Annotation annotation) {
        if (list == null || annotation == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        if (annotation.getStartNode() == null || annotation.getStartNode().getOffset() == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        if (annotation.getEndNode() == null || annotation.getEndNode().getOffset() == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        Long l = annotation.getStartNode().getOffset();
        Long l2 = annotation.getEndNode().getOffset();
        long l3 = l;
        long l4 = l2;
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (int i = 0; i < list.size(); ++i) {
            Annotation annotation2 = (Annotation)list.get(i);
            if (annotation2.getStartNode().getOffset() >= l3 && annotation2.getStartNode().getOffset() <= l4) {
                arrayList.add(annotation2);
                continue;
            }
            if (annotation2.getEndNode().getOffset() < l3 || annotation2.getEndNode().getOffset() > l4) continue;
            arrayList.add(annotation2);
        }
        for (Annotation annotation2 : arrayList) {
            long l5 = annotation2.getStartNode().getOffset();
            long l6 = annotation2.getEndNode().getOffset();
            if (l5 < l3 && l3 < l6 && l6 < l4) {
                this.crossedOverAnnotation = annotation2;
                return false;
            }
            if (l3 >= l5 || l5 >= l4 || l4 >= l6) continue;
            this.crossedOverAnnotation = annotation2;
            return false;
        }
        return true;
    }

    private String saveAnnotationSetAsXml(AnnotationSet annotationSet, boolean bl) {
        Comparable comparable2;
        String string = null;
        string = this.getContent() == null ? new String("") : this.getContent().toString();
        StringBuffer stringBuffer = DocumentXmlUtils.filterNonXmlChars(new StringBuffer(string));
        if (annotationSet == null) {
            return stringBuffer.toString();
        }
        TreeMap treeMap = new TreeMap();
        if (this.getContent().size() != 0L) {
            this.buildEntityMapFromString(string, treeMap);
        }
        TreeSet<Long> treeSet = new TreeSet<Long>();
        for (Comparable comparable2 : annotationSet) {
            treeSet.add(comparable2.getStartNode().getOffset());
            treeSet.add(comparable2.getEndNode().getOffset());
        }
        while (!treeSet.isEmpty()) {
            Comparable comparable3;
            comparable2 = (Long)treeSet.last();
            treeSet.remove(comparable2);
            List list = this.getAnnotationsForOffset(annotationSet, (Long)comparable2);
            StringBuffer stringBuffer2 = new StringBuffer(3 * this.getContent().size().intValue());
            Stack<Comparable> stack = new Stack<Comparable>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Annotation annotation;
                comparable3 = (Annotation)iterator.next();
                iterator.remove();
                if (((Long)comparable2).equals(comparable3.getEndNode().getOffset())) {
                    if (((Long)comparable2).equals(comparable3.getStartNode().getOffset())) {
                        if (null != comparable3.getFeatures().get("isEmptyAndSpan") && "true".equals((String)comparable3.getFeatures().get("isEmptyAndSpan"))) {
                            stringBuffer2.append(this.writeStartTag((Annotation)comparable3, bl));
                            stack.push(comparable3);
                            continue;
                        }
                        stringBuffer2.append(this.writeEmptyTag((Annotation)comparable3));
                        annotationSet.remove(comparable3);
                        continue;
                    }
                    if (!stack.isEmpty()) {
                        while (!stack.isEmpty()) {
                            annotation = (Annotation)stack.pop();
                            stringBuffer2.append(this.writeEndTag(annotation));
                        }
                    }
                    stringBuffer2.append(this.writeEndTag((Annotation)comparable3));
                    continue;
                }
                if (!((Long)comparable2).equals(comparable3.getStartNode().getOffset())) continue;
                if (!stack.isEmpty()) {
                    while (!stack.isEmpty()) {
                        annotation = (Annotation)stack.pop();
                        stringBuffer2.append(this.writeEndTag(annotation));
                    }
                }
                stringBuffer2.append(this.writeStartTag((Annotation)comparable3, bl));
                annotationSet.remove(comparable3);
            }
            if (!stack.isEmpty()) {
                while (!stack.isEmpty()) {
                    comparable3 = (Annotation)stack.pop();
                    stringBuffer2.append(this.writeEndTag((Annotation)comparable3));
                }
            }
            if (!treeMap.isEmpty()) {
                comparable3 = (Long)treeMap.lastKey();
                while (!treeMap.isEmpty() && ((Long)comparable3).intValue() >= ((Long)comparable2).intValue()) {
                    stringBuffer.replace(((Long)comparable3).intValue(), ((Long)comparable3).intValue() + 1, (String)DocumentXmlUtils.entitiesMap.get((Character)treeMap.get(comparable3)));
                    treeMap.remove(comparable3);
                    if (treeMap.isEmpty()) continue;
                    comparable3 = (Long)treeMap.lastKey();
                }
            }
            stringBuffer.insert(((Long)comparable2).intValue(), stringBuffer2.toString());
        }
        while (!treeMap.isEmpty()) {
            comparable2 = (Long)treeMap.lastKey();
            stringBuffer.replace(((Long)comparable2).intValue(), ((Long)comparable2).intValue() + 1, (String)DocumentXmlUtils.entitiesMap.get((Character)treeMap.get(comparable2)));
            treeMap.remove(comparable2);
        }
        return stringBuffer.toString();
    }

    private String saveAnnotationSetAsXml(List list, boolean bl) {
        Object object;
        Comparable<Long> comparable;
        Comparable<Long> comparable2;
        Object object22;
        ArrayList<Annotation> arrayList;
        String string = null;
        string = this.getContent() == null ? new String("") : this.getContent().toString();
        StringBuffer stringBuffer = DocumentXmlUtils.filterNonXmlChars(new StringBuffer(string));
        if (list == null) {
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer2 = new StringBuffer(3 * this.getContent().size().intValue());
        Long l = new Long(0L);
        TreeMap treeMap = new TreeMap();
        HashMap<Long, ArrayList<Annotation>> hashMap = new HashMap<Long, ArrayList<Annotation>>(100);
        if (this.getContent().size() != 0L) {
            this.buildEntityMapFromString(string, treeMap);
        }
        TreeSet<Long> treeSet = new TreeSet<Long>();
        for (Annotation annotation : list) {
            Long l2 = annotation.getStartNode().getOffset();
            Long l3 = annotation.getEndNode().getOffset();
            treeSet.add(l2);
            treeSet.add(l3);
            if (hashMap.containsKey(l2)) {
                ((List)hashMap.get(l2)).add(annotation);
            } else {
                arrayList = new ArrayList(10);
                arrayList.add(annotation);
                hashMap.put(l2, arrayList);
            }
            if (hashMap.containsKey(l3)) {
                ((List)hashMap.get(l3)).add(annotation);
                continue;
            }
            arrayList = new ArrayList<Annotation>(10);
            arrayList.add(annotation);
            hashMap.put(l3, arrayList);
        }
        arrayList = treeSet.iterator();
        StringBuffer stringBuffer3 = new StringBuffer(255);
        Stack<Object> stack = new Stack<Object>();
        while (arrayList.hasNext()) {
            Long l4 = (Long)arrayList.next();
            List list2 = (List)hashMap.get(l4);
            list2 = this.getAnnotationsForOffset(list2, l4);
            stringBuffer3.setLength(0);
            stack.clear();
            for (Object object22 : list2) {
                if (l4.equals(object22.getEndNode().getOffset())) {
                    if (l4.equals(object22.getStartNode().getOffset())) {
                        if (null != object22.getFeatures().get("isEmptyAndSpan") && "true".equals((String)object22.getFeatures().get("isEmptyAndSpan"))) {
                            stringBuffer3.append(this.writeStartTag((Annotation)object22, bl));
                            stack.push(object22);
                            continue;
                        }
                        stringBuffer3.append(this.writeEmptyTag((Annotation)object22));
                        list.remove(object22);
                        continue;
                    }
                    if (!stack.isEmpty()) {
                        while (!stack.isEmpty()) {
                            comparable2 = (Annotation)stack.pop();
                            stringBuffer3.append(this.writeEndTag((Annotation)comparable2));
                        }
                    }
                    stringBuffer3.append(this.writeEndTag((Annotation)object22));
                    continue;
                }
                if (!l4.equals(object22.getStartNode().getOffset())) continue;
                if (!stack.isEmpty()) {
                    while (!stack.isEmpty()) {
                        comparable2 = (Annotation)stack.pop();
                        stringBuffer3.append(this.writeEndTag((Annotation)comparable2));
                    }
                }
                stringBuffer3.append(this.writeStartTag((Annotation)object22, bl));
            }
            if (!stack.isEmpty()) {
                while (!stack.isEmpty()) {
                    comparable2 = (Annotation)stack.pop();
                    stringBuffer3.append(this.writeEndTag((Annotation)comparable2));
                }
            }
            comparable = new StringBuffer();
            object = treeMap.subMap(l, l4);
            Long l5 = l;
            if (!object.isEmpty()) {
                Long l6 = (Long)object.firstKey();
                String string2 = (String)DocumentXmlUtils.entitiesMap.get((Character)treeMap.get(l6));
                ((StringBuffer)comparable).append(stringBuffer.substring(l5.intValue(), l6.intValue()));
                ((StringBuffer)comparable).append(string2);
                l5 = new Long(l6 + 1L);
            }
            ((StringBuffer)comparable).append(stringBuffer.substring(l5.intValue(), l4.intValue()));
            stringBuffer2.append((StringBuffer)comparable);
            stringBuffer2.append(stringBuffer3.toString());
            l = l4;
        }
        StringBuffer stringBuffer4 = new StringBuffer();
        object22 = treeMap.subMap(l, new Long(stringBuffer.length()));
        comparable = l;
        if (!object22.isEmpty()) {
            comparable2 = object22.firstKey();
            object = (String)DocumentXmlUtils.entitiesMap.get((Character)treeMap.get(comparable2));
            stringBuffer4.append(stringBuffer.substring(((Long)comparable).intValue(), ((Long)comparable2).intValue()));
            stringBuffer4.append((String)object);
            comparable = new Long((Long)comparable2 + 1L);
        }
        stringBuffer4.append(stringBuffer.substring(((Long)comparable).intValue(), stringBuffer.length()));
        stringBuffer2.append(stringBuffer4);
        return stringBuffer2.toString();
    }

    private boolean hasOriginalContentFeatures() {
        FeatureMap featureMap = this.getFeatures();
        boolean bl = false;
        bl = featureMap.get("Original_document_content_on_load") != null && featureMap.get("Document_repositioning_info") != null;
        return bl;
    }

    private String saveAnnotationSetAsXmlInOrig(Set set, boolean bl) {
        String string = (String)this.features.get("Original_document_content_on_load");
        if (string == null) {
            string = "";
        }
        long l = string.length();
        RepositioningInfo repositioningInfo = (RepositioningInfo)this.getFeatures().get("Document_repositioning_info");
        StringBuffer stringBuffer = new StringBuffer(string);
        if (set == null) {
            return stringBuffer.toString();
        }
        StatusListener statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
        AnnotationSet annotationSet = this.getAnnotations("Original markups");
        AnnotationSetImpl annotationSetImpl = new AnnotationSetImpl(this);
        if (statusListener != null) {
            statusListener.statusChanged("Constructing the dumping annotation set.");
        }
        if (set != null) {
            for (Object object : set) {
                if (this.insertsSafety(annotationSet, (Annotation)object) && this.insertsSafety(annotationSetImpl, (Annotation)object)) {
                    annotationSetImpl.add((Annotation)object);
                    continue;
                }
                Out.prln("Warning: Annotation with ID=" + object.getId() + ", startOffset=" + object.getStartNode().getOffset() + ", endOffset=" + object.getEndNode().getOffset() + ", type=" + object.getType() + " was found to violate the" + " crossed over condition. It will be discarded");
            }
        }
        if (statusListener != null) {
            statusListener.statusChanged("Dumping annotations as XML");
        }
        TreeSet treeSet = new TreeSet();
        for (Comparable comparable : set) {
            treeSet.add(comparable.getStartNode().getOffset());
            treeSet.add(comparable.getEndNode().getOffset());
        }
        while (!treeSet.isEmpty()) {
            boolean bl2;
            Annotation annotation;
            Comparable comparable;
            comparable = (Long)treeSet.last();
            treeSet.remove(comparable);
            List list = this.getAnnotationsForOffset(set, (Long)comparable);
            StringBuffer stringBuffer2 = new StringBuffer("");
            Stack<Annotation> stack = new Stack<Annotation>();
            Iterator iterator = list.iterator();
            Annotation annotation2 = null;
            while (iterator.hasNext()) {
                annotation2 = (Annotation)iterator.next();
                iterator.remove();
                if (((Long)comparable).equals(annotation2.getEndNode().getOffset())) {
                    if (((Long)comparable).equals(annotation2.getStartNode().getOffset())) {
                        if (null != annotation2.getFeatures().get("isEmptyAndSpan") && "true".equals((String)annotation2.getFeatures().get("isEmptyAndSpan"))) {
                            stringBuffer2.append(this.writeStartTag(annotation2, bl, false));
                            stack.push(annotation2);
                            continue;
                        }
                        stringBuffer2.append(this.writeEmptyTag(annotation2, false));
                        set.remove(annotation2);
                        continue;
                    }
                    while (!stack.isEmpty()) {
                        annotation = (Annotation)stack.pop();
                        stringBuffer2.append(this.writeEndTag(annotation));
                    }
                    stringBuffer2.append(this.writeEndTag(annotation2));
                    continue;
                }
                if (!((Long)comparable).equals(annotation2.getStartNode().getOffset())) continue;
                while (!stack.isEmpty()) {
                    annotation = (Annotation)stack.pop();
                    stringBuffer2.append(this.writeEndTag(annotation));
                }
                stringBuffer2.append(this.writeStartTag(annotation2, bl, false));
                set.remove(annotation2);
            }
            while (!stack.isEmpty()) {
                annotation = (Annotation)stack.pop();
                stringBuffer2.append(this.writeEndTag(annotation));
            }
            long l2 = -1L;
            boolean bl3 = bl2 = annotation2 != null && ((Long)comparable).equals(annotation2.getEndNode().getOffset());
            if (bl2) {
                l2 = repositioningInfo.getOriginalPos(((Long)comparable).intValue(), true);
            }
            if (l2 == -1L) {
                l2 = repositioningInfo.getOriginalPos(((Long)comparable).intValue());
            }
            if (l2 != -1L && l2 <= l) {
                stringBuffer.insert((int)l2, stringBuffer2.toString());
                continue;
            }
            Out.prln("Error in the repositioning. The offset (" + ((Long)comparable).intValue() + ") could not be positioned in the original document. \n" + "Calculated position is: " + l2 + " placed back: " + bl2);
        }
        if (this.theRootAnnotation != null) {
            stringBuffer.append(this.writeEndTag(this.theRootAnnotation));
        }
        return stringBuffer.toString();
    }

    private List getAnnotationsForOffset(Set set, Long l) {
        LinkedList linkedList = new LinkedList();
        if (set == null || l == null) {
            return linkedList;
        }
        TreeSet<Annotation> treeSet = new TreeSet<Annotation>(new AnnotationComparator(1, -3));
        TreeSet<Annotation> treeSet2 = new TreeSet<Annotation>(new AnnotationComparator(0, -3));
        TreeSet<Annotation> treeSet3 = new TreeSet<Annotation>(new AnnotationComparator(2, 3));
        for (Annotation annotation : set) {
            if (l.equals(annotation.getStartNode().getOffset())) {
                if (l.equals(annotation.getEndNode().getOffset())) {
                    treeSet3.add(annotation);
                    continue;
                }
                treeSet.add(annotation);
                continue;
            }
            if (!l.equals(annotation.getEndNode().getOffset())) continue;
            treeSet2.add(annotation);
        }
        linkedList.addAll(treeSet2);
        treeSet2 = null;
        linkedList.addAll(treeSet);
        treeSet = null;
        Iterator iterator = treeSet3.iterator();
        while (iterator.hasNext()) {
            Annotation annotation;
            annotation = (Annotation)iterator.next();
            Iterator iterator2 = linkedList.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                Annotation annotation2 = (Annotation)iterator2.next();
                if (annotation2.getId() <= annotation.getId()) continue;
                linkedList.add(linkedList.indexOf(annotation2), annotation);
                bl = true;
                break;
            }
            if (!bl) {
                linkedList.add(annotation);
            }
            iterator.remove();
        }
        return linkedList;
    }

    private List getAnnotationsForOffset(List list, Long l) {
        ArrayList arrayList = new ArrayList();
        if (list == null || l == null) {
            return arrayList;
        }
        TreeSet<Annotation> treeSet = new TreeSet<Annotation>(new AnnotationComparator(1, -3));
        TreeSet<Annotation> treeSet2 = new TreeSet<Annotation>(new AnnotationComparator(0, -3));
        TreeSet<Annotation> treeSet3 = new TreeSet<Annotation>(new AnnotationComparator(2, 3));
        for (Annotation annotation : list) {
            if (l.equals(annotation.getStartNode().getOffset())) {
                if (l.equals(annotation.getEndNode().getOffset())) {
                    treeSet3.add(annotation);
                    continue;
                }
                treeSet.add(annotation);
                continue;
            }
            if (!l.equals(annotation.getEndNode().getOffset())) continue;
            treeSet2.add(annotation);
        }
        arrayList.addAll(treeSet2);
        arrayList.addAll(treeSet);
        treeSet2 = null;
        treeSet = null;
        Iterator iterator = treeSet3.iterator();
        while (iterator.hasNext()) {
            Annotation annotation;
            annotation = (Annotation)iterator.next();
            Iterator iterator2 = arrayList.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                Annotation annotation2 = (Annotation)iterator2.next();
                if (annotation2.getId() <= annotation.getId()) continue;
                arrayList.add(arrayList.indexOf(annotation2), annotation);
                bl = true;
                break;
            }
            if (!bl) {
                arrayList.add(annotation);
            }
            iterator.remove();
        }
        return arrayList;
    }

    private String writeStartTag(Annotation annotation, boolean bl) {
        return this.writeStartTag(annotation, bl, true);
    }

    private String writeStartTag(Annotation annotation, boolean bl, boolean bl2) {
        AnnotationSet annotationSet = this.getAnnotations("Original markups");
        StringBuffer stringBuffer = new StringBuffer("");
        if (annotation == null) {
            return stringBuffer.toString();
        }
        if (this.theRootAnnotation != null && annotation.getId().equals(this.theRootAnnotation.getId())) {
            if (bl) {
                stringBuffer.append("<");
                stringBuffer.append(annotation.getType());
                stringBuffer.append(" ");
                if (bl2) {
                    stringBuffer.append(" xmlns:gate=\"http://www.gate.ac.uk\"");
                    stringBuffer.append(" gate:");
                }
                stringBuffer.append("gateId=\"");
                stringBuffer.append(annotation.getId());
                stringBuffer.append("\"");
                stringBuffer.append(" ");
                if (bl2) {
                    stringBuffer.append("gate:");
                }
                stringBuffer.append("annotMaxId=\"");
                stringBuffer.append(this.nextAnnotationId);
                stringBuffer.append("\"");
                stringBuffer.append(this.writeFeatures(annotation.getFeatures(), bl2));
                stringBuffer.append(">");
            } else if (annotationSet.contains(annotation)) {
                stringBuffer.append("<");
                stringBuffer.append(annotation.getType());
                stringBuffer.append(this.writeFeatures(annotation.getFeatures(), bl2));
                stringBuffer.append(">");
            } else {
                stringBuffer.append("<");
                stringBuffer.append(annotation.getType());
                stringBuffer.append(">");
            }
        } else if (bl) {
            stringBuffer.append("<");
            stringBuffer.append(annotation.getType());
            stringBuffer.append(" ");
            if (bl2) {
                stringBuffer.append("gate:");
            }
            stringBuffer.append("gateId=\"");
            stringBuffer.append(annotation.getId());
            stringBuffer.append("\"");
            stringBuffer.append(this.writeFeatures(annotation.getFeatures(), bl2));
            stringBuffer.append(">");
        } else if (annotationSet.contains(annotation)) {
            stringBuffer.append("<");
            stringBuffer.append(annotation.getType());
            stringBuffer.append(this.writeFeatures(annotation.getFeatures(), bl2));
            stringBuffer.append(">");
        } else {
            stringBuffer.append("<");
            stringBuffer.append(annotation.getType());
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    private Annotation identifyTheRootAnnotation(AnnotationSet annotationSet) {
        if (annotationSet == null) {
            return null;
        }
        Node node = annotationSet.firstNode();
        Node node2 = annotationSet.lastNode();
        if (node.getOffset() != 0L) {
            return null;
        }
        Annotation annotation = null;
        long l = node.getOffset();
        long l2 = node2.getOffset();
        for (Annotation annotation2 : annotationSet) {
            if (l != annotation2.getStartNode().getOffset() || l2 != annotation2.getEndNode().getOffset()) continue;
            if (annotation == null) {
                annotation = annotation2;
                continue;
            }
            if (annotation.getId() <= annotation2.getId()) continue;
            annotation = annotation2;
        }
        return annotation;
    }

    private Annotation identifyTheRootAnnotation(List list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (((Annotation)list.get(0)).getStartNode().getOffset() > 0L) {
            return null;
        }
        if (list.size() == 1) {
            Annotation annotation = (Annotation)list.get(0);
            if (annotation.getEndNode().getOffset().equals(this.content.size())) {
                return annotation;
            }
            return null;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < list.size(); ++i) {
            Annotation annotation = (Annotation)list.get(i);
            long l3 = annotation.getEndNode().getOffset();
            if (l3 <= l2) continue;
            l2 = l3;
        }
        Annotation annotation = null;
        for (int i = 0; i < list.size(); ++i) {
            Annotation annotation2 = (Annotation)list.get(i);
            long l4 = annotation2.getStartNode().getOffset();
            long l5 = annotation2.getEndNode().getOffset();
            if (l != l4 || l2 != l5) continue;
            if (annotation == null) {
                annotation = annotation2;
                continue;
            }
            if (annotation.getId() <= annotation2.getId()) continue;
            annotation = annotation2;
        }
        return annotation;
    }

    private void buildEntityMapFromString(String string, TreeMap treeMap) {
        if (string == null || treeMap == null) {
            return;
        }
        if (DocumentXmlUtils.entitiesMap == null || DocumentXmlUtils.entitiesMap.isEmpty()) {
            Err.prln("WARNING: Entities map was not initialised !");
            return;
        }
        for (Character c : DocumentXmlUtils.entitiesMap.keySet()) {
            int n = 0;
            while (-1 != n) {
                n = string.indexOf(c.charValue(), n);
                if (-1 == n) continue;
                treeMap.put(new Long(n), c);
                ++n;
            }
        }
    }

    private String writeEmptyTag(Annotation annotation) {
        return this.writeEmptyTag(annotation, true);
    }

    private String writeEmptyTag(Annotation annotation, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (annotation == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append("<");
        stringBuffer.append(annotation.getType());
        AnnotationSet annotationSet = this.getAnnotations("Original markups");
        if (!annotationSet.contains(annotation)) {
            stringBuffer.append(" gateId=\"");
            stringBuffer.append(annotation.getId());
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.writeFeatures(annotation.getFeatures(), bl));
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    private String writeEndTag(Annotation annotation) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (annotation == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append("</" + annotation.getType() + ">");
        return stringBuffer.toString();
    }

    private String writeFeatures(FeatureMap featureMap, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (featureMap == null) {
            return stringBuffer.toString();
        }
        for (Object k : featureMap.keySet()) {
            Object v = featureMap.get(k);
            if (k == null || v == null || "isEmptyAndSpan".equals(k.toString())) continue;
            if (!String.class.isAssignableFrom(k.getClass()) && !Number.class.isAssignableFrom(k.getClass())) {
                Out.prln("Warning:Found a feature NAME(" + k + ") that doesn't came" + " from String or Number.(feature discarded)");
                continue;
            }
            if (!(String.class.isAssignableFrom(v.getClass()) || Number.class.isAssignableFrom(v.getClass()) || Collection.class.isAssignableFrom(v.getClass()))) {
                Out.prln("Warning:Found a feature VALUE(" + v + ") that doesn't came" + " from String, Number or Collection.(feature discarded)");
                continue;
            }
            if ("matches".equals(k)) {
                stringBuffer.append(" ");
                if (bl) {
                    stringBuffer.append("gate:");
                }
                stringBuffer.append(DocumentXmlUtils.combinedNormalisation(k.toString()));
                stringBuffer.append("=\"");
            } else {
                stringBuffer.append(" ");
                stringBuffer.append(DocumentXmlUtils.combinedNormalisation(k.toString()));
                stringBuffer.append("=\"");
            }
            if (Collection.class.isAssignableFrom(v.getClass())) {
                for (Object e : (Collection)v) {
                    if (!String.class.isAssignableFrom(e.getClass()) && !Number.class.isAssignableFrom(e.getClass())) continue;
                    stringBuffer.append(DocumentXmlUtils.combinedNormalisation(e.toString()));
                    stringBuffer.append(";");
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == ';') {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
            } else {
                stringBuffer.append(DocumentXmlUtils.combinedNormalisation(v.toString()));
            }
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public String toXml() {
        return DocumentStaxUtils.toXml(this);
    }

    private void annotationSetToXml(AnnotationSet annotationSet, StringBuffer stringBuffer) {
        DocumentXmlUtils.annotationSetToXml(annotationSet, stringBuffer);
    }

    public Map getNamedAnnotationSets() {
        return this.namedAnnotSets;
    }

    public Set getAnnotationSetNames() {
        return this.namedAnnotSets == null ? null : this.namedAnnotSets.keySet();
    }

    public void removeAnnotationSet(String string) {
        Object v = this.namedAnnotSets.remove(string);
        if (v != null) {
            this.fireAnnotationSetRemoved(new DocumentEvent(this, 102, string));
        }
    }

    public void edit(Long l, Long l2, DocumentContent documentContent) throws InvalidOffsetException {
        if (!this.isValidOffsetRange(l, l2)) {
            throw new InvalidOffsetException();
        }
        if (this.content != null) {
            ((DocumentContentImpl)this.content).edit(l, l2, documentContent);
        }
        if (this.defaultAnnots != null) {
            ((AnnotationSetImpl)this.defaultAnnots).edit(l, l2, documentContent);
        }
        if (this.namedAnnotSets != null) {
            Iterator iterator = this.namedAnnotSets.values().iterator();
            while (iterator.hasNext()) {
                ((AnnotationSetImpl)iterator.next()).edit(l, l2, documentContent);
            }
        }
        this.fireContentEdited(new DocumentEvent(this, 103, l, l2));
    }

    public boolean isValidOffset(Long l) {
        if (l == null) {
            return false;
        }
        long l2 = l;
        return l2 <= this.getContent().size() && l2 >= 0L;
    }

    public boolean isValidOffsetRange(Long l, Long l2) {
        return this.isValidOffset(l) && this.isValidOffset(l2) && l <= l2;
    }

    public void setNextAnnotationId(int n) {
        this.nextAnnotationId = n;
    }

    public Integer getNextAnnotationId() {
        return new Integer(this.nextAnnotationId++);
    }

    public Integer getNextNodeId() {
        return new Integer(this.nextNodeId++);
    }

    public int compareTo(Object object) throws ClassCastException {
        DocumentImpl documentImpl = (DocumentImpl)object;
        return this.getOrderingString().compareTo(documentImpl.getOrderingString());
    }

    protected String getOrderingString() {
        if (this.sourceUrl == null) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(this.sourceUrl.toString());
        if (this.sourceUrlStartOffset != null && this.sourceUrlEndOffset != null) {
            stringBuffer.append(this.sourceUrlStartOffset.toString());
            stringBuffer.append(this.sourceUrlEndOffset.toString());
        }
        return stringBuffer.toString();
    }

    public String getStringContent() {
        return this.stringContent;
    }

    public void setStringContent(String string) {
        this.stringContent = string;
    }

    public String toString() {
        String string = Strings.getNl();
        StringBuffer stringBuffer = new StringBuffer("DocumentImpl: " + string);
        stringBuffer.append("  content:" + this.content + string);
        stringBuffer.append("  defaultAnnots:" + this.defaultAnnots + string);
        stringBuffer.append("  encoding:" + this.encoding + string);
        stringBuffer.append("  features:" + this.features + string);
        stringBuffer.append("  markupAware:" + this.markupAware + string);
        stringBuffer.append("  namedAnnotSets:" + this.namedAnnotSets + string);
        stringBuffer.append("  nextAnnotationId:" + this.nextAnnotationId + string);
        stringBuffer.append("  nextNodeId:" + this.nextNodeId + string);
        stringBuffer.append("  sourceUrl:" + this.sourceUrl + string);
        stringBuffer.append("  sourceUrlStartOffset:" + this.sourceUrlStartOffset + string);
        stringBuffer.append("  sourceUrlEndOffset:" + this.sourceUrlEndOffset + string);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public synchronized void removeDocumentListener(DocumentListener documentListener) {
        if (this.documentListeners != null && this.documentListeners.contains(documentListener)) {
            Vector vector = (Vector)this.documentListeners.clone();
            vector.removeElement(documentListener);
            this.documentListeners = vector;
        }
    }

    public synchronized void addDocumentListener(DocumentListener documentListener) {
        Vector vector;
        Vector vector2 = vector = this.documentListeners == null ? new Vector(2) : (Vector)this.documentListeners.clone();
        if (!vector.contains(documentListener)) {
            vector.addElement(documentListener);
            this.documentListeners = vector;
        }
    }

    protected void fireAnnotationSetAdded(DocumentEvent documentEvent) {
        if (this.documentListeners != null) {
            Vector vector = this.documentListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((DocumentListener)vector.elementAt(i)).annotationSetAdded(documentEvent);
            }
        }
    }

    protected void fireAnnotationSetRemoved(DocumentEvent documentEvent) {
        if (this.documentListeners != null) {
            Vector vector = this.documentListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((DocumentListener)vector.elementAt(i)).annotationSetRemoved(documentEvent);
            }
        }
    }

    protected void fireContentEdited(DocumentEvent documentEvent) {
        if (this.documentListeners != null) {
            Vector vector = this.documentListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((DocumentListener)vector.elementAt(i)).contentEdited(documentEvent);
            }
        }
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
        if (!creoleEvent.getDatastore().equals(this.getDataStore())) {
            return;
        }
        Factory.deleteResource(this);
    }

    public void setLRPersistenceId(Object object) {
        super.setLRPersistenceId(object);
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    public void resourceAdopted(DatastoreEvent datastoreEvent) {
    }

    public void resourceDeleted(DatastoreEvent datastoreEvent) {
        if (!datastoreEvent.getSource().equals(this.getDataStore())) {
            return;
        }
        if (datastoreEvent.getResourceID().equals(this.getLRPersistenceId())) {
            Factory.deleteResource(this);
        }
    }

    public void resourceWritten(DatastoreEvent datastoreEvent) {
    }

    public void setDataStore(DataStore dataStore) throws PersistenceException {
        super.setDataStore(dataStore);
        if (this.dataStore != null) {
            this.dataStore.addDatastoreListener(this);
        }
    }

    public void setDefaultAnnotations(AnnotationSet annotationSet) {
        this.defaultAnnots = annotationSet;
    }

    class AnnotationComparator
    implements Comparator {
        int orderOn = -1;
        int orderType = 3;

        public AnnotationComparator(int n, int n2) {
            this.orderOn = n;
            this.orderType = n2;
        }

        public int compare(Object object, Object object2) {
            Annotation annotation = (Annotation)object;
            Annotation annotation2 = (Annotation)object2;
            if (this.orderOn == 0) {
                int n = annotation.getStartNode().getOffset().compareTo(annotation2.getStartNode().getOffset());
                if (this.orderType == 3) {
                    if (n == 0) {
                        return annotation.getId().compareTo(annotation2.getId());
                    }
                    return n;
                }
                if (n == 0) {
                    return -annotation.getId().compareTo(annotation2.getId());
                }
                return -n;
            }
            if (this.orderOn == 1) {
                int n = annotation.getEndNode().getOffset().compareTo(annotation2.getEndNode().getOffset());
                if (this.orderType == 3) {
                    if (n == 0) {
                        return -annotation.getId().compareTo(annotation2.getId());
                    }
                    return n;
                }
                if (n == 0) {
                    return annotation.getId().compareTo(annotation2.getId());
                }
                return -n;
            }
            if (this.orderOn == 2) {
                if (this.orderType == 3) {
                    return annotation.getId().compareTo(annotation2.getId());
                }
                return -annotation.getId().compareTo(annotation2.getId());
            }
            return 0;
        }
    }
}

