/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.corpora.DocumentImpl;
import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.util.Err;
import gate.util.Strings;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class CorpusImpl
extends AbstractLanguageResource
implements Corpus,
CreoleListener {
    private static final boolean DEBUG = false;
    protected List supportList = Collections.synchronizedList(new VerboseList());
    static final long serialVersionUID = -1113142759053898456L;
    private transient Vector corpusListeners;
    protected transient List documentsList;

    public CorpusImpl() {
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    public List getDocumentNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.supportList.size());
        Iterator iterator = this.supportList.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Document)iterator.next()).getName());
        }
        return arrayList;
    }

    public String getDocumentName(int n) {
        return ((Document)this.supportList.get(n)).getName();
    }

    public void unloadDocument(Document document) {
    }

    public boolean isDocumentLoaded(int n) {
        return true;
    }

    protected void clearDocList() {
        if (this.supportList == null) {
            return;
        }
        this.supportList.clear();
    }

    public int size() {
        return this.supportList.size();
    }

    public boolean isEmpty() {
        return this.supportList.isEmpty();
    }

    public boolean contains(Object object) {
        return this.supportList.contains(object);
    }

    public Iterator iterator() {
        return this.supportList.iterator();
    }

    public Object[] toArray() {
        return this.supportList.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.supportList.toArray(objectArray);
    }

    public boolean add(Object object) {
        return this.supportList.add(object);
    }

    public boolean remove(Object object) {
        return this.supportList.remove(object);
    }

    public boolean containsAll(Collection collection) {
        return this.supportList.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        return this.supportList.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.supportList.addAll(n, collection);
    }

    public boolean removeAll(Collection collection) {
        return this.supportList.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.supportList.retainAll(collection);
    }

    public void clear() {
        this.supportList.clear();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CorpusImpl)) {
            return false;
        }
        return ((Object)this.supportList).equals(object);
    }

    public int hashCode() {
        return ((Object)this.supportList).hashCode();
    }

    public Object get(int n) {
        return this.supportList.get(n);
    }

    public Object set(int n, Object object) {
        return this.supportList.set(n, object);
    }

    public void add(int n, Object object) {
        this.supportList.add(n, object);
    }

    public Object remove(int n) {
        return this.supportList.remove(n);
    }

    public int indexOf(Object object) {
        return this.supportList.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.supportList.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.supportList.listIterator(n);
    }

    public List subList(int n, int n2) {
        return this.supportList.subList(n, n2);
    }

    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
    }

    public Resource init() {
        if (this.documentsList != null && !this.documentsList.isEmpty()) {
            this.addAll((Collection)this.documentsList);
        }
        return this;
    }

    public static void populate(Corpus corpus, URL uRL, FileFilter fileFilter, String string, boolean bl) throws IOException {
        if (!uRL.getProtocol().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("The URL provided is not of type \"file:\"!");
        }
        File file = new File(uRL.getPath());
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory!");
        }
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    if (!bl) continue;
                    CorpusImpl.populate(corpus, file2.toURI().toURL(), fileFilter, string, bl);
                    continue;
                }
                StatusListener statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
                if (statusListener != null) {
                    statusListener.statusChanged("Reading: " + file2.getName());
                }
                String string2 = file2.getName() + "_" + Gate.genSym();
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("sourceUrl", file2.toURI().toURL());
                if (string != null) {
                    featureMap.put("encoding", string);
                }
                try {
                    Document document = (Document)Factory.createResource(DocumentImpl.class.getName(), featureMap, null, string2);
                    corpus.add(document);
                    if (corpus.getLRPersistenceId() != null) {
                        corpus.unloadDocument(document);
                        Factory.deleteResource(document);
                    }
                }
                catch (Throwable throwable) {
                    String string3 = Strings.getNl();
                    Err.prln("WARNING: Corpus.populate could not instantiate document" + string3 + "  Document name was: " + string2 + string3 + "  Exception was: " + throwable + string3 + string3);
                    throwable.printStackTrace();
                }
                if (statusListener == null) continue;
                statusListener.statusChanged(file2.getName() + " read");
            }
        }
    }

    public void populate(URL uRL, FileFilter fileFilter, String string, boolean bl) throws IOException, ResourceInstantiationException {
        CorpusImpl.populate(this, uRL, fileFilter, string, bl);
    }

    public synchronized void removeCorpusListener(CorpusListener corpusListener) {
        if (this.corpusListeners != null && this.corpusListeners.contains(corpusListener)) {
            Vector vector = (Vector)this.corpusListeners.clone();
            vector.removeElement(corpusListener);
            this.corpusListeners = vector;
        }
    }

    public synchronized void addCorpusListener(CorpusListener corpusListener) {
        Vector vector;
        Vector vector2 = vector = this.corpusListeners == null ? new Vector(2) : (Vector)this.corpusListeners.clone();
        if (!vector.contains(corpusListener)) {
            vector.addElement(corpusListener);
            this.corpusListeners = vector;
        }
    }

    protected void fireDocumentAdded(CorpusEvent corpusEvent) {
        if (this.corpusListeners != null) {
            Vector vector = this.corpusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CorpusListener)vector.elementAt(i)).documentAdded(corpusEvent);
            }
        }
    }

    protected void fireDocumentRemoved(CorpusEvent corpusEvent) {
        if (this.corpusListeners != null) {
            Vector vector = this.corpusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CorpusListener)vector.elementAt(i)).documentRemoved(corpusEvent);
            }
        }
    }

    public void setDocumentsList(List list) {
        this.documentsList = list;
    }

    public List getDocumentsList() {
        return this.documentsList;
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        Resource resource = creoleEvent.getResource();
        if (resource instanceof Document) {
            while (this.contains(resource)) {
                this.remove(resource);
            }
        }
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    protected class VerboseList
    extends AbstractList
    implements Serializable {
        ArrayList data = new ArrayList();

        VerboseList() {
        }

        public Object get(int n) {
            return this.data.get(n);
        }

        public int size() {
            return this.data.size();
        }

        public Object set(int n, Object object) {
            if (object instanceof Document) {
                Document document = (Document)this.data.set(n, object);
                Document document2 = (Document)object;
                CorpusImpl.this.fireDocumentRemoved(new CorpusEvent(CorpusImpl.this, document, n, 402));
                CorpusImpl.this.fireDocumentAdded(new CorpusEvent(CorpusImpl.this, document2, n, 401));
                return document;
            }
            throw new UnsupportedOperationException(this.getClass().getName() + " only accepts gate.Document values as members!\n" + object.getClass().getName() + " is not a gate.Document");
        }

        public void add(int n, Object object) {
            if (!(object instanceof Document)) {
                throw new UnsupportedOperationException(this.getClass().getName() + " only accepts gate.Document values as members!\n" + object.getClass().getName() + " is not a gate.Document");
            }
            this.data.add(n, object);
            CorpusImpl.this.fireDocumentAdded(new CorpusEvent(CorpusImpl.this, (Document)object, n, 401));
        }

        public Object remove(int n) {
            Document document = (Document)this.data.remove(n);
            CorpusImpl.this.fireDocumentRemoved(new CorpusEvent(CorpusImpl.this, document, n, 402));
            return document;
        }
    }
}

