/*
 * Decompiled with CFR 0.152.
 */
package gate.config;

import gate.CreoleRegister;
import gate.Gate;
import gate.config.ConfigDataProcessor;
import gate.util.Files;
import gate.util.GateException;
import gate.util.OptionsMap;
import gate.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestConfig
extends TestCase {
    private static final boolean DEBUG = false;

    public TestConfig(String string) throws GateException {
        super(string);
    }

    public void setUp() throws Exception {
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        creoleRegister.registerDirectories(Gate.getUrl("tests"));
    }

    public void tearDown() throws Exception {
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        creoleRegister.clear();
        Gate.init();
    }

    private void readConfig(URL uRL) throws Exception {
        ConfigDataProcessor configDataProcessor = new ConfigDataProcessor();
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw new GateException("Couldn't open config data test file: " + uRL + " " + iOException);
        }
        configDataProcessor.parseConfigFile(inputStream, uRL);
    }

    public void testConfigReading() throws Exception {
        System.out.println("Reading GATE config from : " + Gate.getUrl("tests/gate.xml"));
        this.readConfig(Gate.getUrl("tests/gate.xml"));
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        Set set = creoleRegister.getDirectories();
        TestConfig.assertTrue((String)"CREOLE register doesn't contain URL from test gate.xml", (set != null && !set.isEmpty() && set.contains(new URL("http://gate.ac.uk/tests/")) ? 1 : 0) != 0);
        String string = "FULLSIZE";
        String string2 = "yes";
        OptionsMap optionsMap = Gate.getUserConfig();
        TestConfig.assertNotNull((String)"no gate config map", (Object)optionsMap);
        String string3 = (String)optionsMap.get(string);
        TestConfig.assertNotNull((String)"no full size value", (Object)string3);
        TestConfig.assertEquals((String)"incorrect config data from tests/gate.xml", (String)string2, (String)string3);
        optionsMap.clear();
    }

    public void testConfigUpdating() throws Exception {
        String string;
        OptionsMap optionsMap = Gate.getUserConfig();
        optionsMap.clear();
        File file = Gate.getUserConfigFile();
        String string2 = file.getAbsolutePath();
        File file2 = null;
        if (file.exists()) {
            string = file.getParent();
            if (string == null) {
                string = "";
            }
            file2 = new File(string + Strings.getFileSep() + "__saved_gate.xml__for_TestConfig__" + System.currentTimeMillis());
            boolean bl = file.renameTo(file2);
            TestConfig.assertTrue((String)"rename failed", (boolean)bl);
        }
        TestConfig.assertTrue((String)"user config file still there", (!file.exists() ? 1 : 0) != 0);
        Gate.writeUserConfig();
        string = Files.getString(new File(string2));
        String string3 = Gate.getEmptyConfigFile();
        optionsMap.put("A", "1");
        optionsMap.put("B", "2");
        Gate.writeUserConfig();
        optionsMap.clear();
        this.readConfig(file.toURI().toURL());
        file.delete();
        if (file2 != null) {
            file2.renameTo(file);
        }
    }

    public void testSessionStateFileNaming() throws Exception {
        String string = Strings.getFileSep();
        if (Gate.runningOnUnix()) {
            TestConfig.assertTrue((boolean)string.equals("/"));
            TestConfig.assertTrue((boolean)Gate.getUserSessionFile().toString().endsWith(".gate.session"));
        } else {
            TestConfig.assertTrue((!string.equals("/") ? 1 : 0) != 0);
            TestConfig.assertTrue((!Gate.getUserSessionFile().toString().endsWith(".gate.session") ? 1 : 0) != 0);
        }
    }

    public void testConfigFileNaming() throws Exception {
        String string = Strings.getFileSep();
        if (Gate.runningOnUnix()) {
            TestConfig.assertTrue((boolean)string.equals("/"));
            TestConfig.assertTrue((boolean)Gate.getDefaultUserConfigFileName().endsWith(".gate.xml"));
        } else {
            TestConfig.assertTrue((!string.equals("/") ? 1 : 0) != 0);
            TestConfig.assertTrue((!Gate.getDefaultUserConfigFileName().endsWith(".gate.xml") ? 1 : 0) != 0);
        }
    }

    public static Test suite() {
        return new TestSuite(TestConfig.class);
    }
}

