/*
 * Decompiled with CFR 0.152.
 */
package gate.config;

import gate.CreoleRegister;
import gate.DataStoreRegister;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.config.SystemData;
import gate.creole.ResourceInstantiationException;
import gate.util.GateSaxException;
import gate.util.Strings;
import gate.xml.SimpleErrorHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigXmlHandler
extends DefaultHandler {
    private Stack contentStack = new Stack();
    private SystemData systemData;
    private Attributes currentAttributes;
    private FeatureMap currentAttributeMap;
    private static final boolean DEBUG = false;
    private URL sourceUrl;
    private SimpleErrorHandler _seh = new SimpleErrorHandler();
    private StringBuffer contentBuffer = new StringBuffer("");
    private boolean readCharacterStatus = false;
    private CreoleRegister register = Gate.getCreoleRegister();

    public ConfigXmlHandler(URL uRL) {
        this.sourceUrl = uRL;
    }

    public void startDocument() throws GateSaxException {
    }

    public void endDocument() throws GateSaxException {
        if (!this.contentStack.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer("document ended but element stack not empty:");
            while (!this.contentStack.isEmpty()) {
                stringBuffer.append(Strings.getNl() + "  " + (String)this.contentStack.pop());
            }
            throw new GateSaxException(stringBuffer.toString());
        }
    }

    private String attributes2String(Attributes attributes) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (attributes == null) {
            return stringBuffer.toString();
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i);
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        this.currentAttributes = attributes;
        this.currentAttributeMap = this.attributeListToParameterList();
        if (string3.toUpperCase().equals("SYSTEM")) {
            this.systemData = new SystemData();
            int n = this.currentAttributes.getLength();
            for (int i = 0; i < n; ++i) {
                if (!this.currentAttributes.getQName(i).toUpperCase().equals("NAME")) continue;
                this.systemData.systemName = this.currentAttributes.getValue(i);
            }
        } else if (string3.toUpperCase().equals("DBCONFIG")) {
            DataStoreRegister.addConfig(this.currentAttributeMap);
        } else if (string3.toUpperCase().equals(Gate.getUserConfigElement())) {
            Gate.getUserConfig().putAll(this.currentAttributeMap);
        }
    }

    private void checkStack(String string, String string2) throws GateSaxException {
        if (this.contentStack.isEmpty()) {
            throw new GateSaxException(string + " called for element " + string2 + " with empty stack");
        }
    }

    public void endElement(String string, String string2, String string3) throws GateSaxException, SAXException {
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        if (!string3.toUpperCase().equals("GATE")) {
            if (string3.toUpperCase().equals("CREOLE-DIRECTORY")) {
                String string4 = (String)this.contentStack.pop();
                try {
                    this.register.addDirectory(new URL(string4));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new GateSaxException("bad URL " + string4 + malformedURLException);
                }
            } else if (string3.toUpperCase().equals("SYSTEM")) {
                this.systemData.createSystem();
            } else if (string3.toUpperCase().equals("CONTROLLER")) {
                this.systemData.controllerTypeName = (String)this.contentStack.pop();
            } else if (string3.toUpperCase().equals("LR")) {
                this.createResource((String)this.contentStack.pop(), this.systemData.lrList);
            } else if (string3.toUpperCase().equals("PR")) {
                this.createResource((String)this.contentStack.pop(), this.systemData.prList);
            } else if (!string3.toUpperCase().equals("DBCONFIG") && !string3.toUpperCase().equals("GATECONFIG")) {
                throw new GateSaxException("Unknown config data element: " + string3 + "; encountered while parsing " + this.sourceUrl);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.readCharacterStatus) {
            this.contentBuffer = new StringBuffer(new String(cArray, n, n2));
        } else {
            this.contentBuffer.append(new String(cArray, n, n2));
        }
        this.readCharacterStatus = true;
    }

    public void charactersAction(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2).trim();
        if (string.length() == 0) {
            return;
        }
        this.contentStack.push(string);
    }

    protected void createResource(String string, List list) throws GateSaxException {
        try {
            list.add(Factory.createResource(string, this.currentAttributeMap));
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new GateSaxException("Couldn't create resource for SYSTEM: " + this.systemData.systemName + "; problem was: " + Strings.getNl() + resourceInstantiationException);
        }
    }

    protected FeatureMap attributeListToParameterList() {
        FeatureMap featureMap = Factory.newFeatureMap();
        int n = this.currentAttributes.getLength();
        for (int i = 0; i < n; ++i) {
            featureMap.put(this.currentAttributes.getQName(i), this.currentAttributes.getValue(i));
        }
        return featureMap;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this._seh.error(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this._seh.fatalError(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this._seh.warning(sAXParseException);
    }
}

