/*
 * Decompiled with CFR 0.152.
 */
package gate.config;

import gate.config.ConfigXmlHandler;
import gate.util.GateException;
import gate.util.Out;
import gate.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigDataProcessor {
    protected static final boolean DEBUG = false;
    protected SAXParser parser = null;

    public ConfigDataProcessor() throws GateException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(true);
            this.parser = sAXParserFactory.newSAXParser();
        }
        catch (SAXException sAXException) {
            throw new GateException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new GateException(parserConfigurationException);
        }
    }

    public void parseConfigFile(InputStream inputStream, URL uRL) throws GateException {
        String string = Strings.getNl();
        String string2 = null;
        try {
            ConfigXmlHandler configXmlHandler = new ConfigXmlHandler(uRL);
            this.parser.parse(inputStream, (DefaultHandler)configXmlHandler);
        }
        catch (IOException iOException) {
            Out.prln("conf file:" + string + string2 + string);
            throw new GateException("Config data error 1 on " + uRL + ": " + string + iOException);
        }
        catch (SAXException sAXException) {
            Out.prln("conf file:" + string + string2 + string);
            throw new GateException("Config data error 2 on " + uRL + ": " + string + sAXException);
        }
    }
}

