/*
 * Decompiled with CFR 0.152.
 */
package gate.annotation;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.annotation.DatabaseAnnotationSetImpl;
import gate.annotation.TestAnnotation;
import gate.corpora.TestDocument;
import gate.util.Out;
import gate.util.SimpleFeatureMapImpl;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDatabaseAnnotationSet
extends TestCase {
    private static final boolean DEBUG = false;
    protected Document doc1;
    protected AnnotationSet basicAS;
    protected FeatureMap emptyFeatureMap;

    public TestDatabaseAnnotationSet(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        String string = TestDocument.getTestServerName();
        TestDatabaseAnnotationSet.assertNotNull((Object)string);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        featureMap.put("markupAware", "false");
        this.doc1 = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        this.emptyFeatureMap = new SimpleFeatureMapImpl();
        this.basicAS = new DatabaseAnnotationSetImpl(this.doc1);
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        this.basicAS.get("T");
        this.basicAS.get(new Long(0L));
        this.basicAS.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(10L), new Long(20L), "T2", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(10L), new Long(20L), "T3", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl.put("pos", "NN");
        simpleFeatureMapImpl.put("author", "hamish");
        simpleFeatureMapImpl.put("version", new Integer(1));
        this.basicAS.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(15L), new Long(40L), "T1", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(15L), new Long(40L), "T3", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(15L), new Long(40L), "T1", (FeatureMap)simpleFeatureMapImpl);
        simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl.put("pos", "JJ");
        simpleFeatureMapImpl.put("author", "the devil himself");
        simpleFeatureMapImpl.put("version", new Long(44L));
        simpleFeatureMapImpl.put("created", "monday");
        this.basicAS.add(new Long(15L), new Long(40L), "T3", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(15L), new Long(40L), "T1", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(15L), new Long(40L), "T1", (FeatureMap)simpleFeatureMapImpl);
    }

    public void testRemove() {
        AnnotationSet annotationSet = this.basicAS.get("T1");
        TestDatabaseAnnotationSet.assertEquals((int)7, (int)annotationSet.size());
        annotationSet = this.basicAS.get(new Long(9L));
        TestDatabaseAnnotationSet.assertEquals((int)5, (int)annotationSet.size());
        this.basicAS.remove(this.basicAS.get(new Integer(0)));
        TestDatabaseAnnotationSet.assertEquals((int)10, (int)this.basicAS.size());
        TestDatabaseAnnotationSet.assertEquals((int)10, (int)((DatabaseAnnotationSetImpl)this.basicAS).annotsById.size());
        annotationSet = this.basicAS.get("T1");
        TestDatabaseAnnotationSet.assertEquals((int)6, (int)annotationSet.size());
        annotationSet = this.basicAS.get(new Long(9L));
        TestDatabaseAnnotationSet.assertEquals((int)4, (int)annotationSet.size());
        TestDatabaseAnnotationSet.assertEquals(null, (Object)this.basicAS.get(new Integer(0)));
        this.basicAS.remove(this.basicAS.get(new Integer(8)));
        TestDatabaseAnnotationSet.assertEquals((int)9, (int)this.basicAS.size());
        this.basicAS.removeAll(this.basicAS);
        TestDatabaseAnnotationSet.assertEquals(null, (Object)this.basicAS.get());
        TestDatabaseAnnotationSet.assertEquals(null, (Object)this.basicAS.get("T1"));
        TestDatabaseAnnotationSet.assertEquals(null, (Object)this.basicAS.get(new Integer(0)));
    }

    public void testRemoveInexistant() throws Exception {
        this.basicAS.add(new Long(0L), new Long(10L), "Foo", this.emptyFeatureMap);
        Annotation annotation = this.basicAS.get("Foo").iterator().next();
        this.basicAS.remove(annotation);
        this.basicAS.remove(annotation);
    }

    public void testIteratorRemove() {
        AnnotationSet annotationSet = this.basicAS.get("T1");
        TestDatabaseAnnotationSet.assertEquals((int)7, (int)annotationSet.size());
        annotationSet = this.basicAS.get(new Long(9L));
        TestDatabaseAnnotationSet.assertEquals((int)5, (int)annotationSet.size());
        Iterator<Annotation> iterator = this.basicAS.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        iterator.remove();
        TestDatabaseAnnotationSet.assertEquals((int)10, (int)this.basicAS.size());
        TestDatabaseAnnotationSet.assertEquals((int)10, (int)((DatabaseAnnotationSetImpl)this.basicAS).annotsById.size());
        annotationSet = this.basicAS.get("T1");
        TestDatabaseAnnotationSet.assertEquals((int)6, (int)annotationSet.size());
        annotationSet = this.basicAS.get(new Long(9L));
        TestDatabaseAnnotationSet.assertEquals((int)4, (int)annotationSet.size());
        TestDatabaseAnnotationSet.assertEquals(null, (Object)this.basicAS.get(new Integer(0)));
        this.basicAS.remove(this.basicAS.get(new Integer(8)));
    }

    public void testIterator() {
        Serializable serializable;
        Iterator<Annotation> iterator = this.basicAS.iterator();
        Annotation[] annotationArray = new Annotation[this.basicAS.size()];
        int n = 0;
        while (iterator.hasNext()) {
            serializable = iterator.next();
            annotationArray[n++] = serializable;
            TestDatabaseAnnotationSet.assertTrue((boolean)this.basicAS.contains(serializable));
            iterator.remove();
            TestDatabaseAnnotationSet.assertTrue((!this.basicAS.contains(serializable) ? 1 : 0) != 0);
        }
        n = 0;
        while (n < annotationArray.length) {
            this.basicAS.add(annotationArray[n++]);
            TestDatabaseAnnotationSet.assertEquals((int)n, (int)this.basicAS.size());
        }
        serializable = this.basicAS.get("T1");
        TestDatabaseAnnotationSet.assertEquals((int)7, (int)serializable.size());
        serializable = this.basicAS.get(new Long(9L));
        TestDatabaseAnnotationSet.assertEquals((int)5, (int)serializable.size());
        DatabaseAnnotationSetImpl databaseAnnotationSetImpl = new DatabaseAnnotationSetImpl(this.doc1, "test");
        databaseAnnotationSetImpl.add(this.basicAS.get(new Integer(1)));
        databaseAnnotationSetImpl.add(this.basicAS.get(new Integer(4)));
        databaseAnnotationSetImpl.add(this.basicAS.get(new Integer(5)));
        databaseAnnotationSetImpl.add(this.basicAS.get(new Integer(0)));
        Annotation annotation = databaseAnnotationSetImpl.get(new Integer(0));
        FeatureMap featureMap = annotation.getFeatures();
        featureMap.put("test", "test value");
        Annotation annotation2 = databaseAnnotationSetImpl.get(new Integer(4));
        FeatureMap featureMap2 = annotation2.getFeatures();
        featureMap2.remove("pos");
        FeatureMap featureMap3 = Factory.newFeatureMap();
        featureMap3.put("my test", "my value");
        Annotation annotation3 = databaseAnnotationSetImpl.get(new Integer(5));
        annotation3.setFeatures(featureMap3);
        databaseAnnotationSetImpl.remove(this.basicAS.get(new Integer(0)));
        DatabaseAnnotationSetImpl databaseAnnotationSetImpl2 = new DatabaseAnnotationSetImpl(this.basicAS);
        annotation = databaseAnnotationSetImpl2.get(new Integer(0));
        featureMap = annotation.getFeatures();
        featureMap.put("test", "test value");
        annotation2 = databaseAnnotationSetImpl2.get(new Integer(4));
        featureMap2 = annotation2.getFeatures();
        featureMap2.remove("pos");
        featureMap3 = Factory.newFeatureMap();
        featureMap3.put("my test", "my value");
        annotation3 = databaseAnnotationSetImpl2.get(new Integer(5));
        annotation3.setFeatures(featureMap3);
    }

    public void testSetMethods() throws Exception {
        this.basicAS.clear();
        this.setUp();
        Annotation annotation = this.basicAS.get(new Integer(6));
        TestDatabaseAnnotationSet.assertTrue((boolean)this.basicAS.contains(annotation));
        Annotation[] annotationArray = this.basicAS.toArray(new Annotation[0]);
        Object[] objectArray = this.basicAS.toArray();
        TestDatabaseAnnotationSet.assertEquals((int)11, (int)annotationArray.length);
        TestDatabaseAnnotationSet.assertEquals((int)11, (int)objectArray.length);
        TreeSet<Annotation> treeSet = new TreeSet<Annotation>(this.basicAS);
        annotationArray = treeSet.toArray(new Annotation[0]);
        for (int i = 0; i < 11; ++i) {
            TestDatabaseAnnotationSet.assertTrue((boolean)annotationArray[i].getId().equals(new Integer(i)));
        }
        Annotation annotation2 = this.basicAS.get(new Integer(3));
        Annotation annotation3 = this.basicAS.get(new Integer(4));
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        hashSet.add(annotation2);
        hashSet.add(annotation3);
        TestDatabaseAnnotationSet.assertTrue((boolean)this.basicAS.contains(annotation2));
        TestDatabaseAnnotationSet.assertTrue((boolean)this.basicAS.containsAll(hashSet));
        this.basicAS.removeAll(hashSet);
        TestDatabaseAnnotationSet.assertEquals((int)9, (int)this.basicAS.size());
        TestDatabaseAnnotationSet.assertTrue((!this.basicAS.contains(annotation2) ? 1 : 0) != 0);
        TestDatabaseAnnotationSet.assertTrue((!this.basicAS.containsAll(hashSet) ? 1 : 0) != 0);
        this.basicAS.addAll(hashSet);
        TestDatabaseAnnotationSet.assertTrue((boolean)this.basicAS.contains(annotation3));
        TestDatabaseAnnotationSet.assertTrue((boolean)this.basicAS.containsAll(hashSet));
        TestDatabaseAnnotationSet.assertTrue((boolean)this.basicAS.retainAll(hashSet));
        TestDatabaseAnnotationSet.assertTrue((boolean)this.basicAS.equals(hashSet));
        this.basicAS.clear();
        TestDatabaseAnnotationSet.assertTrue((boolean)this.basicAS.isEmpty());
    }

    public void testAnnotationSet() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        featureMap.put("markupAware", "false");
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        DatabaseAnnotationSetImpl databaseAnnotationSetImpl = new DatabaseAnnotationSetImpl(document);
        TestDatabaseAnnotationSet.assertEquals((int)databaseAnnotationSetImpl.size(), (int)0);
        FeatureMap featureMap2 = Factory.newFeatureMap();
        featureMap2.put("test", "my-value");
        FeatureMap featureMap3 = Factory.newFeatureMap();
        featureMap3.put("test", "my-value-different");
        FeatureMap featureMap4 = Factory.newFeatureMap();
        featureMap4.put("another test", "different my-value");
        Integer n = databaseAnnotationSetImpl.add(new Long(0L), new Long(10L), "Token", featureMap2);
        TestDatabaseAnnotationSet.assertEquals((int)n, (int)0);
        n = databaseAnnotationSetImpl.add(new Long(11L), new Long(12L), "Token", featureMap3);
        TestDatabaseAnnotationSet.assertEquals((int)n, (int)1);
        TestDatabaseAnnotationSet.assertEquals((int)databaseAnnotationSetImpl.size(), (int)2);
        TestDatabaseAnnotationSet.assertTrue((!databaseAnnotationSetImpl.isEmpty() ? 1 : 0) != 0);
        n = databaseAnnotationSetImpl.add(new Long(15L), new Long(22L), "Syntax", featureMap2);
        Annotation annotation2 = databaseAnnotationSetImpl.get(new Integer(1));
        databaseAnnotationSetImpl.remove(annotation2);
        TestDatabaseAnnotationSet.assertEquals((int)databaseAnnotationSetImpl.size(), (int)2);
        databaseAnnotationSetImpl.add(annotation2);
        TestDatabaseAnnotationSet.assertEquals((int)databaseAnnotationSetImpl.size(), (int)3);
        for (Annotation annotation2 : databaseAnnotationSetImpl) {
            if (annotation2.getId() != 2) {
                TestDatabaseAnnotationSet.assertEquals((String)annotation2.getType(), (String)"Token");
            }
            TestDatabaseAnnotationSet.assertEquals((int)annotation2.getFeatures().size(), (int)1);
        }
        n = databaseAnnotationSetImpl.add(new Long(0L), new Long(12L), "Syntax", featureMap4);
        TestDatabaseAnnotationSet.assertEquals((int)n, (int)3);
        n = databaseAnnotationSetImpl.add(new Long(14L), new Long(22L), "Syntax", featureMap2);
        TestDatabaseAnnotationSet.assertEquals((int)n, (int)4);
        TestDatabaseAnnotationSet.assertEquals((int)databaseAnnotationSetImpl.size(), (int)5);
        n = databaseAnnotationSetImpl.add(new Long(15L), new Long(22L), "Syntax", (FeatureMap)new SimpleFeatureMapImpl());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("test");
        AnnotationSet annotationSet = databaseAnnotationSetImpl.get("Token", hashSet);
        TestDatabaseAnnotationSet.assertEquals((int)annotationSet.size(), (int)2);
        annotationSet = databaseAnnotationSetImpl.get(null, hashSet);
        TestDatabaseAnnotationSet.assertEquals((int)annotationSet.size(), (int)4);
        databaseAnnotationSetImpl.indexByType();
        AnnotationSet annotationSet2 = databaseAnnotationSetImpl.get("Token");
        TestDatabaseAnnotationSet.assertEquals((int)annotationSet2.size(), (int)2);
        AnnotationSet annotationSet3 = databaseAnnotationSetImpl.get(new Long(15L));
        if (annotationSet3 == null) {
            TestDatabaseAnnotationSet.fail((String)"no annots found after offset 10");
        }
        TestDatabaseAnnotationSet.assertEquals((int)annotationSet3.size(), (int)2);
    }

    public static Test suite() {
        return new TestSuite(TestAnnotation.class);
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
            TestDatabaseAnnotationSet testDatabaseAnnotationSet = new TestDatabaseAnnotationSet("");
            Out.prln("test set up");
            testDatabaseAnnotationSet.setUp();
            Out.prln("testIterator");
            testDatabaseAnnotationSet.testIterator();
            Out.prln("testAnnotationSet");
            testDatabaseAnnotationSet.testAnnotationSet();
            Out.prln("testRemove");
            testDatabaseAnnotationSet.testRemove();
            Out.prln("testInexistant");
            testDatabaseAnnotationSet.testRemoveInexistant();
            Out.prln("testSetMethods");
            testDatabaseAnnotationSet.testSetMethods();
            testDatabaseAnnotationSet.tearDown();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

