/*
 * Decompiled with CFR 0.152.
 */
package gate.annotation;

import gate.Annotation;
import gate.AnnotationSet;
import gate.DataStore;
import gate.Document;
import gate.annotation.AnnotationSetImpl;
import gate.annotation.EventAwareAnnotationSet;
import gate.corpora.DatabaseDocumentImpl;
import gate.corpora.DocumentImpl;
import gate.event.AnnotationEvent;
import gate.event.AnnotationListener;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseAnnotationSetImpl
extends AnnotationSetImpl
implements DatastoreListener,
EventAwareAnnotationSet,
AnnotationListener {
    protected HashSet<Annotation> addedAnnotations = new HashSet();
    protected HashSet<Annotation> removedAnnotations = new HashSet();
    protected HashSet<Annotation> updatedAnnotations = new HashSet();
    private boolean validating = false;

    public void assertValid() {
        if (this.validating) {
            return;
        }
        this.validating = true;
        Assert.assertNotNull((Object)this.doc);
        this.validating = false;
    }

    public DatabaseAnnotationSetImpl(Document document) {
        super(document);
        Assert.assertTrue((boolean)(document instanceof DatabaseDocumentImpl));
        document.getDataStore().addDatastoreListener(this);
    }

    public DatabaseAnnotationSetImpl(Document document, String string) {
        super(document, string);
        Assert.assertTrue((boolean)(document instanceof DatabaseDocumentImpl));
        document.getDataStore().addDatastoreListener(this);
    }

    public DatabaseAnnotationSetImpl(Document document, AnnotationSet annotationSet) {
        this(annotationSet);
        this.doc = (DocumentImpl)document;
    }

    public DatabaseAnnotationSetImpl(Document document, String string, AnnotationSet annotationSet) {
        this(document, annotationSet);
        this.name = string;
        document.getDataStore().addDatastoreListener(this);
    }

    public DatabaseAnnotationSetImpl(AnnotationSet annotationSet) throws ClassCastException {
        super(annotationSet);
        AnnotationSet annotationSet2 = annotationSet;
        this.name = annotationSet2.getName();
        Iterator<Annotation> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().addAnnotationListener(this);
        }
        Document document = annotationSet2.getDocument();
        document.getDataStore().addDatastoreListener(this);
    }

    @Override
    public String toString() {
        return super.toString() + "added annots: " + this.addedAnnotations + "removed annots: " + this.removedAnnotations + "updated annots: " + this.updatedAnnotations;
    }

    @Override
    public void resourceAdopted(DatastoreEvent datastoreEvent) {
        Assert.assertNotNull((Object)datastoreEvent);
        Assert.assertNotNull((Object)datastoreEvent.getResourceID());
        if (datastoreEvent.getResourceID().equals(this.doc.getLRPersistenceId())) {
            this.clearChangeLists();
        }
    }

    @Override
    public void resourceDeleted(DatastoreEvent datastoreEvent) {
        DataStore dataStore;
        Assert.assertNotNull((Object)datastoreEvent);
        Assert.assertNotNull((Object)datastoreEvent.getResourceID());
        if (datastoreEvent.getResourceID().equals(this.doc.getLRPersistenceId()) && (dataStore = this.doc.getDataStore()) != null) {
            dataStore.removeDatastoreListener(this);
        }
    }

    @Override
    public void resourceWritten(DatastoreEvent datastoreEvent) {
        Assert.assertNotNull((Object)datastoreEvent);
        Assert.assertNotNull((Object)datastoreEvent.getResourceID());
        if (datastoreEvent.getResourceID().equals(this.doc.getLRPersistenceId())) {
            this.clearChangeLists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearChangeLists() {
        DatabaseAnnotationSetImpl databaseAnnotationSetImpl = this;
        synchronized (databaseAnnotationSetImpl) {
            this.addedAnnotations.clear();
            this.updatedAnnotations.clear();
            this.removedAnnotations.clear();
        }
    }

    @Override
    public Collection<Annotation> getAddedAnnotations() {
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        hashSet.addAll(this.addedAnnotations);
        return hashSet;
    }

    @Override
    public Collection<Annotation> getChangedAnnotations() {
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        hashSet.addAll(this.updatedAnnotations);
        return hashSet;
    }

    @Override
    public Collection<Annotation> getRemovedAnnotations() {
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        hashSet.addAll(this.removedAnnotations);
        return hashSet;
    }

    @Override
    public void annotationUpdated(AnnotationEvent annotationEvent) {
        Annotation annotation = (Annotation)annotationEvent.getSource();
        if (!this.addedAnnotations.contains(annotation)) {
            this.updatedAnnotations.add(annotation);
        }
        Assert.assertTrue((false == this.removedAnnotations.contains(annotation) ? 1 : 0) != 0);
    }

    @Override
    public boolean add(Annotation annotation) throws ClassCastException {
        boolean bl;
        if (this.removedAnnotations.contains(annotation)) {
            this.removedAnnotations.remove(annotation);
        }
        if (bl = super.add(annotation)) {
            annotation.addAnnotationListener(this);
            this.addedAnnotations.add(annotation);
        }
        return bl;
    }

    @Override
    protected void fireAnnotationRemoved(AnnotationSetEvent annotationSetEvent) {
        if (this.annotationSetListeners != null) {
            Vector vector = this.annotationSetListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((AnnotationSetListener)vector.elementAt(i)).annotationRemoved(annotationSetEvent);
            }
        }
    }

    @Override
    public boolean remove(Object object) throws ClassCastException {
        boolean bl = super.remove(object);
        if (bl) {
            Annotation annotation = (Annotation)object;
            annotation.removeAnnotationListener(this);
            if (this.addedAnnotations.contains(annotation)) {
                this.addedAnnotations.remove(annotation);
            } else {
                if (this.updatedAnnotations.contains(annotation)) {
                    this.updatedAnnotations.remove(annotation);
                }
                this.removedAnnotations.add(annotation);
            }
        }
        return bl;
    }

    @Override
    public Iterator<Annotation> iterator() {
        return new DatabaseAnnotationSetIterator();
    }

    class DatabaseAnnotationSetIterator
    extends AnnotationSetImpl.AnnotationSetIterator {
        DatabaseAnnotationSetIterator() {
        }

        public void remove() {
            super.remove();
            Annotation annotation = this.lastNext;
            annotation.removeAnnotationListener(DatabaseAnnotationSetImpl.this);
            if (DatabaseAnnotationSetImpl.this.addedAnnotations.contains(annotation)) {
                DatabaseAnnotationSetImpl.this.addedAnnotations.remove(annotation);
            } else {
                if (DatabaseAnnotationSetImpl.this.updatedAnnotations.contains(annotation)) {
                    DatabaseAnnotationSetImpl.this.updatedAnnotations.remove(annotation);
                }
                DatabaseAnnotationSetImpl.this.removedAnnotations.add(annotation);
            }
        }
    }
}

