/*
 * Decompiled with CFR 0.152.
 */
package gate.annotation;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.DocumentContent;
import gate.FeatureMap;
import gate.Gate;
import gate.Node;
import gate.annotation.AnnotationFactory;
import gate.annotation.AnnotationImpl;
import gate.annotation.DefaultAnnotationFactory;
import gate.annotation.ImmutableAnnotationSetImpl;
import gate.annotation.NodeImpl;
import gate.corpora.DocumentImpl;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.GateEvent;
import gate.event.GateListener;
import gate.util.InvalidOffsetException;
import gate.util.RBTreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSetImpl
extends AbstractSet<Annotation>
implements AnnotationSet {
    static final long serialVersionUID = 1479426765310434166L;
    String name = null;
    DocumentImpl doc;
    protected transient HashMap<Integer, Annotation> annotsById = new HashMap();
    transient RBTreeMap nodesByOffset = null;
    private Annotation[] annotations;
    transient Map<String, AnnotationSet> annotsByType = null;
    transient Map<Integer, Object> annotsByStartNode;
    protected transient Vector annotationSetListeners;
    private transient Vector gateListeners;
    public static AnnotationSet emptyAnnotationSet = new ImmutableAnnotationSetImpl(null, null);
    protected static AnnotationFactory annFactory;

    public AnnotationSetImpl(Document document) {
        this.doc = (DocumentImpl)document;
    }

    public AnnotationSetImpl(Document document, String string) {
        this(document);
        this.name = string;
    }

    public AnnotationSetImpl(AnnotationSet annotationSet) throws ClassCastException {
        this(annotationSet.getDocument(), annotationSet.getName());
        if (annotationSet instanceof AnnotationSetImpl) {
            AnnotationSetImpl annotationSetImpl = (AnnotationSetImpl)annotationSet;
            this.annotsById.putAll(annotationSetImpl.annotsById);
            if (annotationSetImpl.annotsByStartNode != null) {
                this.annotsByStartNode = new HashMap<Integer, Object>(4);
                this.annotsByStartNode.putAll(annotationSetImpl.annotsByStartNode);
            }
            if (annotationSetImpl.annotsByType != null) {
                this.annotsByType = new HashMap<String, AnnotationSet>(4);
                this.annotsByType.putAll(annotationSetImpl.annotsByType);
            }
            if (annotationSetImpl.nodesByOffset != null) {
                this.nodesByOffset = (RBTreeMap)annotationSetImpl.nodesByOffset.clone();
            }
        } else {
            Iterator<Annotation> iterator = annotationSet.iterator();
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    @Override
    public Iterator<Annotation> iterator() {
        return new AnnotationSetIterator();
    }

    @Override
    public boolean remove(Object object) throws ClassCastException {
        Annotation annotation = (Annotation)object;
        boolean bl = this.removeFromIdIndex(annotation);
        if (bl) {
            this.removeFromTypeIndex(annotation);
            this.removeFromOffsetIndex(annotation);
        }
        this.fireAnnotationRemoved(new AnnotationSetEvent(this, 202, this.getDocument(), annotation));
        return bl;
    }

    protected boolean removeFromIdIndex(Annotation annotation) {
        return this.annotsById.remove(annotation.getId()) != null;
    }

    protected void removeFromTypeIndex(Annotation annotation) {
        if (this.annotsByType != null) {
            AnnotationSet annotationSet = this.annotsByType.get(annotation.getType());
            if (annotationSet != null) {
                annotationSet.remove(annotation);
            }
            if (annotationSet.isEmpty()) {
                this.annotsByType.remove(annotation.getType());
            }
        }
    }

    protected void removeFromOffsetIndex(Annotation annotation) {
        if (this.nodesByOffset != null) {
            // empty if block
        }
        if (this.annotsByStartNode != null) {
            Integer n = annotation.getStartNode().getId();
            Object object = this.annotsByStartNode.get(n);
            if (object instanceof Annotation) {
                this.annotsByStartNode.remove(n);
                return;
            }
            Collection collection = (Collection)object;
            collection.remove(annotation);
            if (collection.size() == 1) {
                this.annotsByStartNode.put(n, collection.iterator().next());
            }
        }
    }

    @Override
    public int size() {
        return this.annotsById.size();
    }

    @Override
    public Annotation get(Integer n) {
        return this.annotsById.get(n);
    }

    @Override
    public AnnotationSet get() {
        if (this.annotsById.isEmpty()) {
            return emptyAnnotationSet;
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, this.annotsById.values());
    }

    @Override
    public AnnotationSet get(String string) {
        AnnotationSet annotationSet;
        if (this.annotsByType == null) {
            this.indexByType();
        }
        if ((annotationSet = this.annotsByType.get(string)) == null) {
            return emptyAnnotationSet;
        }
        return annotationSet.get();
    }

    @Override
    public AnnotationSet get(Set<String> set) throws ClassCastException {
        if (this.annotsByType == null) {
            this.indexByType();
        }
        Iterator<String> iterator = set.iterator();
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            AnnotationSet annotationSet = this.annotsByType.get(string);
            if (annotationSet == null) continue;
            Iterator<Annotation> iterator2 = annotationSet.iterator();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
        }
        if (arrayList.isEmpty()) {
            return emptyAnnotationSet;
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, arrayList);
    }

    @Override
    public AnnotationSet get(String string, FeatureMap featureMap) {
        AnnotationSet annotationSet;
        if (this.annotsByType == null) {
            this.indexByType();
        }
        if ((annotationSet = this.get(string)) == null) {
            return null;
        }
        Iterator<Annotation> iterator = annotationSet.iterator();
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            if (!annotation.getFeatures().subsumes(featureMap)) continue;
            arrayList.add(annotation);
        }
        if (arrayList.isEmpty()) {
            return emptyAnnotationSet;
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, arrayList);
    }

    @Override
    public AnnotationSet get(String string, Set set) {
        if (this.annotsByType == null) {
            this.indexByType();
        }
        AnnotationSet annotationSet = null;
        if (string != null && (annotationSet = this.get(string)) == null) {
            return null;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        Iterator<Annotation> iterator = null;
        iterator = string != null ? annotationSet.iterator() : this.annotsById.values().iterator();
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            if (!annotation.getFeatures().keySet().containsAll(set)) continue;
            arrayList.add(annotation);
        }
        if (arrayList.isEmpty()) {
            return emptyAnnotationSet;
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, arrayList);
    }

    @Override
    public AnnotationSet get(Long l) {
        Node node;
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        if ((node = (Node)this.nodesByOffset.getNextOf(l)) == null) {
            return emptyAnnotationSet;
        }
        Collection<Annotation> collection = this.getAnnotsByStartNode(node.getId());
        while (collection == null) {
            if ((node = (Node)this.nodesByOffset.getNextOf(new Long(node.getOffset() + 1L))) == null) {
                return emptyAnnotationSet;
            }
            collection = this.getAnnotsByStartNode(node.getId());
        }
        if (collection == null) {
            return emptyAnnotationSet;
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, collection);
    }

    @Override
    public AnnotationSet get(Long l, Long l2) {
        Collection<Annotation> collection;
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (Node node : this.nodesByOffset.headMap(l).values()) {
            collection = this.getAnnotsByStartNode(node.getId());
            if (collection == null) continue;
            for (Annotation annotation : collection) {
                if (annotation.getEndNode().getOffset().compareTo(l) <= 0) continue;
                arrayList.add(annotation);
            }
        }
        for (Node node : this.nodesByOffset.subMap(l, l2).values()) {
            collection = this.getAnnotsByStartNode(node.getId());
            if (collection == null) continue;
            arrayList.addAll(collection);
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, arrayList);
    }

    public AnnotationSet getStrict(Long l, Long l2) {
        Collection<Annotation> collection;
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        ArrayList<Annotation> arrayList = null;
        Node node = (Node)this.nodesByOffset.get(l);
        if (node != null && (collection = this.getAnnotsByStartNode(node.getId())) != null) {
            for (Annotation annotation : collection) {
                if (annotation.getEndNode().getOffset().compareTo(l2) != 0) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Annotation>();
                }
                arrayList.add(annotation);
            }
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, arrayList);
    }

    @Override
    public AnnotationSet get(String string, Long l, Long l2) {
        Collection<Annotation> collection;
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (Node node : this.nodesByOffset.headMap(l).values()) {
            collection = this.getAnnotsByStartNode(node.getId());
            if (collection == null) continue;
            for (Annotation annotation : collection) {
                if (!annotation.getType().equals(string) || annotation.getEndNode().getOffset().compareTo(l) <= 0) continue;
                arrayList.add(annotation);
            }
        }
        for (Node node : this.nodesByOffset.subMap(l, l2).values()) {
            collection = this.getAnnotsByStartNode(node.getId());
            if (collection == null) continue;
            for (Annotation annotation : collection) {
                if (!annotation.getType().equals(string)) continue;
                arrayList.add(annotation);
            }
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, arrayList);
    }

    @Override
    public AnnotationSet get(String string, FeatureMap featureMap, Long l) {
        AnnotationSet annotationSet = this.get(l);
        if (annotationSet == null) {
            return emptyAnnotationSet;
        }
        return annotationSet.get(string, featureMap);
    }

    @Override
    public AnnotationSet getContained(Long l, Long l2) {
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        ArrayList<Annotation> arrayList = null;
        for (Node node : this.nodesByOffset.subMap(l, l2).values()) {
            Collection<Annotation> collection = this.getAnnotsByStartNode(node.getId());
            if (collection == null) continue;
            for (Annotation annotation : collection) {
                if (annotation.getEndNode().getOffset().compareTo(l2) > 0) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Annotation>();
                }
                arrayList.add(annotation);
            }
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, arrayList);
    }

    @Override
    public Node firstNode() {
        this.indexByStartOffset();
        if (this.nodesByOffset.isEmpty()) {
            return null;
        }
        return (Node)this.nodesByOffset.get(this.nodesByOffset.firstKey());
    }

    @Override
    public Node lastNode() {
        this.indexByStartOffset();
        if (this.nodesByOffset.isEmpty()) {
            return null;
        }
        return (Node)this.nodesByOffset.get(this.nodesByOffset.lastKey());
    }

    @Override
    public Node nextNode(Node node) {
        this.indexByStartOffset();
        return (Node)this.nodesByOffset.getNextOf(new Long(node.getOffset() + 1L));
    }

    public static void setAnnotationFactory(AnnotationFactory annotationFactory) {
        annFactory = annotationFactory;
    }

    @Override
    public Integer add(Node node, Node node2, String string, FeatureMap featureMap) {
        Integer n = this.doc.getNextAnnotationId();
        annFactory.createAnnotationInSet(this, n, node, node2, string, featureMap);
        return n;
    }

    @Override
    public boolean add(Annotation annotation) throws ClassCastException {
        Annotation annotation2 = this.annotsById.put(annotation.getId(), annotation);
        if (this.annotsByType != null) {
            this.addToTypeIndex(annotation);
        }
        if (this.annotsByStartNode != null) {
            this.addToStartOffsetIndex(annotation);
        }
        AnnotationSetEvent annotationSetEvent = new AnnotationSetEvent(this, 201, this.doc, annotation);
        this.fireAnnotationAdded(annotationSetEvent);
        this.fireGateEvent(annotationSetEvent);
        return annotation2 != annotation;
    }

    @Override
    public boolean addAll(Collection<? extends Annotation> collection) {
        Iterator<? extends Annotation> iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            try {
                this.add(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), annotation.getType(), annotation.getFeatures());
                bl = true;
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new IllegalArgumentException(invalidOffsetException.toString());
            }
        }
        return bl;
    }

    protected boolean addAllKeepIDs(Collection<? extends Annotation> collection) {
        Iterator<? extends Annotation> iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            bl |= this.add(annotation);
        }
        return bl;
    }

    private final Node[] getNodes(Long l, Long l2) throws InvalidOffsetException {
        Node node;
        if (!this.doc.isValidOffsetRange(l, l2)) {
            throw new InvalidOffsetException();
        }
        if (this.nodesByOffset == null) {
            this.indexByStartOffset();
        }
        if ((node = (Node)this.nodesByOffset.get(l)) == null) {
            node = new NodeImpl(this.doc.getNextNodeId(), l);
        }
        Node node2 = null;
        if (l.equals(l2)) {
            node2 = node;
            return new Node[]{node, node2};
        }
        node2 = (Node)this.nodesByOffset.get(l2);
        if (node2 == null) {
            node2 = new NodeImpl(this.doc.getNextNodeId(), l2);
        }
        return new Node[]{node, node2};
    }

    @Override
    public Integer add(Long l, Long l2, String string, FeatureMap featureMap) throws InvalidOffsetException {
        Node[] nodeArray = this.getNodes(l, l2);
        return this.add(nodeArray[0], nodeArray[1], string, featureMap);
    }

    @Override
    public void add(Integer n, Long l, Long l2, String string, FeatureMap featureMap) throws InvalidOffsetException {
        Node[] nodeArray = this.getNodes(l, l2);
        annFactory.createAnnotationInSet(this, n, nodeArray[0], nodeArray[1], string, featureMap);
    }

    protected void indexByType() {
        if (this.annotsByType != null) {
            return;
        }
        this.annotsByType = new HashMap<String, AnnotationSet>(4);
        Iterator<Annotation> iterator = this.annotsById.values().iterator();
        while (iterator.hasNext()) {
            this.addToTypeIndex(iterator.next());
        }
    }

    protected void indexByStartOffset() {
        if (this.annotsByStartNode != null) {
            return;
        }
        if (this.nodesByOffset == null) {
            this.nodesByOffset = new RBTreeMap();
        }
        this.annotsByStartNode = new HashMap<Integer, Object>(this.annotsById.size());
        Iterator<Annotation> iterator = this.annotsById.values().iterator();
        while (iterator.hasNext()) {
            this.addToStartOffsetIndex(iterator.next());
        }
    }

    void addToTypeIndex(Annotation annotation) {
        if (this.annotsByType == null) {
            return;
        }
        String string = annotation.getType();
        AnnotationSet annotationSet = this.annotsByType.get(string);
        if (annotationSet == null) {
            annotationSet = new AnnotationSetImpl(this.doc);
            this.annotsByType.put(string, annotationSet);
        }
        annotationSet.add(annotation);
    }

    void addToStartOffsetIndex(Annotation annotation) {
        Node node = annotation.getStartNode();
        Node node2 = annotation.getEndNode();
        Long l = node.getOffset();
        Long l2 = node2.getOffset();
        if (this.nodesByOffset != null) {
            this.nodesByOffset.put(l, node);
            this.nodesByOffset.put(l2, node2);
        }
        if (this.annotsByStartNode == null) {
            return;
        }
        Object object = this.annotsByStartNode.get(node.getId());
        if (object == null) {
            this.annotsByStartNode.put(node.getId(), annotation);
        } else {
            HashSet<Annotation> hashSet = null;
            if (object instanceof Annotation) {
                if (object.equals(annotation)) {
                    return;
                }
                hashSet = new HashSet<Annotation>(3);
                hashSet.add((Annotation)object);
                this.annotsByStartNode.put(node.getId(), hashSet);
            } else {
                hashSet = (HashSet<Annotation>)object;
            }
            hashSet.add(annotation);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void edit(Long l, Long l2, DocumentContent documentContent) {
        long l3;
        this.indexByStartOffset();
        if (l2.compareTo(l) > 0) {
            ArrayList arrayList = new ArrayList(this.nodesByOffset.subMap(l, new Long(l2 + 1L)).values());
            NodeImpl nodeImpl = null;
            if (!arrayList.isEmpty()) {
                void var11_25;
                Collection<Annotation> collection;
                nodeImpl = (NodeImpl)arrayList.get(0);
                ArrayList arrayList2 = new ArrayList();
                ArrayList<Comparable> arrayList3 = new ArrayList<Comparable>();
                ArrayList arrayList4 = new ArrayList(this.nodesByOffset.subMap(new Long(0L), new Long(l2 + 1L)).values());
                for (Node node : arrayList4) {
                    Collection<Annotation> object2 = this.getAnnotsByStartNode(node.getId());
                    if (object2 == null) continue;
                    for (Comparable comparable : object2) {
                        l3 = comparable.getEndNode().getOffset();
                        if (l3 < l || l3 > l2) continue;
                        arrayList3.add(comparable);
                    }
                }
                for (int i = 1; i < arrayList.size(); ++i) {
                    Node arrayList5 = (Node)arrayList.get(i);
                    collection = this.getAnnotsByStartNode(arrayList5.getId());
                    if (collection == null) continue;
                    arrayList2.addAll(collection);
                }
                for (AnnotationImpl annotationImpl : arrayList2) {
                    annotationImpl.start = nodeImpl;
                    if (annotationImpl.start == annotationImpl.end) {
                        this.remove(annotationImpl);
                        continue;
                    }
                    this.addToStartOffsetIndex(annotationImpl);
                }
                for (AnnotationImpl annotationImpl : arrayList3) {
                    annotationImpl.end = nodeImpl;
                    if (annotationImpl.start != annotationImpl.end) continue;
                    this.remove(annotationImpl);
                }
                boolean bl = true;
                while (var11_25 < arrayList.size()) {
                    collection = (Node)arrayList.get((int)var11_25);
                    this.nodesByOffset.remove(collection.getOffset());
                    this.annotsByStartNode.remove(collection);
                    ++var11_25;
                }
                this.nodesByOffset.remove(nodeImpl.getOffset());
                nodeImpl.setOffset(l);
                this.nodesByOffset.put(nodeImpl.getOffset(), nodeImpl);
            }
        }
        boolean bl = Gate.getUserConfig().getBoolean("docedit_insert_prepend");
        long l4 = l;
        long l5 = l2;
        long l6 = documentContent == null ? 0L : documentContent.size();
        ArrayList arrayList = new ArrayList(this.nodesByOffset.tailMap(l).values());
        for (Comparable comparable : arrayList) {
            this.nodesByOffset.remove(((NodeImpl)comparable).getOffset());
        }
        for (Comparable comparable : arrayList) {
            l3 = ((NodeImpl)comparable).getOffset();
            long l7 = l3 - (l5 - l4) + l6;
            if (l3 == l4) {
                if (l7 < l4) {
                    l7 = l4;
                }
                if (bl) {
                    l7 = l4;
                }
            }
            ((NodeImpl)comparable).setOffset(new Long(l7));
        }
        for (Comparable comparable : arrayList) {
            this.nodesByOffset.put(((NodeImpl)comparable).getOffset(), comparable);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Document getDocument() {
        return this.doc;
    }

    @Override
    public Set<String> getAllTypes() {
        this.indexByType();
        return this.annotsByType.keySet();
    }

    private final Collection<Annotation> getAnnotsByStartNode(Integer n) {
        Object object = this.annotsByStartNode.get(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Annotation) {
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>(2);
            arrayList.add((Annotation)object);
            return arrayList;
        }
        return (Collection)object;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public synchronized void removeAnnotationSetListener(AnnotationSetListener annotationSetListener) {
        if (this.annotationSetListeners != null && this.annotationSetListeners.contains(annotationSetListener)) {
            Vector vector = (Vector)this.annotationSetListeners.clone();
            vector.removeElement(annotationSetListener);
            this.annotationSetListeners = vector;
        }
    }

    @Override
    public synchronized void addAnnotationSetListener(AnnotationSetListener annotationSetListener) {
        Vector vector;
        Vector vector2 = vector = this.annotationSetListeners == null ? new Vector(2) : (Vector)this.annotationSetListeners.clone();
        if (!vector.contains(annotationSetListener)) {
            vector.addElement(annotationSetListener);
            this.annotationSetListeners = vector;
        }
    }

    protected void fireAnnotationAdded(AnnotationSetEvent annotationSetEvent) {
        if (this.annotationSetListeners != null) {
            Vector vector = this.annotationSetListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((AnnotationSetListener)vector.elementAt(i)).annotationAdded(annotationSetEvent);
            }
        }
    }

    protected void fireAnnotationRemoved(AnnotationSetEvent annotationSetEvent) {
        if (this.annotationSetListeners != null) {
            Vector vector = this.annotationSetListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((AnnotationSetListener)vector.elementAt(i)).annotationRemoved(annotationSetEvent);
            }
        }
    }

    @Override
    public synchronized void removeGateListener(GateListener gateListener) {
        if (this.gateListeners != null && this.gateListeners.contains(gateListener)) {
            Vector vector = (Vector)this.gateListeners.clone();
            vector.removeElement(gateListener);
            this.gateListeners = vector;
        }
    }

    @Override
    public synchronized void addGateListener(GateListener gateListener) {
        Vector vector;
        Vector vector2 = vector = this.gateListeners == null ? new Vector(2) : (Vector)this.gateListeners.clone();
        if (!vector.contains(gateListener)) {
            vector.addElement(gateListener);
            this.gateListeners = vector;
        }
    }

    protected void fireGateEvent(GateEvent gateEvent) {
        if (this.gateListeners != null) {
            Vector vector = this.gateListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GateListener)vector.elementAt(i)).processGateEvent(gateEvent);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("name", this.name);
        putField.put("doc", this.doc);
        this.annotations = new Annotation[this.annotsById.size()];
        this.annotations = this.annotsById.values().toArray(this.annotations);
        putField.put("annotations", this.annotations);
        objectOutputStream.writeFields();
        this.annotations = null;
        boolean bl = this.annotsByType != null;
        boolean bl2 = this.annotsByStartNode != null;
        objectOutputStream.writeBoolean(bl);
        objectOutputStream.writeBoolean(bl2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.name = (String)getField.get("name", null);
        this.doc = (DocumentImpl)getField.get("doc", null);
        boolean bl = false;
        boolean bl2 = false;
        this.annotations = (Annotation[])getField.get("annotations", null);
        if (this.annotations == null) {
            Map map = (Map)getField.get("annotsById", null);
            if (map == null) {
                throw new IOException("Invalid serialised data: neither annotations array or map by id are present.");
            }
            this.annotations = map.values().toArray(new Annotation[0]);
        } else {
            bl = objectInputStream.readBoolean();
            bl2 = objectInputStream.readBoolean();
        }
        this.annotsById = new HashMap(this.annotations.length);
        if (bl) {
            this.annotsByType = new HashMap<String, AnnotationSet>(4);
        }
        if (bl2) {
            this.nodesByOffset = new RBTreeMap();
            this.annotsByStartNode = new HashMap<Integer, Object>(this.annotations.length);
        }
        for (int i = 0; i < this.annotations.length; ++i) {
            this.add(this.annotations[i]);
        }
        this.annotations = null;
    }

    static {
        AnnotationSetImpl.setAnnotationFactory(new DefaultAnnotationFactory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationSetIterator
    implements Iterator<Annotation> {
        private Iterator<Annotation> iter;
        protected Annotation lastNext = null;

        AnnotationSetIterator() {
            this.iter = AnnotationSetImpl.this.annotsById.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Annotation next() {
            this.lastNext = this.iter.next();
            return this.lastNext;
        }

        @Override
        public void remove() {
            this.iter.remove();
            AnnotationSetImpl.this.removeFromTypeIndex(this.lastNext);
            AnnotationSetImpl.this.removeFromOffsetIndex(this.lastNext);
            AnnotationSetImpl.this.fireAnnotationRemoved(new AnnotationSetEvent(AnnotationSetImpl.this, 202, AnnotationSetImpl.this.getDocument(), this.lastNext));
        }
    }
}

