/*
 * Decompiled with CFR 0.152.
 */
package gate.annotation;

import gate.Annotation;
import gate.FeatureMap;
import gate.Node;
import gate.event.AnnotationEvent;
import gate.event.AnnotationListener;
import gate.event.FeatureMapListener;
import gate.util.AbstractFeatureBearer;
import gate.util.FeatureBearer;
import java.io.Serializable;
import java.util.Set;
import java.util.Vector;

public class AnnotationImpl
extends AbstractFeatureBearer
implements Annotation,
FeatureBearer,
Comparable {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = -5658993256574857725L;
    private transient Vector annotationListeners;
    protected EventsHandler eventHandler;
    Integer id;
    String type;
    protected Node start;
    protected Node end;

    protected AnnotationImpl(Integer n, Node node, Node node2, String string, FeatureMap featureMap) {
        this.id = n;
        this.start = node;
        this.end = node2;
        this.type = string;
        this.features = featureMap;
    }

    public Integer getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Node getStartNode() {
        return this.start;
    }

    public Node getEndNode() {
        return this.end;
    }

    public String toString() {
        return "AnnotationImpl: id=" + this.id + "; type=" + this.type + "; features=" + this.features + "; start=" + this.start + "; end=" + this.end + System.getProperty("line.separator");
    }

    public int compareTo(Object object) throws ClassCastException {
        Annotation annotation = (Annotation)object;
        return this.id.compareTo(annotation.getId());
    }

    public int hashCode() {
        int n = 0;
        if (this.start != null && this.start.getOffset() != null) {
            n ^= this.start.getOffset().hashCode();
        }
        if (this.end != null && this.end.getOffset() != null) {
            n ^= this.end.getOffset().hashCode();
        }
        if (this.features != null) {
            n ^= this.features.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AnnotationImpl)) {
            return false;
        }
        Annotation annotation = (Annotation)object;
        if (this.type == null ^ annotation.getType() == null) {
            return false;
        }
        if (this.type != null && !this.type.equals(annotation.getType())) {
            return false;
        }
        if (this.id == null ^ annotation.getId() == null) {
            return false;
        }
        if (this.id != null && !this.id.equals(annotation.getId())) {
            return false;
        }
        if (this.start == null ^ annotation.getStartNode() == null) {
            return false;
        }
        if (this.start != null) {
            if (this.start.getOffset() == null ^ annotation.getStartNode().getOffset() == null) {
                return false;
            }
            if (this.start.getOffset() != null && !this.start.getOffset().equals(annotation.getStartNode().getOffset())) {
                return false;
            }
        }
        if (this.end == null ^ annotation.getEndNode() == null) {
            return false;
        }
        if (this.end != null) {
            if (this.end.getOffset() == null ^ annotation.getEndNode().getOffset() == null) {
                return false;
            }
            if (this.end.getOffset() != null && !this.end.getOffset().equals(annotation.getEndNode().getOffset())) {
                return false;
            }
        }
        if (this.features == null ^ annotation.getFeatures() == null) {
            return false;
        }
        return this.features == null || this.features.equals(annotation.getFeatures());
    }

    public void setFeatures(FeatureMap featureMap) {
        if (this.eventHandler != null) {
            this.features.removeFeatureMapListener(this.eventHandler);
        }
        this.features = featureMap;
        if (this.annotationListeners != null && !this.annotationListeners.isEmpty()) {
            this.features.addFeatureMapListener(this.eventHandler);
        }
        this.fireAnnotationUpdated(new AnnotationEvent(this, 701));
    }

    public boolean isCompatible(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        if (this.coextensive(annotation)) {
            if (annotation.getFeatures() == null) {
                return true;
            }
            if (annotation.getFeatures().subsumes(this.getFeatures())) {
                return true;
            }
        }
        return false;
    }

    public boolean isCompatible(Annotation annotation, Set set) {
        if (set == null) {
            return this.isCompatible(annotation);
        }
        if (annotation == null) {
            return false;
        }
        if (this.coextensive(annotation)) {
            if (annotation.getFeatures() == null) {
                return true;
            }
            if (annotation.getFeatures().subsumes(this.getFeatures(), set)) {
                return true;
            }
        }
        return false;
    }

    public boolean isPartiallyCompatible(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        if (this.overlaps(annotation)) {
            if (annotation.getFeatures() == null) {
                return true;
            }
            if (annotation.getFeatures().subsumes(this.getFeatures())) {
                return true;
            }
        }
        return false;
    }

    public boolean isPartiallyCompatible(Annotation annotation, Set set) {
        if (set == null) {
            return this.isPartiallyCompatible(annotation);
        }
        if (annotation == null) {
            return false;
        }
        if (this.overlaps(annotation)) {
            if (annotation.getFeatures() == null) {
                return true;
            }
            if (annotation.getFeatures().subsumes(this.getFeatures(), set)) {
                return true;
            }
        }
        return false;
    }

    public boolean coextensive(Annotation annotation) {
        if (annotation.getStartNode() == null ^ this.getStartNode() == null) {
            return false;
        }
        if (annotation.getStartNode() != null) {
            if (annotation.getStartNode().getOffset() == null ^ this.getStartNode().getOffset() == null) {
                return false;
            }
            if (annotation.getStartNode().getOffset() != null && !annotation.getStartNode().getOffset().equals(this.getStartNode().getOffset())) {
                return false;
            }
        }
        if (annotation.getEndNode() == null ^ this.getEndNode() == null) {
            return false;
        }
        if (annotation.getEndNode() != null) {
            if (annotation.getEndNode().getOffset() == null ^ this.getEndNode().getOffset() == null) {
                return false;
            }
            if (annotation.getEndNode().getOffset() != null && !annotation.getEndNode().getOffset().equals(this.getEndNode().getOffset())) {
                return false;
            }
        }
        return true;
    }

    public boolean overlaps(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        if (annotation.getStartNode() == null || annotation.getEndNode() == null || annotation.getStartNode().getOffset() == null || annotation.getEndNode().getOffset() == null) {
            return false;
        }
        if (annotation.getEndNode().getOffset() <= this.getStartNode().getOffset()) {
            return false;
        }
        return annotation.getStartNode().getOffset() < this.getEndNode().getOffset();
    }

    public synchronized void removeAnnotationListener(AnnotationListener annotationListener) {
        if (this.annotationListeners != null && this.annotationListeners.contains(annotationListener)) {
            Vector vector = (Vector)this.annotationListeners.clone();
            vector.removeElement(annotationListener);
            this.annotationListeners = vector;
        }
    }

    public synchronized void addAnnotationListener(AnnotationListener annotationListener) {
        Vector vector;
        Vector vector2 = vector = this.annotationListeners == null ? new Vector(2) : (Vector)this.annotationListeners.clone();
        if (vector.isEmpty()) {
            FeatureMap featureMap = this.getFeatures();
            if (this.eventHandler == null) {
                this.eventHandler = new EventsHandler();
            }
            featureMap.addFeatureMapListener(this.eventHandler);
        }
        if (!vector.contains(annotationListener)) {
            vector.addElement(annotationListener);
            this.annotationListeners = vector;
        }
    }

    protected void fireAnnotationUpdated(AnnotationEvent annotationEvent) {
        if (this.annotationListeners != null) {
            Vector vector = this.annotationListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((AnnotationListener)vector.elementAt(i)).annotationUpdated(annotationEvent);
            }
        }
    }

    class EventsHandler
    implements FeatureMapListener,
    Serializable {
        static final long serialVersionUID = 2608156420244752907L;

        EventsHandler() {
        }

        public void featureMapUpdated() {
            AnnotationImpl.this.fireAnnotationUpdated(new AnnotationEvent(AnnotationImpl.this, 701));
        }
    }
}

