/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.Controller;
import gate.Corpus;
import gate.CreoleProxy;
import gate.CreoleRegister;
import gate.DataStore;
import gate.DataStoreRegister;
import gate.Document;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.VisualResource;
import gate.creole.AbstractResource;
import gate.creole.ParameterException;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.MainFrame;
import gate.jape.parser.ParseCpsl;
import gate.persist.PersistenceException;
import gate.persist.SerialDataStore;
import gate.security.AccessController;
import gate.security.AccessControllerImpl;
import gate.security.SecurityException;
import gate.util.Err;
import gate.util.SimpleFeatureMapImpl;
import gate.util.Strings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class Factory {
    private static final boolean DEBUG = false;
    private static CreoleRegister reg = Gate.getCreoleRegister();
    private static DataStoreRegister dsReg = Gate.getDataStoreRegister();
    private static CreoleProxy creoleProxy;
    private static HashMap accessControllerPool;
    static Class japeParserClass;

    public static Resource createResource(String string) throws ResourceInstantiationException {
        ResourceData resourceData = (ResourceData)reg.get(string);
        if (resourceData == null) {
            throw new ResourceInstantiationException("Couldn't get resource data for " + string);
        }
        ParameterList parameterList = resourceData.getParameterList();
        FeatureMap featureMap = null;
        try {
            featureMap = parameterList.getInitimeDefaults();
        }
        catch (ParameterException parameterException) {
            throw new ResourceInstantiationException("Couldn't get default parameters for " + string + ": " + parameterException);
        }
        return Factory.createResource(string, featureMap);
    }

    public static Resource createResource(String string, FeatureMap featureMap) throws ResourceInstantiationException {
        return Factory.createResource(string, featureMap, null, null);
    }

    public static Resource createResource(String string, FeatureMap featureMap, FeatureMap featureMap2) throws ResourceInstantiationException {
        return Factory.createResource(string, featureMap, featureMap2, null);
    }

    public static Resource createResource(String string, FeatureMap featureMap, FeatureMap featureMap2, String string2) throws ResourceInstantiationException {
        Map<Object, Object> map;
        DataStore dataStore;
        ResourceData resourceData = (ResourceData)reg.get(string);
        if (resourceData == null) {
            throw new ResourceInstantiationException("Couldn't get resource data for " + string);
        }
        Class<? extends Resource> clazz = null;
        try {
            clazz = resourceData.getResourceClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ResourceInstantiationException("Couldn't get resource class from the resource data:" + Strings.getNl() + classNotFoundException);
        }
        Resource resource = null;
        if (LanguageResource.class.isAssignableFrom(clazz) && (dataStore = (DataStore)featureMap.get("DataStore")) != null) {
            if (dataStore instanceof SerialDataStore && !Serializable.class.isAssignableFrom(clazz)) {
                throw new ResourceInstantiationException("Resource cannot be (de-)serialized: " + clazz.getName());
            }
            Object v = featureMap.get("LRPersistenceId");
            if (v == null) {
                throw new ResourceInstantiationException("No instance id for " + clazz);
            }
            try {
                resource = dataStore.getLr(clazz.getName(), v);
            }
            catch (PersistenceException persistenceException) {
                throw new ResourceInstantiationException("Bad read from DB: " + persistenceException);
            }
            catch (SecurityException securityException) {
                throw new ResourceInstantiationException("Insufficient permissions: " + securityException);
            }
            resourceData.addInstantiation(resource);
            if (featureMap2 != null) {
                if (resource.getFeatures() == null) {
                    resource.setFeatures(Factory.newFeatureMap());
                }
                resource.getFeatures().putAll(featureMap2);
            }
            if (resource.getName() == null) {
                resource.setName(string2 == null ? resourceData.getName() + "_" + Gate.genSym() : string2);
            }
            creoleProxy.fireResourceLoaded(new CreoleEvent(resource, 1));
            return resource;
        }
        try {
            resource = clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ResourceInstantiationException("Couldn't create resource instance, access denied: " + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ResourceInstantiationException("Couldn't create resource instance due to newInstance() failure: " + instantiationException);
        }
        if (string2 == null) {
            string2 = resourceData.getName() + "_" + Gate.genSym();
        }
        resource.setName(string2);
        if (!LanguageResource.class.isAssignableFrom(clazz)) {
            if (ProcessingResource.class.isAssignableFrom(clazz)) {
                try {
                    map = Factory.newFeatureMap();
                    map.putAll(resourceData.getParameterList().getRuntimeDefaults());
                    resource.setParameterValues((FeatureMap)map);
                }
                catch (ParameterException parameterException) {
                    throw new ResourceInstantiationException("Could not set the runtime parameters to their default values for: " + resource.getClass().getName() + " :\n" + parameterException.toString());
                }
            } else if (!VisualResource.class.isAssignableFrom(clazz) && !Controller.class.isAssignableFrom(clazz)) {
                Err.prln("WARNING: instantiating resource which is not a PR, LR or VR:");
                Err.prln(resourceData + "END OF WARNING" + Strings.getNl());
            }
        }
        try {
            map = Factory.newFeatureMap();
            map.putAll(resourceData.getParameterList().getInitimeDefaults());
            map.putAll(featureMap);
            resource.setParameterValues((FeatureMap)map);
        }
        catch (ParameterException parameterException) {
            throw new ResourceInstantiationException("Could not set the init parameters for: " + resource.getClass().getName() + " :\n" + parameterException.toString());
        }
        map = new HashMap(MainFrame.getListeners());
        if (map != null && !map.isEmpty()) {
            try {
                AbstractResource.setResourceListeners(resource, map);
            }
            catch (Exception exception) {
                throw new ResourceInstantiationException("Parameterisation failure" + exception);
            }
        }
        if (resource.getFeatures() == null || resource.getFeatures().isEmpty()) {
            FeatureMap featureMap3 = Factory.newFeatureMap();
            featureMap3.putAll(resourceData.getFeatures());
            resource.setFeatures(featureMap3);
        }
        resource = resource.init();
        if (map != null && !map.isEmpty()) {
            try {
                AbstractResource.removeResourceListeners(resource, map);
            }
            catch (Exception exception) {
                throw new ResourceInstantiationException("Parameterisation failure" + exception);
            }
        }
        resourceData.addInstantiation(resource);
        if (featureMap2 != null) {
            resource.getFeatures().putAll(featureMap2);
        }
        creoleProxy.fireResourceLoaded(new CreoleEvent(resource, 1));
        return resource;
    }

    public static void deleteResource(Resource resource) {
        ResourceData resourceData = (ResourceData)reg.get(resource.getClass().getName());
        if (resourceData != null) {
            resourceData.removeInstantiation(resource);
        }
        creoleProxy.fireResourceUnloaded(new CreoleEvent(resource, 2));
        resource.cleanup();
    }

    public static Corpus newCorpus(String string) throws ResourceInstantiationException {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("name", string);
        return (Corpus)Factory.createResource("gate.corpora.CorpusImpl", featureMap);
    }

    public static Document newDocument(URL uRL) throws ResourceInstantiationException {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", uRL);
        return (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
    }

    public static Document newDocument(URL uRL, String string) throws ResourceInstantiationException {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", uRL);
        featureMap.put("encoding", string);
        return (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
    }

    public static Document newDocument(String string) throws ResourceInstantiationException {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("stringContent", string);
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        document.setSourceUrl(null);
        return document;
    }

    public static Class getJapeParserClass() {
        return japeParserClass;
    }

    public static void setJapeParserClass(Class clazz) {
        if (!ParseCpsl.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Parser class must inherit from " + ParseCpsl.class);
        }
        japeParserClass = clazz;
    }

    public static ParseCpsl newJapeParser(Reader reader, HashMap hashMap) {
        try {
            Constructor constructor = japeParserClass.getConstructor(Reader.class, hashMap.getClass());
            return (ParseCpsl)constructor.newInstance(reader, hashMap);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    public static ParseCpsl newJapeParser(URL uRL, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(uRL.openStream()), string);
        ParseCpsl parseCpsl = Factory.newJapeParser(inputStreamReader, new HashMap());
        parseCpsl.setBaseURL(uRL);
        parseCpsl.setEncoding(string);
        return parseCpsl;
    }

    public static FeatureMap newFeatureMap() {
        return new SimpleFeatureMapImpl();
    }

    public static DataStore openDataStore(String string, String string2) throws PersistenceException {
        DataStore dataStore = Factory.instantiateDataStore(string, string2);
        dataStore.open();
        if (dsReg.add(dataStore)) {
            creoleProxy.fireDatastoreOpened(new CreoleEvent(dataStore, 4));
        }
        return dataStore;
    }

    public static DataStore createDataStore(String string, String string2) throws PersistenceException, UnsupportedOperationException {
        DataStore dataStore = Factory.instantiateDataStore(string, string2);
        dataStore.create();
        dataStore.open();
        if (dsReg.add(dataStore)) {
            creoleProxy.fireDatastoreCreated(new CreoleEvent(dataStore, 3));
        }
        return dataStore;
    }

    protected static DataStore instantiateDataStore(String string, String string2) throws PersistenceException {
        DataStore dataStore = null;
        try {
            dataStore = (DataStore)Gate.getClassLoader().loadClass(string).newInstance();
        }
        catch (Exception exception) {
            throw new PersistenceException("Couldn't create DS class: " + exception);
        }
        if (dsReg == null) {
            dsReg = Gate.getDataStoreRegister();
        }
        dataStore.setStorageUrl(string2.toString());
        return dataStore;
    }

    public static synchronized void addCreoleListener(CreoleListener creoleListener) {
        creoleProxy.addCreoleListener(creoleListener);
    }

    public static synchronized AccessController createAccessController(String string) throws PersistenceException {
        if (!accessControllerPool.containsKey(string)) {
            AccessControllerImpl accessControllerImpl = new AccessControllerImpl(string);
            accessControllerImpl.open();
            accessControllerPool.put(string, accessControllerImpl);
        }
        return (AccessController)accessControllerPool.get(string);
    }

    static {
        japeParserClass = ParseCpsl.class;
        creoleProxy = new CreoleProxy();
        accessControllerPool = new HashMap();
    }
}

