/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.LanguageResource;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.creole.AbstractLanguageResource;
import gate.event.StatusListener;
import gate.util.DocumentFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class DocumentFormat
extends AbstractLanguageResource
implements LanguageResource {
    private static final boolean DEBUG = false;
    private MimeType mimeType = null;
    protected static Map mimeString2ClassHandlerMap = new HashMap();
    protected static Map mimeString2mimeTypeMap = new HashMap();
    protected static Map suffixes2mimeTypeMap = new HashMap();
    protected static Map magic2mimeTypeMap = new HashMap();
    protected Map markupElementsMap = null;
    protected Map element2StringMap = null;
    private FeatureMap features = null;
    private transient Vector statusListeners;
    private Boolean shouldCollectRepositioning = new Boolean(false);

    public Boolean supportsRepositioning() {
        return new Boolean(false);
    }

    public void setShouldCollectRepositioning(Boolean bl) {
        this.shouldCollectRepositioning = this.supportsRepositioning() != false && bl != false ? bl : new Boolean(false);
    }

    public Boolean getShouldCollectRepositioning() {
        return this.shouldCollectRepositioning;
    }

    public abstract void unpackMarkup(Document var1) throws DocumentFormatException;

    public abstract void unpackMarkup(Document var1, RepositioningInfo var2, RepositioningInfo var3) throws DocumentFormatException;

    public void unpackMarkup(Document document, String string) throws DocumentFormatException {
        FeatureMap featureMap = document.getFeatures();
        if (featureMap == null) {
            featureMap = Factory.newFeatureMap();
        }
        featureMap.put(string, document.getContent().toString());
        document.setFeatures(featureMap);
        this.unpackMarkup(document);
    }

    private static MimeType getMimeType(String string) {
        if (string == null) {
            return null;
        }
        return (MimeType)suffixes2mimeTypeMap.get(string.toLowerCase());
    }

    private static MimeType getMimeType(URL uRL) {
        String string = null;
        String string2 = null;
        String string3 = null;
        InputStream inputStream = null;
        MimeType mimeType = null;
        MimeType mimeType2 = null;
        MimeType mimeType3 = null;
        String string4 = null;
        if (uRL == null) {
            return null;
        }
        try {
            inputStream = uRL.openConnection().getInputStream();
            string3 = uRL.openConnection().getContentType();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().toLowerCase();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().toLowerCase();
            }
            if (string2 != null) {
                stringTokenizer = new StringTokenizer(string2, "=");
                string2 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken().toUpperCase();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken().toUpperCase();
                }
            }
        }
        mimeType = (MimeType)mimeString2mimeTypeMap.get(string);
        string4 = DocumentFormat.getFileSufix(uRL);
        mimeType2 = DocumentFormat.getMimeType(string4);
        mimeType3 = DocumentFormat.guessTypeUsingMagicNumbers(inputStream, string2);
        return DocumentFormat.decideBetweenThreeMimeTypes(mimeType, mimeType2, mimeType3);
    }

    protected static MimeType decideBetweenThreeMimeTypes(MimeType mimeType, MimeType mimeType2, MimeType mimeType3) {
        if (DocumentFormat.areEqual(mimeType, mimeType2)) {
            return mimeType2;
        }
        if (DocumentFormat.areEqual(mimeType2, mimeType3)) {
            return mimeType2;
        }
        if (DocumentFormat.areEqual(mimeType, mimeType3)) {
            return mimeType;
        }
        if (mimeType2 != null) {
            mimeType2.addParameter("Priority", "1");
        }
        if (mimeType != null) {
            mimeType.addParameter("Priority", "2");
        }
        if (mimeType3 != null) {
            mimeType3.addParameter("Priority", "3");
        }
        return DocumentFormat.decideBetweenTwoMimeTypes(DocumentFormat.decideBetweenTwoMimeTypes(mimeType, mimeType2), mimeType3);
    }

    protected static MimeType decideBetweenTwoMimeTypes(MimeType mimeType, MimeType mimeType2) {
        if (mimeType == null) {
            return mimeType2;
        }
        if (mimeType2 == null) {
            return mimeType;
        }
        int n = 0;
        int n2 = 0;
        if (mimeType.hasParameter("Priority")) {
            try {
                n = new Integer(mimeType.getParameterValue("Priority"));
            }
            catch (NumberFormatException numberFormatException) {
                return mimeType2;
            }
        }
        if (mimeType2.hasParameter("Priority")) {
            try {
                n2 = new Integer(mimeType2.getParameterValue("Priority"));
            }
            catch (NumberFormatException numberFormatException) {
                return mimeType;
            }
        }
        if (n <= n2) {
            return mimeType;
        }
        return mimeType2;
    }

    protected static boolean areEqual(MimeType mimeType, MimeType mimeType2) {
        if (mimeType == null || mimeType2 == null) {
            return false;
        }
        return mimeType.getType().equals(mimeType2.getType()) && mimeType.getSubtype().equals(mimeType2.getSubtype());
    }

    protected static MimeType guessTypeUsingMagicNumbers(InputStream inputStream, String string) {
        if (inputStream == null) {
            return null;
        }
        InputStreamReader inputStreamReader = null;
        if (string != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStreamReader = null;
            }
        }
        if (inputStreamReader == null) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        return DocumentFormat.runMagicNumbers(inputStreamReader);
    }

    protected static MimeType runMagicNumbers(InputStreamReader inputStreamReader) {
        if (inputStreamReader == null) {
            return null;
        }
        String string = null;
        int n = 2048;
        int n2 = 0;
        char[] cArray = new char[n];
        try {
            n2 = inputStreamReader.read(cArray, 0, n);
        }
        catch (IOException iOException) {
            return null;
        }
        if (n2 == -1) {
            return null;
        }
        string = new String(cArray, 0, n2);
        return DocumentFormat.getTypeFromContent(string);
    }

    private static MimeType getTypeFromContent(String string) {
        MimeType mimeType = null;
        Set set = magic2mimeTypeMap.keySet();
        Iterator iterator = set.iterator();
        string = string.toLowerCase();
        while (iterator.hasNext()) {
            String string2 = ((String)iterator.next()).toLowerCase();
            if (string.indexOf(string2) == -1) continue;
            mimeType = (MimeType)magic2mimeTypeMap.get(string2);
        }
        return mimeType;
    }

    private static String getFileSufix(URL uRL) {
        String string = null;
        String string2 = null;
        if (uRL != null) {
            string = uRL.getFile();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
        }
        return string2;
    }

    public static DocumentFormat getDocumentFormat(Document document, MimeType mimeType) {
        FeatureMap featureMap = null;
        if (mimeType == null) {
            String string = document.getContent().toString();
            if (string.length() > 2048) {
                string = string.substring(0, 2048);
            }
            mimeType = DocumentFormat.getTypeFromContent(string);
        }
        if (mimeType != null) {
            if (document.getFeatures() == null) {
                featureMap = Factory.newFeatureMap();
                document.setFeatures(featureMap);
            }
            document.getFeatures().put("MimeType", mimeType.getType() + "/" + mimeType.getSubtype());
            return (DocumentFormat)mimeString2ClassHandlerMap.get(mimeType.getType() + "/" + mimeType.getSubtype());
        }
        return null;
    }

    public static DocumentFormat getDocumentFormat(Document document, String string) {
        return DocumentFormat.getDocumentFormat(document, DocumentFormat.getMimeType(string));
    }

    public static DocumentFormat getDocumentFormat(Document document, URL uRL) {
        return DocumentFormat.getDocumentFormat(document, DocumentFormat.getMimeType(uRL));
    }

    public FeatureMap getFeatures() {
        return this.features;
    }

    public Map getMarkupElementsMap() {
        return this.markupElementsMap;
    }

    public Map getElement2StringMap() {
        return this.element2StringMap;
    }

    public void setMarkupElementsMap(Map map) {
        this.markupElementsMap = map;
    }

    public void setElement2StringMap(Map map) {
        this.element2StringMap = map;
    }

    public void setFeatures(FeatureMap featureMap) {
        this.features = featureMap;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public static MimeType getMimeTypeForString(String string) {
        return (MimeType)mimeString2mimeTypeMap.get(string);
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(statusListener)) {
            Vector vector = (Vector)this.statusListeners.clone();
            vector.removeElement(statusListener);
            this.statusListeners = vector;
        }
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector;
        Vector vector2 = vector = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!vector.contains(statusListener)) {
            vector.addElement(statusListener);
            this.statusListeners = vector;
        }
    }

    protected void fireStatusChanged(String string) {
        if (this.statusListeners != null) {
            Vector vector = this.statusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((StatusListener)vector.elementAt(i)).statusChanged(string);
            }
        }
    }
}

