/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.ANNIETransducer;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.POSTagger;
import gate.creole.gazetteer.DefaultGazetteer;
import gate.creole.orthomatcher.OrthoMatcher;
import gate.creole.splitter.SentenceSplitter;
import gate.creole.tokeniser.DefaultTokeniser;
import gate.util.GateException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import gate.util.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CookBook
extends TestCase {
    private static final boolean DEBUG = false;
    Corpus corpus = null;
    Document doc1 = null;
    Document doc2 = null;
    private static String usage = "usage: CookBook [-dir directory-name | file(s)]";

    public void testResourceCreation() throws GateException {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        featureMap.put("markupAware", new Boolean(true));
        Resource resource = Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        CookBook.assertTrue((String)("should be document but the class is: " + resource.getClass().getName()), (boolean)(resource instanceof Document));
        Document document = (Document)resource;
        AnnotationSet annotationSet = document.getAnnotations("Original markups");
        CookBook.assertNotNull((String)("no markup annotations on doc " + document), (Object)annotationSet);
        int n = annotationSet.size();
        CookBook.assertTrue((String)("wrong number annots on doc: " + document + n), (n == 20 ? 1 : 0) != 0);
    }

    public void testCorpusConstruction() throws GateException {
        this.corpus = Factory.newCorpus("My example corpus");
        CookBook.assertTrue((boolean)this.corpus.isEmpty());
    }

    public void testAddingDocuments() throws GateException {
        this.corpus = Factory.newCorpus("My example corpus");
        this.corpus.add(this.doc1);
        this.corpus.add(this.doc2);
        for (Document document : this.corpus) {
            CookBook.assertTrue((String)"document url not as expected", (document.getSourceUrl().toExternalForm().endsWith("doc0.html") || document.getSourceUrl().toExternalForm().endsWith("test1.htm") ? 1 : 0) != 0);
        }
    }

    public void testAddingAnnotations() {
        AnnotationSet annotationSet = this.doc1.getAnnotations();
        FeatureMap featureMap = this.doc1.getFeatures();
        try {
            Integer n = annotationSet.add(new Long(10L), new Long(20L), "T1", featureMap);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            CookBook.fail((String)invalidOffsetException.toString());
        }
    }

    public void testUsingFeatures() {
        AnnotationSet annotationSet = this.doc1.getAnnotations();
        FeatureMap featureMap = Factory.newFeatureMap();
        this.doc1.setFeatures(featureMap);
        CookBook.assertTrue((featureMap.size() == 0 ? 1 : 0) != 0);
        featureMap.put("author", "segovia");
        CookBook.assertTrue((boolean)featureMap.get("author").equals("segovia"));
        featureMap.put("author", "brendl");
        CookBook.assertTrue((boolean)featureMap.get("author").equals("brendl"));
        CookBook.assertTrue((featureMap.size() == 1 ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Serializable serializable;
        Out.prln("CookBook.main");
        Out.prln("processing command line arguments");
        List<Object> list = null;
        if (stringArray.length < 1) {
            throw new GateException(usage);
        }
        if (stringArray[0].equals("-dir")) {
            if (stringArray.length < 2) {
                throw new GateException(usage);
            }
            serializable = new File(stringArray[1]);
            object = ((File)serializable).listFiles();
            if (object == null) {
                throw new GateException(((File)serializable).getPath() + " is not a directory; " + usage);
            }
            list = Arrays.asList(object);
        } else {
            list = new ArrayList<File>();
            for (int i = 0; i < stringArray.length; ++i) {
                list.add(new File(stringArray[i]));
            }
        }
        if (list.isEmpty()) {
            throw new GateException("No files to process!");
        }
        Out.prln("initialising GATE");
        Gate.init();
        Out.prln("creating PRs");
        serializable = (DefaultTokeniser)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser");
        object = (SentenceSplitter)Factory.createResource("gate.creole.splitter.SentenceSplitter");
        POSTagger pOSTagger = (POSTagger)Factory.createResource("gate.creole.POSTagger");
        DefaultGazetteer defaultGazetteer = (DefaultGazetteer)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer");
        ANNIETransducer aNNIETransducer = (ANNIETransducer)Factory.createResource("gate.creole.ANNIETransducer");
        OrthoMatcher orthoMatcher = (OrthoMatcher)Factory.createResource("gate.creole.orthomatcher.OrthoMatcher");
        String string = ((File)list.get(0)).getParent() + Strings.getFileSep() + "out";
        if (!new File(string).mkdir()) {
            throw new GateException("Could not create the output directory");
        }
        String string2 = Strings.getNl();
        String string3 = Strings.getFileSep();
        String string4 = ((File)list.get(0)).getParent() + string3 + "index.html";
        FileWriter fileWriter = new FileWriter(new File(string4));
        fileWriter.write("<HTML><HEAD><TITLE>Documents list</TITLE></HEAD>");
        fileWriter.write(string2 + "<BODY>" + string2 + "<UL>" + string2);
        Iterator<Object> iterator = list.iterator();
        Out.prln("looping on input files list");
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            Out.prln("processing file " + file.getPath());
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("sourceUrl", file.toURI().toURL().toExternalForm());
            featureMap.put("encoding", "");
            Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
            ((AbstractLanguageAnalyser)serializable).setDocument(document);
            ((AbstractLanguageAnalyser)object).setDocument(document);
            pOSTagger.setDocument(document);
            defaultGazetteer.setDocument(document);
            aNNIETransducer.setDocument(document);
            orthoMatcher.setDocument(document);
            ((DefaultTokeniser)serializable).execute();
            ((SentenceSplitter)object).execute();
            pOSTagger.execute();
            defaultGazetteer.execute();
            aNNIETransducer.execute();
            orthoMatcher.execute();
            StringBuffer stringBuffer = new StringBuffer(file.getParent());
            stringBuffer.append(string3);
            stringBuffer.append("out");
            stringBuffer.append(string3);
            stringBuffer.append("gate__");
            stringBuffer.append(file.getName());
            stringBuffer.append(".txt");
            File file2 = new File(stringBuffer.toString());
            FileWriter fileWriter2 = new FileWriter(file2);
            Out.prln("dumping " + file2.getPath());
            AnnotationSet annotationSet = document.getAnnotations("nercAS").get("Token");
            for (Annotation annotation : annotationSet) {
                FeatureMap featureMap2 = annotation.getFeatures();
                String string5 = (String)featureMap2.get("string");
                String string6 = (String)featureMap2.get("category");
                fileWriter2.write(string5 + "\t" + string6 + string2);
            }
            fileWriter2.write(document.getFeatures().get("entitySet").toString());
            fileWriter2.close();
            fileWriter.write("<LI><A href=\"" + file.getName() + "\">" + file.getName() + "</a>" + " -> " + "<a href=\"" + "out" + string3 + file2.getName() + "\">" + "out" + string3 + file2.getName() + "</a></LI>\n");
            Out.prln("deleting gate doc");
            Factory.deleteResource(document);
        }
        fileWriter.write(string2 + "</UL>" + string2 + "</BODY></HTML>" + string2);
        fileWriter.close();
        Out.prln("The End (roll credits)");
    }

    public void setUp() throws GateException, IOException {
        this.corpus = Factory.newCorpus("My example corpus");
        this.doc1 = Factory.newDocument(Gate.getUrl("tests/doc0.html"));
        this.doc2 = Factory.newDocument(Gate.getUrl("tests/html/test1.htm"));
    }

    public CookBook(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(CookBook.class);
    }
}

