/*
 * Decompiled with CFR 0.152.
 */
package debugger.resources.pr;

import debugger.resources.ResourcesFactory;
import debugger.resources.pr.PhaseModel;
import debugger.resources.pr.PrModel;
import debugger.resources.pr.RuleModel;
import debugger.resources.pr.RuleTrace;
import gate.Annotation;
import gate.AnnotationSet;
import gate.annotation.AnnotationSetImpl;
import gate.fsm.State;
import gate.jape.RightHandSide;
import gate.jape.SinglePhaseTransducer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TraceContainer
extends ArrayList {
    private HashMap phaseCut = new HashMap();

    public RuleTrace getStateContainer(State state) {
        RuleTrace ruleTrace = null;
        ArrayList<RuleTrace> arrayList = new ArrayList<RuleTrace>();
        for (RuleTrace ruleTrace2 : this) {
            if (!ruleTrace2.containsState(state)) continue;
            arrayList.add(ruleTrace2);
        }
        if (arrayList.isEmpty()) {
            return ruleTrace;
        }
        ruleTrace = (RuleTrace)arrayList.remove(0);
        for (RuleTrace ruleTrace2 : arrayList) {
            if (ruleTrace2.getAnnotations().lastNode().getOffset() <= ruleTrace.getAnnotations().lastNode().getOffset()) continue;
            ruleTrace = ruleTrace2;
        }
        return ruleTrace;
    }

    public TraceContainer getTraceByOffset(Long l, Long l2) {
        TraceContainer traceContainer = new TraceContainer();
        traceContainer.phaseCut.putAll(this.phaseCut);
        for (RuleTrace ruleTrace : this) {
            if (ruleTrace.getAnnotations().firstNode().getOffset() < l || ruleTrace.getAnnotations().firstNode().getOffset() >= l2) continue;
            traceContainer.add(ruleTrace);
        }
        return traceContainer;
    }

    public TraceContainer getTraceByRuleModel(RuleModel ruleModel) {
        TraceContainer traceContainer = new TraceContainer();
        for (RuleTrace ruleTrace : this) {
            if (ruleTrace.getRuleModel() != ruleModel) continue;
            traceContainer.add(ruleTrace);
        }
        traceContainer.phaseCut.putAll(this.phaseCut);
        return traceContainer;
    }

    public AnnotationSet getPhaseCut(PhaseModel phaseModel) {
        return (AnnotationSet)this.phaseCut.get(phaseModel);
    }

    public void putPhaseCut(SinglePhaseTransducer singlePhaseTransducer, AnnotationSet annotationSet) {
        AnnotationSetImpl annotationSetImpl = null;
        boolean bl = false;
        annotationSetImpl = new AnnotationSetImpl(annotationSet.getDocument());
        for (Object object : annotationSet) {
            annotationSetImpl.add((Annotation)object);
        }
        for (int i = 0; i < ResourcesFactory.getPrRoot().getPRs().size(); ++i) {
            Object object;
            object = (PrModel)ResourcesFactory.getPrRoot().getPRs().get(i);
            for (int j = 0; j < ((PrModel)object).getPhases().size(); ++j) {
                PhaseModel phaseModel = (PhaseModel)((PrModel)object).getPhases().get(j);
                if (phaseModel.getSPT() != singlePhaseTransducer) continue;
                if (this.phaseCut.containsKey(phaseModel)) {
                    ((AnnotationSet)this.phaseCut.get(phaseModel)).addAll(annotationSetImpl);
                } else {
                    this.phaseCut.put(phaseModel, annotationSetImpl);
                }
                bl = true;
            }
        }
    }

    public void addAll(TraceContainer traceContainer) {
        super.addAll(traceContainer);
        for (PhaseModel phaseModel : traceContainer.phaseCut.keySet()) {
            if (this.phaseCut.containsKey(phaseModel)) {
                if (phaseModel.getName().equalsIgnoreCase("postprocess")) {
                    this.phaseCut.clear();
                    super.clear();
                    super.addAll(traceContainer);
                    this.phaseCut.put(phaseModel, traceContainer.phaseCut.get(phaseModel));
                    continue;
                }
                ((AnnotationSet)this.phaseCut.get(phaseModel)).addAll((AnnotationSet)traceContainer.phaseCut.get(phaseModel));
                continue;
            }
            this.phaseCut.put(phaseModel, traceContainer.phaseCut.get(phaseModel));
        }
    }

    public void leaveLast(RightHandSide rightHandSide) {
        Iterator iterator = this.iterator();
        RuleTrace ruleTrace = null;
        while (iterator.hasNext()) {
            RuleTrace ruleTrace2 = (RuleTrace)iterator.next();
            if (ruleTrace2.getRuleModel().getRHS() != rightHandSide) continue;
            ruleTrace = ruleTrace2;
        }
        for (RuleTrace ruleTrace2 : this) {
            if (ruleTrace2 == ruleTrace || !ruleTrace2.isFinished()) continue;
            ruleTrace2.setOverrided(ruleTrace.getRuleModel());
        }
    }
}

