/*
 * Decompiled with CFR 0.152.
 */
package debugger.resources.pr;

import debugger.resources.ResourcesFactory;
import debugger.resources.pr.PhaseModel;
import debugger.resources.pr.PrModel;
import debugger.resources.pr.RuleModel;
import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.FeatureMap;
import gate.annotation.AnnotationSetImpl;
import gate.fsm.State;
import gate.fsm.Transition;
import gate.jape.RightHandSide;
import java.util.ArrayList;
import java.util.HashMap;

public class RuleTrace {
    private boolean finished = false;
    private RuleModel ruleModel;
    private AnnotationSet annotations;
    private HashMap patterns;
    private State lastState;
    private static int maxId = 0;
    public int id;
    private RuleModel overrided;

    public RuleTrace(State state, Document document) {
        this.ruleModel = this.findModel(state);
        this.overrided = null;
        this.annotations = new AnnotationSetImpl(document);
        this.lastState = null;
        this.addState(state);
        this.patterns = new HashMap();
        this.id = maxId++;
    }

    public void addState(State state) {
        if (state.isFinal()) {
            this.finished = true;
        }
        this.lastState = state;
    }

    public boolean containsState(State state) {
        return state == this.lastState;
    }

    public AnnotationSet getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationSet annotationSet) {
        this.annotations = annotationSet;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean bl) {
        this.finished = bl;
    }

    private RuleModel findModel(State state) {
        Object object;
        RightHandSide rightHandSide = null;
        if (state.isFinal()) {
            rightHandSide = state.getAction();
        }
        ArrayList<State> arrayList = new ArrayList<State>();
        arrayList.add(state);
        while (rightHandSide == null) {
            ArrayList<State> arrayList2 = new ArrayList<State>();
            block1: for (int i = 0; i < arrayList.size(); ++i) {
                State state2 = (State)arrayList.get(i);
                for (Transition transition : state2.getTransitions()) {
                    object = transition.getTarget();
                    if (((State)object).isFinal()) {
                        rightHandSide = ((State)object).getAction();
                        continue block1;
                    }
                    arrayList2.add((State)object);
                }
            }
            arrayList = arrayList2;
        }
        for (int i = 0; i < ResourcesFactory.getPrRoot().getPRs().size(); ++i) {
            PrModel prModel = (PrModel)ResourcesFactory.getPrRoot().getPRs().get(i);
            for (int j = 0; j < prModel.getPhases().size(); ++j) {
                PhaseModel phaseModel = (PhaseModel)prModel.getPhases().get(j);
                for (int k = 0; k < phaseModel.getRules().size(); ++k) {
                    object = (RuleModel)phaseModel.getRules().get(k);
                    if (((RuleModel)object).getRHS() != rightHandSide) continue;
                    return object;
                }
            }
        }
        return null;
    }

    public void putPattern(Annotation annotation, FeatureMap featureMap) {
        this.patterns.put(annotation, featureMap);
    }

    public FeatureMap getPattern(Annotation annotation) {
        return (FeatureMap)this.patterns.get(annotation);
    }

    public void setOverrided(RuleModel ruleModel) {
        this.overrided = ruleModel;
    }

    public RuleModel getRuleModel() {
        return this.ruleModel;
    }

    public RuleModel getOverrided() {
        return this.overrided;
    }

    public String toString() {
        String string = "RuleTrace:";
        string = string + this.annotations.firstNode().getOffset().intValue() + "-" + this.annotations.lastNode().getOffset().intValue();
        string = string + "(";
        for (Annotation annotation : this.annotations) {
            string = string + annotation.toString();
        }
        string = string + ")";
        return string;
    }
}

