/*
 * Decompiled with CFR 0.152.
 */
package debugger.resources.pr;

import debugger.resources.ResourcesFactory;
import debugger.resources.pr.PhaseModel;
import debugger.resources.pr.PrModel;
import debugger.resources.pr.RuleAnnotationHistory;
import gate.Annotation;
import gate.AnnotationSet;
import gate.FeatureMap;
import gate.jape.RightHandSide;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class RuleModel {
    private HashMap bindings;
    private final RightHandSide rhs;
    private final RuleName ruleName;
    private final RuleAnnotationHistory annotationHistory;
    private boolean stopOnMatch = false;

    public RuleModel(RightHandSide rightHandSide) {
        this.rhs = rightHandSide;
        this.annotationHistory = new RuleAnnotationHistory();
        this.ruleName = new RuleName(this.rhs);
    }

    public String getName() {
        return this.ruleName.toString();
    }

    public RightHandSide getRHS() {
        return this.rhs;
    }

    public RuleAnnotationHistory getAnnotationHistory() {
        return this.annotationHistory;
    }

    public boolean isStopOnMatch() {
        return this.stopOnMatch;
    }

    public void setStopOnMatch(boolean bl) {
        this.stopOnMatch = bl;
    }

    public boolean equals(Object object) {
        if (object instanceof RuleModel) {
            return this.rhs.equals(((RuleModel)object).rhs);
        }
        return super.equals(object);
    }

    public void setBindings(HashMap hashMap) {
        this.bindings = hashMap;
    }

    public HashMap getBindings() {
        return this.bindings;
    }

    public ArrayList getMatshedRuleTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap hashMap = this.getBindings();
        if (null == hashMap) {
            return arrayList;
        }
        for (String string : hashMap.keySet()) {
            if (!string.startsWith("(")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public ArrayList getMatchedText() {
        ArrayList arrayList = this.getMatshedRuleTable();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap hashMap = this.getBindings();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = ((String)arrayList.get(i)).trim();
            Iterator iterator = hashMap.keySet().iterator();
            String string2 = "";
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!string3.startsWith("{") || !string3.equals(string)) continue;
                AnnotationSet annotationSet = (AnnotationSet)hashMap.get(string3);
                try {
                    Annotation annotation = this.neededAnnotation(annotationSet, string3);
                    if (null == annotation) break;
                    string2 = annotationSet.getDocument().getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            arrayList2.add(string2);
        }
        return arrayList2;
    }

    private Annotation neededAnnotation(AnnotationSet annotationSet, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "==");
        if (stringTokenizer.countTokens() != 1) {
            String string2 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                int n = string2.indexOf(".");
                if (n != -1 && !string2.substring(0, n).endsWith("Lookup") && !string2.substring(0, n).endsWith("Token")) {
                    string2 = string2.substring(n + 1);
                    arrayList.add(string2);
                }
                string2 = stringTokenizer.nextToken();
            }
        }
        boolean bl = true;
        for (Annotation annotation : annotationSet) {
            String string3 = annotation.getType();
            if (string.indexOf(string3) == -1) continue;
            FeatureMap featureMap = annotation.getFeatures();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string4 = (String)arrayList.get(i);
                if (featureMap.containsKey(string4)) continue;
                bl = false;
                break;
            }
            for (String string4 : featureMap.keySet()) {
                if (string.indexOf(string3 + "." + string4) == -1 || string.indexOf(string3 + "." + string4 + "==\"" + featureMap.get(string4) + "\"") != -1) continue;
                bl = false;
            }
            if (bl) {
                return annotation;
            }
            bl = true;
        }
        return null;
    }

    public ArrayList getMatchedAnnotations() {
        ArrayList arrayList = this.getMatshedRuleTable();
        ArrayList<Annotation> arrayList2 = new ArrayList<Annotation>();
        HashMap hashMap = this.getBindings();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = ((String)arrayList.get(i)).trim();
            Iterator iterator = hashMap.keySet().iterator();
            Annotation annotation = null;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.startsWith("{") || !string2.equals(string)) continue;
                AnnotationSet annotationSet = (AnnotationSet)hashMap.get(string2);
                try {
                    annotation = this.neededAnnotation(annotationSet, string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            arrayList2.add(annotation);
        }
        return arrayList2;
    }

    public PhaseModel getParentPhase() {
        ArrayList arrayList = ResourcesFactory.getPrRoot().getPRs();
        for (int i = 0; i < arrayList.size(); ++i) {
            PrModel prModel = (PrModel)arrayList.get(i);
            ArrayList arrayList2 = prModel.getPhases();
            for (int j = 0; j < arrayList2.size(); ++j) {
                PhaseModel phaseModel = (PhaseModel)arrayList2.get(j);
                ArrayList arrayList3 = phaseModel.getRules();
                for (int k = 0; k < arrayList3.size(); ++k) {
                    RuleModel ruleModel = (RuleModel)arrayList3.get(k);
                    if (ruleModel != this) continue;
                    return phaseModel;
                }
            }
        }
        return null;
    }

    public String getRuleText() {
        String string = "";
        String string2 = ResourcesFactory.getCurrentJapeText();
        if (string2 == null) {
            return "";
        }
        string2 = string2.substring(string2.toLowerCase().indexOf("rule"));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (string.equals("")) {
            n4 = string2.indexOf(" " + this.getName() + "\n");
            if (n4 == -1) {
                n4 = string2.indexOf(" " + this.getName() + " ");
            }
            if (n4 == -1) {
                n4 = string2.indexOf("\t" + this.getName() + " ");
            }
            if (n4 == -1) {
                n4 = string2.indexOf("\t" + this.getName() + "\n");
            }
            if (n4 == -1) {
                return "Unknoun text";
            }
            n = string2.substring(0, n4).lastIndexOf("/*");
            if (n != -1 && string2.substring(n, n4).indexOf("*/") == -1) {
                string2 = string2.substring(n4 + 2);
                continue;
            }
            n2 = string2.substring(0, n4).lastIndexOf("//");
            if (n2 != -1 && string2.substring(n2, n4).indexOf("\n") == -1) {
                string2 = string2.substring(n4 + 2);
                continue;
            }
            n3 = string2.substring(0, n4).toLowerCase().lastIndexOf("rule");
            if (n3 == (n4 = string2.substring(n3 + 1).toLowerCase().indexOf("Rule") + n3 + 1)) {
                n4 = string2.length();
            }
            string = string2.substring(n3, n4);
        }
        return string;
    }

    class RuleName {
        private final RightHandSide rhs;

        public RuleName(RightHandSide rightHandSide) {
            this.rhs = rightHandSide;
        }

        public String toString() {
            if (null == this.rhs) {
                return "RHS is null!";
            }
            if (null == this.rhs.getRuleName() || this.rhs.getRuleName().length() == 0) {
                return "Unnamed Rule";
            }
            return this.rhs.getRuleName();
        }

        public boolean equals(Object object) {
            if (null == object || null == this.rhs || null == this.rhs.getRuleName()) {
                return false;
            }
            if (object instanceof String) {
                return this.rhs.getRuleName().equals(object);
            }
            if (object instanceof RuleName) {
                return this.rhs.getRuleName().equals(((RuleName)object).rhs.getRuleName());
            }
            return false;
        }
    }
}

