/*
 * Decompiled with CFR 0.152.
 */
package debugger.resources.pr;

import debugger.ClassRipper;
import debugger.resources.pr.PhaseModel;
import gate.ProcessingResource;
import gate.creole.Transducer;
import gate.jape.Batch;
import gate.jape.MultiPhaseTransducer;
import gate.jape.SinglePhaseTransducer;
import java.util.ArrayList;

public class PrModel {
    private static byte DebugLevel = (byte)3;
    final ProcessingResource processingResource;
    final MultiPhaseTransducer transducer;
    private final PRName prName;
    private ArrayList phases = new ArrayList();

    public PrModel(ProcessingResource processingResource) {
        this.processingResource = processingResource;
        this.prName = new PRName(this.processingResource);
        this.transducer = PrModel.getMPTfromPR(this.processingResource);
        if (null != this.transducer) {
            ArrayList arrayList = this.transducer.getPhases();
            for (int i = 0; i < arrayList.size(); ++i) {
                SinglePhaseTransducer singlePhaseTransducer = (SinglePhaseTransducer)arrayList.get(i);
                this.phases.add(new PhaseModel(singlePhaseTransducer));
            }
        }
    }

    public String getName() {
        return this.prName.toString();
    }

    public MultiPhaseTransducer getTransducer() {
        return this.transducer;
    }

    public ProcessingResource getProcessingResource() {
        return this.processingResource;
    }

    public ArrayList getPhases() {
        return this.phases;
    }

    public PhaseModel getPhase(String string) {
        for (int i = 0; i < this.phases.size(); ++i) {
            PhaseModel phaseModel = (PhaseModel)this.phases.get(i);
            if (!phaseModel.getName().equals(string)) continue;
            return phaseModel;
        }
        return null;
    }

    public PhaseModel getPhase(SinglePhaseTransducer singlePhaseTransducer) {
        if (DebugLevel >= 4) {
            System.out.print("DEBUG [" + this.getClass().getName() + "]: ");
        }
        for (int i = 0; i < this.phases.size(); ++i) {
            PhaseModel phaseModel = (PhaseModel)this.phases.get(i);
            if (!phaseModel.containsSPT(singlePhaseTransducer)) continue;
            return phaseModel;
        }
        return null;
    }

    static MultiPhaseTransducer getMPTfromPR(ProcessingResource processingResource) {
        if (!(processingResource instanceof Transducer)) {
            return null;
        }
        try {
            Batch batch = (Batch)ClassRipper.getFieldValue(processingResource, "batch");
            gate.jape.Transducer transducer = batch.getTransducer();
            if (DebugLevel >= 4) {
                System.out.print("DEBUG [" + PrModel.class.getName() + "]: ");
                System.out.print("Batch Transducer: ");
                System.out.print("Name = [" + transducer.getName() + "]");
                System.out.print("BaseUrl = [" + transducer.getBaseURL() + "]");
                System.out.print("Class = [" + transducer.getClass() + "]");
                System.out.print("\n");
            }
            if (null != transducer && transducer instanceof MultiPhaseTransducer) {
                return (MultiPhaseTransducer)transducer;
            }
            return null;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PrModel) {
            return this.processingResource.equals(((PrModel)object).processingResource);
        }
        return super.equals(object);
    }

    class PRName {
        private final ProcessingResource pr;

        public PRName(ProcessingResource processingResource) {
            if (null == processingResource) {
                throw new RuntimeException("ProcessingResource is null!");
            }
            this.pr = processingResource;
        }

        public String toString() {
            if (null == this.pr.getName() || this.pr.getName().length() == 0) {
                return "Unnamed Resource";
            }
            return this.pr.getName();
        }

        public boolean equals(Object object) {
            if (null == object || null == this.pr || null == this.pr.getName()) {
                return false;
            }
            if (object instanceof String) {
                return this.pr.getName().equals(object);
            }
            if (object instanceof PRName) {
                return this.pr.getName().equals(((PRName)object).pr.getName());
            }
            return false;
        }
    }
}

