/*
 * Decompiled with CFR 0.152.
 */
package debugger.resources.pr;

import debugger.ClassRipper;
import debugger.resources.ResourcesFactory;
import debugger.resources.pr.RuleModel;
import gate.fsm.FSM;
import gate.fsm.State;
import gate.jape.RightHandSide;
import gate.jape.SinglePhaseTransducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;

public class PhaseModel {
    final SinglePhaseTransducer transducer;
    private final SPTName transducerName;
    ArrayList rules = new ArrayList();

    public ArrayList getRules() {
        return this.rules;
    }

    public PhaseModel(SinglePhaseTransducer singlePhaseTransducer) {
        this.transducer = singlePhaseTransducer;
        this.transducerName = new SPTName(this.transducer);
        this.rules = this.getPhaseRules(singlePhaseTransducer);
        this.transducer.setPhaseController(ResourcesFactory.getPhaseController());
    }

    public String getName() {
        return this.transducerName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList getPhaseRules(SinglePhaseTransducer singlePhaseTransducer) {
        ArrayList<RuleModel> arrayList = new ArrayList<RuleModel>();
        FSM fSM = singlePhaseTransducer.getFSM();
        try {
            Collection collection = (Collection)ClassRipper.getFieldValue(fSM, "allStates");
            ArrayList<RuleModel> arrayList2 = arrayList;
            synchronized (arrayList2) {
                for (State state : collection) {
                    if (!state.isFinal()) continue;
                    RightHandSide rightHandSide = state.getAction();
                    RuleModel ruleModel = new RuleModel(rightHandSide);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put(fSM.ruleHash.get(ruleModel.getName()), null);
                    ruleModel.setBindings(hashMap);
                    if (arrayList.contains(ruleModel)) continue;
                    arrayList.add(ruleModel);
                }
                Collections.sort(arrayList, new Comparator(){

                    public int compare(Object object, Object object2) {
                        String string = ((RuleModel)object).getName();
                        String string2 = ((RuleModel)object2).getName();
                        return string.compareToIgnoreCase(string2);
                    }
                });
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object instanceof PhaseModel) {
            return this.transducer.equals(((PhaseModel)object).transducer);
        }
        return super.equals(object);
    }

    public RuleModel getRule(String string) {
        for (int i = 0; i < this.rules.size(); ++i) {
            RuleModel ruleModel = (RuleModel)this.rules.get(i);
            if (!ruleModel.getName().equals(string)) continue;
            return ruleModel;
        }
        return null;
    }

    public RuleModel getRule(RightHandSide rightHandSide) {
        for (int i = 0; i < this.rules.size(); ++i) {
            RuleModel ruleModel = (RuleModel)this.rules.get(i);
            if (!ruleModel.getRHS().equals(rightHandSide)) continue;
            return ruleModel;
        }
        return null;
    }

    public boolean containsSPT(SinglePhaseTransducer singlePhaseTransducer) {
        return this.transducer.equals(singlePhaseTransducer);
    }

    public SinglePhaseTransducer getSPT() {
        return this.transducer;
    }

    public String getControl() {
        return this.transducer.getOption("control");
    }

    public Set getInput() {
        return this.getSPT().input;
    }

    class SPTName {
        private SinglePhaseTransducer tr;

        public SPTName(SinglePhaseTransducer singlePhaseTransducer) {
            if (null == singlePhaseTransducer) {
                throw new RuntimeException("SinglePhaseTransducer is null!");
            }
            this.tr = singlePhaseTransducer;
        }

        public String toString() {
            if (null == this.tr.getName() || this.tr.getName().length() == 0) {
                return "Unnamed Transducer";
            }
            return this.tr.getName();
        }

        public boolean equals(Object object) {
            if (null == object || null == this.tr || null == this.tr.getName()) {
                return false;
            }
            if (object instanceof String) {
                return this.tr.getName().equals(object);
            }
            if (object instanceof SPTName) {
                return this.tr.getName().equals(((SPTName)object).tr.getName());
            }
            return false;
        }
    }
}

