/*
 * Decompiled with CFR 0.152.
 */
package debugger.resources.pr;

import debugger.resources.pr.PhaseModel;
import debugger.resources.pr.PrModel;
import gate.Gate;
import gate.ProcessingResource;
import gate.jape.SinglePhaseTransducer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PRRoot {
    private ArrayList prs;

    public PRRoot() {
        if (null == Gate.getCreoleRegister()) {
            this.prs = new ArrayList();
        } else {
            this.prs = new ArrayList();
            List<ProcessingResource> list = Gate.getCreoleRegister().getPublicPrInstances();
            ArrayList<ProcessingResource> arrayList = new ArrayList<ProcessingResource>(list);
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    String string = ((ProcessingResource)object).getName();
                    String string2 = ((ProcessingResource)object2).getName();
                    return string.compareToIgnoreCase(string2);
                }
            });
            for (ProcessingResource processingResource : arrayList) {
                this.prs.add(new PrModel(processingResource));
            }
        }
    }

    public ArrayList getPRs() {
        return this.prs;
    }

    public PhaseModel getPhase(SinglePhaseTransducer singlePhaseTransducer) {
        for (int i = 0; i < this.prs.size(); ++i) {
            PrModel prModel = (PrModel)this.prs.get(i);
            if (prModel.getPhase(singlePhaseTransducer) == null) continue;
            return prModel.getPhase(singlePhaseTransducer);
        }
        return null;
    }
}

