/*
 * Decompiled with CFR 0.152.
 */
package debugger.resources.lr;

import debugger.resources.lr.CorpusModel;
import debugger.resources.lr.LrModel;
import gate.Corpus;
import gate.Document;
import gate.Gate;
import gate.LanguageResource;
import java.util.ArrayList;
import java.util.List;

public class LRRoot {
    private ArrayList corpora;

    public LRRoot() {
        List<LanguageResource> list = Gate.getCreoleRegister().getLrInstances();
        this.corpora = new ArrayList();
        ArrayList<LanguageResource> arrayList = new ArrayList<LanguageResource>();
        for (LanguageResource languageResource : list) {
            if (!(languageResource instanceof Document)) continue;
            arrayList.add(languageResource);
        }
        for (LanguageResource languageResource : list) {
            if (!(languageResource instanceof Corpus)) continue;
            ArrayList<LrModel> arrayList2 = new ArrayList<LrModel>();
            for (Document document : arrayList) {
                if (!((Corpus)languageResource).getDocumentNames().contains(document.getName())) continue;
                arrayList2.add(new LrModel(document));
            }
            this.corpora.add(new CorpusModel(arrayList2, languageResource.getName()));
        }
    }

    public LrModel getDocumentModel(Document document) {
        for (int i = 0; i < this.corpora.size(); ++i) {
            CorpusModel corpusModel = (CorpusModel)this.corpora.get(i);
            for (LrModel lrModel : corpusModel.getLrModels()) {
                if (!lrModel.getLr().equals(document)) continue;
                return lrModel;
            }
        }
        return null;
    }

    public ArrayList getCorpora() {
        return this.corpora;
    }
}

