/*
 * Decompiled with CFR 0.152.
 */
package debugger.resources;

import debugger.gui.GuiFactory;
import debugger.gui.actions.editor.ShowRuleInfoAction;
import debugger.gui.resources.ResourceTree;
import debugger.resources.JapeFile;
import debugger.resources.PhaseController;
import debugger.resources.lr.LRRoot;
import debugger.resources.lr.LrModel;
import debugger.resources.pr.PRRoot;
import debugger.resources.pr.RuleModel;
import javax.swing.tree.TreePath;

public class ResourcesFactory {
    private static LrModel currentLrModel;
    private static RuleModel currentRuleModel;
    private static PRRoot prRoot;
    private static LRRoot lrRoot;
    private static PhaseController phaseController;
    private static JapeFile currentJapeFile;
    private static String currentJapeText;

    public static PhaseController getPhaseController() {
        if (phaseController == null) {
            phaseController = new PhaseController();
        }
        return phaseController;
    }

    public static PRRoot getPrRoot() {
        if (null == prRoot) {
            prRoot = new PRRoot();
        }
        return prRoot;
    }

    public static void updateRoots() {
        prRoot = null;
        lrRoot = null;
    }

    public static LRRoot getLrRoot() {
        if (null == lrRoot) {
            lrRoot = new LRRoot();
        }
        return lrRoot;
    }

    public static RuleModel getCurrentRuleModel() {
        return currentRuleModel;
    }

    public static void setCurrentRuleModel(RuleModel ruleModel) {
        currentRuleModel = ruleModel;
        ResourceTree.PRTreeNode pRTreeNode = GuiFactory.getResourceView().getNode(ruleModel);
        Object[] objectArray = pRTreeNode.getPath();
        TreePath treePath = new TreePath(objectArray);
        GuiFactory.getResourceView().getTree().setSelectionPath(treePath);
        GuiFactory.getResourceView().getTree().revalidate();
        GuiFactory.getResourceView().getTree().repaint();
        ShowRuleInfoAction.getInstance().actionPerformed(ruleModel);
    }

    public static void setCurrentLrModel(LrModel lrModel) {
        currentLrModel = lrModel;
    }

    public static LrModel getCurrentLrModel() {
        return currentLrModel;
    }

    public static JapeFile getCurrentJapeFile() {
        return currentJapeFile;
    }

    public static String getCurrentJapeText() {
        return currentJapeText;
    }

    public static void setCurrentJapeText(String string) {
        currentJapeText = string;
    }

    public static void setCurrentJapeFile(JapeFile japeFile) {
        currentJapeFile = japeFile;
    }
}

