/*
 * Decompiled with CFR 0.152.
 */
package debugger.resources;

import debugger.ClassRipper;
import debugger.JapeDebugger;
import debugger.gui.GuiFactory;
import debugger.gui.actions.debugging.ExecuteRHSAction;
import debugger.gui.actions.debugging.GoNextBreakpointAction;
import debugger.gui.actions.resources.LrResourceSelectedAction;
import debugger.gui.actions.resources.RuleSelectedAction;
import debugger.resources.ResourcesFactory;
import debugger.resources.SPTLock;
import debugger.resources.pr.PhaseModel;
import debugger.resources.pr.RuleModel;
import debugger.resources.pr.TraceContainer;
import gate.AnnotationSet;
import gate.Document;
import gate.Gate;
import gate.VisualResource;
import gate.annotation.AnnotationSetImpl;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.SerialAnalyserController;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.gui.MainFrame;
import gate.gui.SerialControllerEditor;
import gate.jape.RightHandSide;
import gate.jape.SinglePhaseTransducer;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public class PhaseController
implements AnnotationSetListener {
    private static PhaseController ourInstance;
    private static int DebugLevel;
    private SPTLock sptLock;
    private boolean isStopAfterRHSExec;
    private AnnotationSet ruleAnnotations;
    private TraceContainer traceContainer = new TraceContainer();
    private SinglePhaseTransducer currentSPT;
    private RightHandSide currentRHS;

    public boolean isStopAfterRHSExec() {
        return this.isStopAfterRHSExec;
    }

    public void setStopAfterRHSExec(boolean bl) {
        this.isStopAfterRHSExec = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueSPT() {
        SPTLock sPTLock = this.sptLock;
        synchronized (sPTLock) {
            this.sptLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RuleMatched(SPTLock sPTLock, SinglePhaseTransducer singlePhaseTransducer, RightHandSide rightHandSide, Document document, HashMap hashMap, AnnotationSet annotationSet, AnnotationSet annotationSet2) {
        if (DebugLevel >= 5) {
            System.out.print("DEBUG [" + this.getClass().getName() + "]: ");
            System.out.println("RuleMatched(..) rhs phaseName/ruleName: [" + rightHandSide.getPhaseName() + "/" + rightHandSide.getRuleName() + "]");
        }
        this.sptLock = sPTLock;
        PhaseModel phaseModel = ResourcesFactory.getPrRoot().getPhase(singlePhaseTransducer);
        if (phaseModel == null) {
            return;
        }
        RuleModel ruleModel = phaseModel.getRule(rightHandSide.getRuleName());
        if (null != ruleModel && ruleModel.isStopOnMatch()) {
            if (DebugLevel >= 4) {
                System.out.print("DEBUG [" + this.getClass().getName() + "]: ");
                System.out.println("rule match break point catched! rhs phaseName/ruleName: [" + rightHandSide.getPhaseName() + "/" + rightHandSide.getRuleName() + "]");
            }
            ruleModel.setBindings(hashMap);
            LrResourceSelectedAction.getInstance().actionPerformed(ResourcesFactory.getLrRoot().getDocumentModel(document));
            RuleSelectedAction.getInstance().actionPerformed(ruleModel);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExecuteRHSAction.getInstance().setEnabled(true);
                    GoNextBreakpointAction.getInstance().setEnabled(true);
                    GuiFactory.getDebugPanel().selectJapeRulePanel();
                    JapeDebugger.getMainFrame().requestFocus();
                }
            });
            MainFrame.unlockGUI();
            document.getAnnotations().addAnnotationSetListener(this);
            this.ruleAnnotations = new AnnotationSetImpl(document);
            this.currentSPT = singlePhaseTransducer;
            this.currentRHS = rightHandSide;
            try {
                SPTLock sPTLock2 = sPTLock;
                synchronized (sPTLock2) {
                    sPTLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RuleFinished(SPTLock sPTLock, SinglePhaseTransducer singlePhaseTransducer, RightHandSide rightHandSide, Document document, HashMap hashMap, AnnotationSet annotationSet, AnnotationSet annotationSet2) {
        if (DebugLevel >= 5) {
            System.out.print("DEBUG [" + this.getClass().getName() + "]: ");
            System.out.println("RuleFinished(..) rhs phaseName/ruleName: [" + rightHandSide.getPhaseName() + "/" + rightHandSide.getRuleName() + "]");
        }
        this.sptLock = sPTLock;
        PhaseModel phaseModel = ResourcesFactory.getPrRoot().getPhase(singlePhaseTransducer);
        if (phaseModel == null) {
            return;
        }
        RuleModel ruleModel = phaseModel.getRule(rightHandSide.getRuleName());
        if (null != ruleModel) {
            Object object;
            if (DebugLevel >= 4) {
                System.out.print("DEBUG [" + this.getClass().getName() + "]: ");
                System.out.println("RHS executed! rhs phaseName/ruleName: [" + rightHandSide.getPhaseName() + "/" + rightHandSide.getRuleName() + "]");
            }
            if (ruleModel.isStopOnMatch()) {
                object = ruleModel;
                ((RuleModel)object).getAnnotationHistory().addAnnotationSet(this.ruleAnnotations);
                document.getAnnotations().removeAnnotationSetListener(this);
            }
            if (this.isStopAfterRHSExec) {
                if (this.currentSPT != singlePhaseTransducer || this.currentRHS != rightHandSide) {
                    throw new RuntimeException("Rule Finished called for another rule!!!");
                }
                ruleModel.setBindings(hashMap);
                LrResourceSelectedAction.getInstance().actionPerformed(ResourcesFactory.getLrRoot().getDocumentModel(document));
                RuleSelectedAction.getInstance().actionPerformed(ruleModel);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ExecuteRHSAction.getInstance().setEnabled(false);
                        GoNextBreakpointAction.getInstance().setEnabled(true);
                        GuiFactory.getDebugPanel().selectJapeRulePanel();
                        JapeDebugger.getMainFrame().requestFocus();
                    }
                });
                MainFrame.unlockGUI();
                try {
                    object = sPTLock;
                    synchronized (object) {
                        sPTLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public void annotationAdded(AnnotationSetEvent annotationSetEvent) {
        this.ruleAnnotations.add(annotationSetEvent.getAnnotation());
    }

    public void annotationRemoved(AnnotationSetEvent annotationSetEvent) {
        this.ruleAnnotations.remove(annotationSetEvent.getAnnotation());
    }

    public void runControllerButtonActionPerformed(ActionEvent actionEvent) {
        for (VisualResource visualResource : Gate.getCreoleRegister().getVrInstances()) {
            if (!(visualResource instanceof SerialControllerEditor)) continue;
            SerialAnalyserController serialAnalyserController = null;
            try {
                serialAnalyserController = (SerialAnalyserController)ClassRipper.getFieldValue(visualResource, "controller");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            if (serialAnalyserController == null) break;
            final SerialAnalyserController serialAnalyserController2 = serialAnalyserController;
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Gate.setExecutable(serialAnalyserController2);
                        serialAnalyserController2.execute();
                    }
                    catch (ExecutionInterruptedException executionInterruptedException) {
                        executionInterruptedException.printStackTrace();
                    }
                    catch (ExecutionException executionException) {
                        executionException.printStackTrace();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        Gate.setExecutable(null);
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "ApplicationViewer1");
            thread.setPriority(1);
            thread.start();
            break;
        }
    }

    public void TraceTransit(TraceContainer traceContainer) {
        this.traceContainer.addAll(traceContainer);
    }

    public TraceContainer getRuleTrace() {
        return this.traceContainer;
    }

    public SinglePhaseTransducer getSPT() {
        return null;
    }

    static {
        DebugLevel = 3;
    }
}

