/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.resources;

import debugger.resources.lr.LrModel;
import debugger.resources.pr.PrModel;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.jape.SinglePhaseTransducer;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ResourceTreeModel
extends DefaultTreeModel {
    private static int DebugLevel = 4;
    private DefaultMutableTreeNode prResources;
    private DefaultMutableTreeNode lrResources;

    private ResourceTreeModel(TreeNode treeNode) {
        super(treeNode);
    }

    public ResourceTreeModel() {
        super(ResourceTreeModel.createNewNode("Resources"));
        this.prResources = ResourceTreeModel.createNewNode("Processing Resources");
        ((DefaultMutableTreeNode)this.getRoot()).add(this.prResources);
        this.lrResources = ResourceTreeModel.createNewNode("Language Resources");
        ((DefaultMutableTreeNode)this.getRoot()).add(this.lrResources);
    }

    public static DefaultMutableTreeNode createNewNode(String string) {
        if (null == string) {
            string = "Undefined name";
        }
        return new DefaultMutableTreeNode(new String(string));
    }

    public Enumeration getPRResources() {
        return this.prResources.children();
    }

    public Enumeration getLrResources() {
        return this.lrResources.children();
    }

    public PrModel getPRResource(ProcessingResource processingResource) {
        Enumeration<TreeNode> enumeration = this.prResources.children();
        while (enumeration.hasMoreElements()) {
            PrModel prModel = (PrModel)((Object)enumeration.nextElement());
            if (!prModel.getProcessingResource().equals(processingResource)) continue;
            return prModel;
        }
        return null;
    }

    public PrModel getPRResource(String string) {
        Enumeration<TreeNode> enumeration = this.prResources.children();
        while (enumeration.hasMoreElements()) {
            PrModel prModel = (PrModel)((Object)enumeration.nextElement());
            if (!prModel.getName().equals(string)) continue;
            return prModel;
        }
        return null;
    }

    public PrModel getPRResource(SinglePhaseTransducer singlePhaseTransducer) {
        if (DebugLevel >= 5) {
            System.out.print("DEBUG [" + this.getClass().getName() + "]: ");
            System.out.println("getPrResource(SinglePhaseTransducer): SPT name [" + singlePhaseTransducer.getName() + "] child count = " + this.prResources.getChildCount());
        }
        Enumeration<TreeNode> enumeration = this.prResources.children();
        while (enumeration.hasMoreElements()) {
            PrModel prModel = (PrModel)((Object)enumeration.nextElement());
            if (null == prModel.getPhase(singlePhaseTransducer)) continue;
            return prModel;
        }
        return null;
    }

    public LrModel getLRResource(LanguageResource languageResource) {
        Enumeration<TreeNode> enumeration = this.lrResources.children();
        while (enumeration.hasMoreElements()) {
            LrModel lrModel = (LrModel)((Object)enumeration.nextElement());
            if (!lrModel.getLr().equals(languageResource)) continue;
            return lrModel;
        }
        return null;
    }

    public DefaultMutableTreeNode getPRResourcesNode() {
        return this.prResources;
    }

    public DefaultMutableTreeNode getLRResourcesNode() {
        return this.lrResources;
    }

    public void reloadProcessingResource(ProcessingResource processingResource) {
        this.reload();
    }
}

