/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.resources;

import debugger.gui.GuiFactory;
import debugger.gui.resources.ResourceTree;
import debugger.resources.ResourcesFactory;
import debugger.resources.lr.LRRoot;
import debugger.resources.pr.PRRoot;
import debugger.resources.pr.RuleModel;
import debugger.resources.pr.RuleTrace;
import debugger.resources.pr.TraceContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class ResourceTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private static Color RULE_SELECTION_COLOR = new Color(153, 204, 255);
    private static Color RULE_FINISHED_COLOR = new Color(153, 255, 204);
    private static Color RULE_TRIED_COLOR = Color.pink;
    private static Color RULE_OVERRIDED_COLOR = Color.yellow;
    private JCheckBox checkBox;
    private JLabel label;
    private long startIndex = 0L;
    private long endIndex = 0L;
    private boolean updateNeeded = false;
    private HashMap ruleColors = new HashMap();

    public ResourceTreeCellRenderer() {
        this.setLayout(new GridBagLayout());
        this.label = new JLabel();
        this.label.setFont(new Font("Arial", 0, 11));
        this.label.setForeground(Color.black);
        this.checkBox = new JCheckBox();
        this.checkBox.setBackground(Color.white);
        this.initGui(false);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        boolean bl5 = false;
        if (bl) {
            this.setBackground(RULE_SELECTION_COLOR);
            this.checkBox.setBackground(RULE_SELECTION_COLOR);
            this.label.setBackground(RULE_SELECTION_COLOR);
        } else {
            this.setBackground(Color.white);
            this.checkBox.setBackground(Color.white);
            this.label.setBackground(Color.white);
        }
        this.setToolTipText("");
        if (object instanceof ResourceTree.PRTreeNode && ((ResourceTree.PRTreeNode)object).getPRResource() instanceof PRRoot || object instanceof ResourceTree.LRTreeNode && ((ResourceTree.LRTreeNode)object).getLRResource() instanceof LRRoot) {
            this.initGui(false);
            bl5 = false;
        }
        if (object instanceof ResourceTree.PRTreeNode && ((ResourceTree.PRTreeNode)object).getPRResource() instanceof RuleModel) {
            RuleModel ruleModel = (RuleModel)((ResourceTree.PRTreeNode)object).getPRResource();
            this.initGui(true);
            bl5 = true;
            if (ruleModel.isStopOnMatch()) {
                this.checkBox.setSelected(true);
            } else {
                this.checkBox.setSelected(false);
            }
            if (this.updateNeeded) {
                this.ruleColors = new HashMap();
                TraceContainer traceContainer = ResourcesFactory.getPhaseController().getRuleTrace().getTraceByOffset(new Long(this.startIndex), new Long(this.endIndex));
                for (RuleTrace ruleTrace : traceContainer) {
                    RuleModel ruleModel2 = ruleTrace.getRuleModel();
                    TraceContainer traceContainer2 = traceContainer.getTraceByRuleModel(ruleModel2);
                    if (traceContainer2.size() == 1) {
                        RuleTrace ruleTrace2 = (RuleTrace)traceContainer2.iterator().next();
                        if (ruleTrace2.isFinished() && ruleTrace2.getOverrided() == null) {
                            this.ruleColors.put(ruleModel2, RULE_FINISHED_COLOR);
                        }
                        if (ruleTrace2.isFinished() && ruleTrace2.getOverrided() != null) {
                            this.ruleColors.put(ruleModel2, RULE_OVERRIDED_COLOR);
                        }
                        if (ruleTrace2.isFinished()) continue;
                        this.ruleColors.put(ruleModel2, RULE_TRIED_COLOR);
                        continue;
                    }
                    this.ruleColors.put(ruleModel2, traceContainer2);
                }
                this.updateNeeded = false;
            } else {
                Object v = this.ruleColors.get(ruleModel);
                if (v instanceof Color) {
                    this.label.setBackground((Color)v);
                    this.setBackground((Color)v);
                    if (v.equals(RULE_OVERRIDED_COLOR)) {
                        TraceContainer traceContainer = ResourcesFactory.getPhaseController().getRuleTrace().getTraceByOffset(new Long(this.startIndex), new Long(this.endIndex));
                        if ((traceContainer = traceContainer.getTraceByRuleModel(ruleModel)).size() == 1) {
                            RuleTrace ruleTrace = (RuleTrace)traceContainer.iterator().next();
                            this.setToolTipText("Overrided by: " + ruleTrace.getOverrided().getName());
                        }
                    }
                } else if (v instanceof TraceContainer) {
                    RuleModel ruleModel3 = GuiFactory.getDebugPanel().getTraceHistoryPanel().getCurrentRuleModel();
                    if (ruleModel3 != null && ruleModel3.equals(ruleModel)) {
                        RuleTrace ruleTrace = GuiFactory.getDebugPanel().getTraceHistoryPanel().getCurrentRuleTrace();
                        if (ruleTrace != null) {
                            if (ruleTrace.isFinished() && ruleTrace.getOverrided() == null) {
                                this.label.setBackground(RULE_FINISHED_COLOR);
                                this.setBackground(RULE_FINISHED_COLOR);
                            }
                            if (ruleTrace.isFinished() && ruleTrace.getOverrided() != null) {
                                this.label.setBackground(RULE_OVERRIDED_COLOR);
                                this.setBackground(RULE_OVERRIDED_COLOR);
                                this.setToolTipText("Overrided by: " + ruleTrace.getOverrided().getName());
                            }
                            if (!ruleTrace.isFinished()) {
                                this.label.setBackground(RULE_TRIED_COLOR);
                                this.setBackground(RULE_TRIED_COLOR);
                            }
                        } else {
                            RuleTrace ruleTrace3 = (RuleTrace)((TraceContainer)v).iterator().next();
                            if (ruleTrace3.isFinished() && ruleTrace3.getOverrided() == null) {
                                this.label.setBackground(RULE_FINISHED_COLOR);
                                this.setBackground(RULE_FINISHED_COLOR);
                            }
                            if (ruleTrace3.isFinished() && ruleTrace3.getOverrided() != null) {
                                this.label.setBackground(RULE_OVERRIDED_COLOR);
                                this.setBackground(RULE_OVERRIDED_COLOR);
                                this.setToolTipText("Overrided by: " + ruleTrace3.getOverrided().getName());
                            }
                            if (!ruleTrace3.isFinished()) {
                                this.label.setBackground(RULE_TRIED_COLOR);
                                this.setBackground(RULE_TRIED_COLOR);
                            }
                        }
                    } else {
                        RuleTrace ruleTrace = (RuleTrace)((TraceContainer)v).iterator().next();
                        if (ruleTrace.isFinished() && ruleTrace.getOverrided() == null) {
                            this.label.setBackground(RULE_FINISHED_COLOR);
                            this.setBackground(RULE_FINISHED_COLOR);
                        }
                        if (ruleTrace.isFinished() && ruleTrace.getOverrided() != null) {
                            this.label.setBackground(RULE_OVERRIDED_COLOR);
                            this.setBackground(RULE_OVERRIDED_COLOR);
                            this.setToolTipText("Overrided by: " + ruleTrace.getOverrided().getName());
                        }
                        if (!ruleTrace.isFinished()) {
                            this.label.setBackground(RULE_TRIED_COLOR);
                            this.setBackground(RULE_TRIED_COLOR);
                        }
                    }
                }
            }
        } else {
            this.initGui(false);
            bl5 = false;
        }
        this.label.setText(object.toString());
        int n2 = 0;
        if (bl5) {
            n2 = 19;
        }
        this.setPreferredSize(new Dimension(this.label.getFontMetrics(this.label.getFont()).stringWidth(this.label.getText()) + n2 + 4, this.label.getFontMetrics(this.label.getFont()).getHeight()));
        this.revalidate();
        this.repaint();
        return this;
    }

    private void initGui(boolean bl) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 1);
        if (bl) {
            this.add((Component)this.checkBox, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add((Component)this.label, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            this.add((Component)jPanel, gridBagConstraints);
        } else {
            this.add((Component)this.label, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            this.add((Component)jPanel, gridBagConstraints);
        }
    }

    public void setIndexes(int n, int n2) {
        this.startIndex = n;
        this.endIndex = n2;
        this.updateNeeded = true;
    }
}

