/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.resources;

import debugger.gui.GuiFactory;
import debugger.gui.actions.resources.LrResourceSelectedAction;
import debugger.gui.resources.CreoleListenerImpl;
import debugger.gui.resources.ResourceTreeCellRenderer;
import debugger.resources.ResourcesFactory;
import debugger.resources.lr.CorpusModel;
import debugger.resources.lr.LRRoot;
import debugger.resources.lr.LrModel;
import debugger.resources.pr.PRRoot;
import debugger.resources.pr.PhaseModel;
import debugger.resources.pr.PrModel;
import debugger.resources.pr.RuleModel;
import gate.Gate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ResourceTree
extends JComponent {
    private JTree tree;

    public ResourceTree() {
        this.init();
        this.initListeners();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void refresh() {
        this.removeAll();
        this.init();
        this.initListeners();
        this.revalidate();
    }

    public PRTreeNode getNode(RuleModel ruleModel) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof PRTreeNode)) continue;
            return ((PRTreeNode)treeNode).getNode(ruleModel);
        }
        return null;
    }

    private void init() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(){
            {
                this.children = new Vector();
                this.add(new PRTreeNode(ResourcesFactory.getPrRoot()));
                this.add(new LRTreeNode(ResourcesFactory.getLrRoot()));
            }

            public String toString() {
                return "Resources";
            }
        };
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.setCellRenderer(new ResourceTreeCellRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree, 20, 31), "Center");
        Gate.addCreoleListener(CreoleListenerImpl.getInstance(this));
    }

    private void initListeners() {
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = ResourceTree.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                Object object = null;
                if (treePath != null) {
                    object = treePath.getLastPathComponent();
                    Rectangle rectangle = ResourceTree.this.tree.getPathBounds(treePath);
                    Component component = ResourceTree.this.tree.getCellRenderer().getTreeCellRendererComponent(ResourceTree.this.tree, object, true, false, true, 0, true);
                    component.setBounds(rectangle);
                    Component component2 = component.getComponentAt(mouseEvent.getX() - rectangle.x + 5, mouseEvent.getY() - rectangle.y);
                    if (object instanceof PRTreeNode && component2 instanceof JCheckBox) {
                        RuleModel ruleModel = (RuleModel)((PRTreeNode)object).getPRResource();
                        if (ruleModel.isStopOnMatch()) {
                            ruleModel.setStopOnMatch(false);
                        } else {
                            ruleModel.setStopOnMatch(true);
                        }
                    }
                    if (object instanceof LRTreeNode && ((LRTreeNode)object).getLRResource() instanceof LrModel) {
                        LrResourceSelectedAction.getInstance().actionPerformed((LrModel)((LRTreeNode)object).getLRResource());
                    }
                    if (object instanceof PRTreeNode && ((PRTreeNode)object).getPRResource() instanceof RuleModel) {
                        ResourcesFactory.setCurrentRuleModel((RuleModel)((PRTreeNode)object).getPRResource());
                    }
                    if (object instanceof PRTreeNode && ((PRTreeNode)object).getPRResource() instanceof PhaseModel) {
                        GuiFactory.getDebugPanel().getTraceHistoryPanel().setCurrentPhase((PhaseModel)((PRTreeNode)object).getPRResource());
                    }
                }
                ResourceTree.this.repaint();
            }
        });
    }

    public ResourceTreeCellRenderer getResourceTreeCellRenderer() {
        return (ResourceTreeCellRenderer)this.tree.getCellRenderer();
    }

    class LRTreeNode
    extends DefaultMutableTreeNode {
        private Object languageResource;

        public LRTreeNode(Object object) {
            this.languageResource = object;
            this.children = this.getChildren();
        }

        public String toString() {
            if (this.languageResource instanceof LRRoot) {
                return "Language Resources";
            }
            if (this.languageResource instanceof CorpusModel) {
                return this.languageResource.toString();
            }
            if (this.languageResource instanceof LrModel) {
                return this.languageResource.toString();
            }
            return "";
        }

        public Object getLRResource() {
            return this.languageResource;
        }

        private Vector getChildren() {
            if (this.languageResource instanceof LRRoot) {
                Vector<LRTreeNode> vector = new Vector<LRTreeNode>();
                for (CorpusModel corpusModel : ((LRRoot)this.languageResource).getCorpora()) {
                    vector.add(new LRTreeNode(corpusModel));
                }
                return vector;
            }
            if (this.languageResource instanceof CorpusModel) {
                Vector<LRTreeNode> vector = new Vector<LRTreeNode>();
                for (LrModel lrModel : ((CorpusModel)this.languageResource).getLrModels()) {
                    vector.add(new LRTreeNode(lrModel));
                }
                return vector;
            }
            return new Vector();
        }
    }

    public class PRTreeNode
    extends DefaultMutableTreeNode {
        private Object prResource;

        public PRTreeNode(Object object) {
            this.prResource = object;
            this.children = new Vector();
            this.getChildren();
        }

        public Object getPRResource() {
            return this.prResource;
        }

        public PRTreeNode getNode(RuleModel ruleModel) {
            if (this.prResource.equals(ruleModel)) {
                return this;
            }
            for (PRTreeNode pRTreeNode : this.children) {
                PRTreeNode pRTreeNode2 = pRTreeNode.getNode(ruleModel);
                if (null == pRTreeNode2) continue;
                return pRTreeNode2;
            }
            return null;
        }

        public String toString() {
            if (this.prResource instanceof PRRoot) {
                return "Processing Resources";
            }
            if (this.prResource instanceof PrModel) {
                return ((PrModel)this.prResource).getName();
            }
            if (this.prResource instanceof PhaseModel) {
                return ((PhaseModel)this.prResource).getName();
            }
            if (this.prResource instanceof RuleModel) {
                return ((RuleModel)this.prResource).getName();
            }
            return "";
        }

        private Vector getChildren() {
            if (this.prResource instanceof PRRoot) {
                return new Vector(this.createNodesFromChildren(((PRRoot)this.prResource).getPRs()));
            }
            if (this.prResource instanceof PrModel) {
                return new Vector(this.createNodesFromChildren(((PrModel)this.prResource).getPhases()));
            }
            if (this.prResource instanceof PhaseModel) {
                return new Vector(this.createNodesFromChildren(((PhaseModel)this.prResource).getRules()));
            }
            return new Vector();
        }

        private Collection createNodesFromChildren(Collection collection) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.add(new PRTreeNode(iterator.next()));
            }
            return arrayList;
        }
    }
}

