/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.resources;

import debugger.gui.resources.ResourceTree;
import debugger.resources.ResourcesFactory;
import gate.Corpus;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;

public class CreoleListenerImpl
implements CreoleListener,
CorpusListener {
    private static CreoleListenerImpl ourInstance;
    private static ResourceTree resourceTree;

    public static synchronized CreoleListenerImpl getInstance(ResourceTree resourceTree) {
        if (ourInstance == null) {
            ourInstance = new CreoleListenerImpl();
            CreoleListenerImpl.resourceTree = resourceTree;
        }
        return ourInstance;
    }

    private CreoleListenerImpl() {
        for (LanguageResource languageResource : Gate.getCreoleRegister().getLrInstances()) {
            if (!(languageResource instanceof Corpus)) continue;
            ((Corpus)languageResource).addCorpusListener(this);
        }
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
        if (creoleEvent.getResource() instanceof ProcessingResource || creoleEvent.getResource() instanceof Corpus) {
            ResourcesFactory.updateRoots();
            resourceTree.refresh();
            if (creoleEvent.getResource() instanceof Corpus) {
                ((Corpus)creoleEvent.getResource()).addCorpusListener(this);
            }
        }
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        if (creoleEvent.getResource() instanceof ProcessingResource || creoleEvent.getResource() instanceof LanguageResource) {
            ResourcesFactory.updateRoots();
            resourceTree.refresh();
        }
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
        if (resource instanceof ProcessingResource || resource instanceof LanguageResource) {
            ResourcesFactory.updateRoots();
            resourceTree.refresh();
        }
    }

    public void documentAdded(CorpusEvent corpusEvent) {
        ResourcesFactory.updateRoots();
        resourceTree.refresh();
    }

    public void documentRemoved(CorpusEvent corpusEvent) {
        ResourcesFactory.updateRoots();
        resourceTree.refresh();
    }
}

