/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.editor;

import debugger.JapeDebugger;
import debugger.gui.actions.editor.ShowResultAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class DocumentEditor
extends JComponent {
    private JTextPane textPane;
    private JButton showResultButton;

    public DocumentEditor() {
        this.initGui();
        this.initListeners();
    }

    public void setTextSelection(Color color, int n, int n2) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBackground(simpleAttributeSet, new Color(210, 210, 210));
        ((DefaultStyledDocument)this.textPane.getDocument()).setCharacterAttributes(0, n, simpleAttributeSet, false);
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBackground(simpleAttributeSet, Color.white);
        ((DefaultStyledDocument)this.textPane.getDocument()).setCharacterAttributes(n2, this.textPane.getDocument().getLength() - n2, simpleAttributeSet, false);
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBackground(simpleAttributeSet, color);
        ((DefaultStyledDocument)this.textPane.getDocument()).setCharacterAttributes(n, n2 - n, simpleAttributeSet, false);
        try {
            this.textPane.scrollRectToVisible(this.textPane.modelToView(n));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void setTextFont(String string, int n, int n2, int n3) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(simpleAttributeSet, string);
        StyleConstants.setFontSize(simpleAttributeSet, n);
        ((DefaultStyledDocument)this.textPane.getDocument()).setCharacterAttributes(n2, n3 - n2, simpleAttributeSet, false);
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    private void initGui() {
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setCaret(new DefaultCaret(){

            protected void adjustVisibility(Rectangle rectangle) {
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        ImageIcon imageIcon = new ImageIcon(JapeDebugger.class.getResource("gui/icons/go.png"));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
        this.showResultButton = new JButton();
        this.showResultButton.setIcon(imageIcon);
        this.showResultButton.setPreferredSize(new Dimension(20, 20));
        this.showResultButton.setEnabled(false);
        jPanel.add(this.showResultButton);
        this.add((Component)jPanel, "West");
        this.add((Component)new JScrollPane(this.textPane, 22, 31), "Center");
    }

    private void initListeners() {
        this.showResultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShowResultAction.getInstance().actionPerformed(DocumentEditor.this.textPane.getSelectionStart(), DocumentEditor.this.textPane.getSelectionEnd());
            }
        });
        this.textPane.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (DocumentEditor.this.textPane.getSelectedText() == null) {
                    DocumentEditor.this.showResultButton.setEnabled(false);
                } else {
                    DocumentEditor.this.showResultButton.setEnabled(true);
                }
            }
        });
        this.textPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (DocumentEditor.this.textPane.getSelectedText() == null) {
                    DocumentEditor.this.showResultButton.setEnabled(false);
                } else {
                    DocumentEditor.this.showResultButton.setEnabled(true);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }
        });
    }
}

