/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.debugging.debugviews;

import debugger.gui.debugging.debugviews.InfoWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;

public class PrimaryTextPanel
extends JPanel {
    public static final int OPEN_NONE = 0;
    public static final int OPEN_LEFT = 1;
    public static final int OPEN_RIGHT = 2;
    public static final int OPEN_BOTH = 3;
    private boolean isHighlighted = false;
    private boolean red = false;
    private String text = "";
    private Font font = new Font("Arial", 0, 11);
    private int openMode = 0;
    private ArrayList annotations = null;
    private InfoWindow infoWindow = null;
    private boolean textVisible = true;

    public boolean isRed() {
        return this.red;
    }

    public void setRed(boolean bl) {
        this.red = bl;
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public void setTextVisible(boolean bl) {
        this.textVisible = bl;
    }

    public PrimaryTextPanel(String string, boolean bl, int n) {
        this.text = string;
        this.isHighlighted = bl;
        this.openMode = n;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (PrimaryTextPanel.this.infoWindow == null) {
                    PrimaryTextPanel.this.infoWindow = new InfoWindow(PrimaryTextPanel.this, null);
                    int n = PrimaryTextPanel.this.getLocationOnScreen().x;
                    int n2 = PrimaryTextPanel.this.getLocationOnScreen().y;
                    Dimension dimension = PrimaryTextPanel.this.getSize();
                    if (n + ((PrimaryTextPanel)PrimaryTextPanel.this).infoWindow.getSize().width < Toolkit.getDefaultToolkit().getScreenSize().width) {
                        PrimaryTextPanel.this.infoWindow.setLocation(n, n2 + (int)dimension.getHeight());
                    } else {
                        PrimaryTextPanel.this.infoWindow.setLocation(n + dimension.width - ((PrimaryTextPanel)PrimaryTextPanel.this).infoWindow.getSize().width, n2 + (int)dimension.getHeight());
                    }
                    PrimaryTextPanel.this.infoWindow.setVisible(true);
                } else if (!PrimaryTextPanel.this.infoWindow.isVisible()) {
                    int n = PrimaryTextPanel.this.getLocationOnScreen().x;
                    int n3 = PrimaryTextPanel.this.getLocationOnScreen().y;
                    Dimension dimension = PrimaryTextPanel.this.getSize();
                    if (n + ((PrimaryTextPanel)PrimaryTextPanel.this).infoWindow.getSize().width < Toolkit.getDefaultToolkit().getScreenSize().width) {
                        PrimaryTextPanel.this.infoWindow.setLocation(n, n3 + (int)dimension.getHeight());
                    } else {
                        PrimaryTextPanel.this.infoWindow.setLocation(n + dimension.width - ((PrimaryTextPanel)PrimaryTextPanel.this).infoWindow.getSize().width, n3 + (int)dimension.getHeight());
                    }
                    PrimaryTextPanel.this.infoWindow.setVisible(true);
                }
            }
        });
    }

    public ArrayList getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(ArrayList arrayList) {
        this.annotations = arrayList;
    }

    public void setOpenMode(int n) {
        this.openMode = n;
    }

    public int getOpenMode() {
        return this.openMode;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void setHighlighted(boolean bl) {
        this.isHighlighted = bl;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (!this.isHighlighted) {
            if (this.textVisible) {
                graphics.setColor(Color.gray);
            } else {
                graphics.setColor(new Color(200, 200, 200));
            }
            graphics.fillRect(0, 0, n - 1, n2 - 1);
            graphics.setColor(new Color(200, 200, 200));
            if (this.openMode == 0) {
                graphics.fillRect(1, 1, n - 3, n2 - 3);
            } else if (this.openMode == 2) {
                graphics.fillRect(1, 1, n - 1, n2 - 3);
            } else if (this.openMode == 1) {
                graphics.fillRect(0, 1, n - 2, n2 - 3);
            } else if (this.openMode == 3) {
                graphics.fillRect(0, 1, n, n2 - 3);
            }
        } else if (!this.red) {
            graphics.setColor(new Color(51, 204, 51));
            graphics.fillRect(0, 0, n - 1, n2 - 1);
            if (this.openMode == 0) {
                graphics.fillRect(1, 1, n - 3, n2 - 3);
            } else if (this.openMode == 2) {
                graphics.fillRect(1, 1, n - 1, n2 - 3);
            } else if (this.openMode == 1) {
                graphics.fillRect(0, 1, n - 2, n2 - 3);
            } else if (this.openMode == 3) {
                graphics.fillRect(0, 1, n, n2 - 3);
            }
        }
        if (!this.isHighlighted && this.red) {
            graphics.setColor(new Color(204, 51, 51));
            graphics.fillRect(0, 0, n - 1, n2 - 1);
            graphics.setColor(new Color(220, 220, 220));
            if (this.openMode == 0) {
                graphics.fillRect(1, 1, n - 3, n2 - 3);
            } else if (this.openMode == 2) {
                graphics.fillRect(1, 1, n - 1, n2 - 3);
            } else if (this.openMode == 1) {
                graphics.fillRect(0, 1, n - 2, n2 - 3);
            } else if (this.openMode == 3) {
                graphics.fillRect(0, 1, n, n2 - 3);
            }
        }
        if (this.textVisible) {
            graphics.setColor(Color.black);
        }
        graphics.setFont(this.font);
        graphics.drawString(this.text, 3, n2 - 6);
    }

    public Dimension getSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(this.text);
        int n2 = fontMetrics.getAscent();
        return new Dimension(n + 6, n2 + 6);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public Dimension getMaximumSize() {
        return this.getSize();
    }
}

