/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.debugging;

import debugger.gui.debugging.debugviews.LHSModel;
import debugger.gui.debugging.debugviews.RHSModel;
import debugger.resources.ResourcesFactory;
import gate.Annotation;
import gate.FeatureMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class RulePanel
extends JPanel {
    private JPanel LHS;
    private JPanel RHS;
    private JLabel jlbRuleName;
    private LHSModel lhsModel;
    private RHSModel rhsModel;
    private JTable jtLHS;
    private JTable jtRHS;

    public RulePanel() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.jlbRuleName = new JLabel("Undefined rule");
        this.add((Component)this.jlbRuleName, "North");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 1;
        this.LHS = this.createLHSView();
        JScrollPane jScrollPane = new JScrollPane(this.LHS);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Left Hand Side"));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 1;
        this.RHS = this.createRHSView();
        JScrollPane jScrollPane2 = new JScrollPane(this.RHS);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(30);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Created Annotations"));
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        this.add((Component)jPanel, "Center");
    }

    public void ruleSelected() {
        if (null == ResourcesFactory.getCurrentRuleModel()) {
            return;
        }
        this.jlbRuleName.setText(ResourcesFactory.getCurrentRuleModel().getName());
        this.jtLHS.updateUI();
        this.jtRHS.updateUI();
    }

    public JPanel createLHSView() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lhsModel = new LHSModel();
        this.jtLHS = new JTable(this.lhsModel);
        this.jtLHS.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                String string = "";
                int n = RulePanel.this.jtLHS.rowAtPoint(mouseEvent.getPoint());
                Annotation annotation = (Annotation)ResourcesFactory.getCurrentRuleModel().getMatchedAnnotations().get(n);
                if (null != annotation) {
                    string = string + "{";
                    String string2 = annotation.getType();
                    FeatureMap featureMap = annotation.getFeatures();
                    Iterator iterator = featureMap.keySet().iterator();
                    if (!iterator.hasNext()) {
                        string = string + annotation.getType() + ", ";
                    }
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        string = string + string2 + "." + string3 + "=" + featureMap.get(string3) + ", ";
                    }
                    string = string.substring(0, string.length() - 2);
                    string = string + "}";
                    RulePanel.this.jtLHS.setToolTipText(string);
                } else {
                    RulePanel.this.jtLHS.setToolTipText("");
                }
            }
        });
        jPanel.add((Component)this.jtLHS.getTableHeader(), "North");
        jPanel.add((Component)this.jtLHS, "South");
        return jPanel;
    }

    public JPanel createRHSView() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.rhsModel = new RHSModel();
        this.jtRHS = new JTable(this.rhsModel);
        this.jtRHS.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.jtRHS.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.jtRHS.getColumnModel().getColumn(2).setPreferredWidth(100);
        jPanel.add((Component)this.jtRHS.getTableHeader(), "North");
        jPanel.add((Component)this.jtRHS, "Center");
        return jPanel;
    }
}

