/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.debugging;

import debugger.gui.debugging.JapeSourcePanel;
import debugger.gui.debugging.PhasePanel;
import debugger.gui.debugging.RulePanel;
import debugger.gui.debugging.TraceHistoryPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MainDebugPanel
extends JPanel {
    private JTabbedPane tabbedPane;
    private JapeSourcePanel japeSourcePanel;
    private RulePanel rulePanel;
    private PhasePanel phasePanel;
    private TraceHistoryPanel traceHistoryPanel;

    public MainDebugPanel() {
        this.initGui();
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPhasePanel(), "North");
        this.add((Component)this.getTabbedPane(), "Center");
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Trace History", this.getTraceHistoryPanel());
            this.tabbedPane.addTab("Jape Rule", this.getRulePanel());
            this.tabbedPane.addTab("Jape Source", this.getJapeSourcePanel());
        }
        return this.tabbedPane;
    }

    public JapeSourcePanel getJapeSourcePanel() {
        if (this.japeSourcePanel == null) {
            this.japeSourcePanel = new JapeSourcePanel();
        }
        return this.japeSourcePanel;
    }

    public RulePanel getRulePanel() {
        if (this.rulePanel == null) {
            this.rulePanel = new RulePanel();
        }
        return this.rulePanel;
    }

    public PhasePanel getPhasePanel() {
        if (this.phasePanel == null) {
            this.phasePanel = new PhasePanel();
        }
        return this.phasePanel;
    }

    public TraceHistoryPanel getTraceHistoryPanel() {
        if (this.traceHistoryPanel == null) {
            this.traceHistoryPanel = new TraceHistoryPanel();
        }
        return this.traceHistoryPanel;
    }

    public void selectJapeRulePanel() {
        this.tabbedPane.setSelectedComponent(this.getRulePanel());
    }

    public void selectTraceHisoryPanel() {
        this.tabbedPane.setSelectedComponent(this.getTraceHistoryPanel());
    }

    public void selectJapeSourcePanel() {
        this.tabbedPane.setSelectedComponent(this.getJapeSourcePanel());
    }
}

